/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import java.util.Arrays;
import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class UKEnglishNumber
extends SpokenNumber {
    protected static final String[][] field = new String[][]{{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine"}, {"eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"}, {"ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"}};
    protected static final String NULL = "zero";
    protected static final String MINUS = "minus";
    protected static final String AND = "and";
    protected static final String HUNDRED = "hundred";
    protected static final String DASH = "-";
    private static final String[] amountUK = new String[]{"thousand", "million", "thousand million", "billion", "thousand billion", "trillion", "thousand trillion", "quadrillion", "thousand quadrillion", "quintillion", "thousand quintillion", "sextillion", "thousand sextillion", "septillion", "thousand septillion", "octillion", "thousand octillion", "nonillion", "thousand nonillion", "decillion", "thousand decillion", "undecillion", "thousand undecillion", "duodecillion", "thousand duodecillion", "tredecillion", "thousand tredecillion", "quattuordecillion", "thousand quattuordecillion", "quindecillion", "thousand quindecillion"};

    public UKEnglishNumber() {
    }

    public UKEnglishNumber(long number) throws Exception {
        super(number);
    }

    public UKEnglishNumber(String number) throws Exception {
        super(number);
    }

    @Override
    protected int getSupportedDigits() {
        return 96;
    }

    @Override
    public String getSoundDir() {
        return "uk_english";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        this.convert2Syllables(amountUK);
    }

    protected void convert2Syllables(String[] amount) {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add(MINUS);
        }
        if (this.numberType == 0) {
            this.number2digits();
            if (this.number.equals("0")) {
                this.syllables.add(NULL);
            } else {
                int counter = amount.length - 1;
                for (int i = this.MAX_DIGITS - 3; i > 0; i -= 3) {
                    this.xtriple(i, amount[counter--]);
                }
                this.triple(0);
            }
        } else if (this.numberType == 1) {
            this.fillSyllables(NULL, field[0]);
        }
    }

    protected boolean isGreaterThan100() {
        for (int i = 2; i < this.MAX_DIGITS; ++i) {
            if (this.digits[i] <= 0) continue;
            return true;
        }
        return false;
    }

    protected void triple(int index) {
        if (this.digits[index + 2] > 0) {
            this.syllables.add(field[0][this.digits[index + 2] - 1]);
            this.syllables.add(HUNDRED);
        }
        if (index == 0 && this.digits[0] + this.digits[1] != 0 && this.isGreaterThan100()) {
            this.syllables.add(AND);
        }
        if (this.digits[index + 1] == 1 && this.digits[index] > 0) {
            this.syllables.add(field[1][this.digits[index] - 1]);
        } else if (this.digits[index + 1] >= 1 && this.digits[index] == 0) {
            this.syllables.add(field[2][this.digits[index + 1] - 1]);
        } else {
            if (this.digits[index + 1] > 0) {
                this.syllables.add(field[2][this.digits[index + 1] - 1]);
                if (this.digits[index] > 0) {
                    this.syllables.add(DASH);
                }
            }
            if (this.digits[index] > 0) {
                this.syllables.add(field[0][this.digits[index] - 1]);
            }
        }
    }

    protected void xtriple(int index, String singular) {
        if (this.digits[index] + this.digits[index + 1] + this.digits[index + 2] > 0) {
            this.triple(index);
            if (singular.indexOf(" ") > 0) {
                String[] array = singular.split(" ");
                this.syllables.addAll(Arrays.asList(array));
            } else {
                this.syllables.add(singular);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean wasDash = false;
        for (int i = 0; i < this.syllables.size(); ++i) {
            if (i > 0) {
                boolean isDash = ((String)this.syllables.get(i)).equals(DASH);
                if (!wasDash && !isDash) {
                    sb.append(" ");
                }
                wasDash = isDash;
            }
            sb.append(((String)this.syllables.get(i)).toString());
        }
        return sb.toString();
    }

    public static String toString(long number) throws Exception {
        return new UKEnglishNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new UKEnglishNumber(number).toString();
    }
}

