/*
 * Decompiled with CFR 0.152.
 */
package jscicalc.expression;

import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import jscicalc.Base;
import jscicalc.Error;
import jscicalc.Notation;
import jscicalc.OObject;
import jscicalc.StringArray;
import jscicalc.Substitution;
import jscicalc.complex.Complex;
import jscicalc.complex.DoubleFormat;
import jscicalc.expression.Expression;
import jscicalc.expression.Power;
import jscicalc.expression.SumOrProduct;

public class Product
extends SumOrProduct
implements Cloneable {
    protected LinkedList<Expression> divisorList;

    public Product(Expression expression, boolean bl) {
        if (expression instanceof Product) {
            Product product = (Product)expression;
            if (bl) {
                this.complex = new Complex(1.0);
                this.complex = this.complex.divide(product.complex);
                this.expressionList = product.divisorList;
                this.divisorList = product.expressionList;
            } else {
                this.complex = product.complex;
                this.expressionList = product.expressionList;
                this.divisorList = product.divisorList;
            }
        } else {
            this.complex = new Complex(1.0);
            if (bl) {
                this.expressionList = new LinkedList();
                this.divisorList = new LinkedList();
                this.divisorList.add(expression);
            } else {
                this.expressionList = new LinkedList();
                this.expressionList.add(expression);
                this.divisorList = new LinkedList();
            }
        }
    }

    void setComplex(Complex complex) {
        this.complex = complex;
    }

    public Product() {
        this.complex = new Complex();
        this.expressionList = new LinkedList();
        this.divisorList = new LinkedList();
    }

    public Product clone() {
        Product product = new Product();
        product.complex = new Complex(this.complex.real(), this.complex.imaginary());
        product.expressionList = new LinkedList();
        ListIterator listIterator = this.getExpressionList().listIterator();
        while (listIterator.hasNext()) {
            product.expressionList.add(listIterator.next());
        }
        product.divisorList = new LinkedList();
        listIterator = this.divisorList.listIterator();
        while (listIterator.hasNext()) {
            product.divisorList.add((Expression)listIterator.next());
        }
        return product;
    }

    public OObject multiply(Complex complex) {
        Product product = this.clone();
        product.complex = this.complex.multiply(complex);
        return product;
    }

    public OObject divide(Complex complex) {
        Product product = this.clone();
        product.complex = this.complex.divide(complex);
        return product;
    }

    public Product negate() {
        Product product = this.clone();
        product.complex = this.complex.negate();
        return product;
    }

    public OObject multiply(Product product) {
        System.out.println("Multiplying two products");
        Product product2 = this.clone();
        product2.complex = product2.complex.multiply(product.complex);
        ListIterator listIterator = product.expressionList.listIterator();
        while (listIterator.hasNext()) {
            product2.expressionList.add(listIterator.next());
        }
        listIterator = product.divisorList.listIterator();
        while (listIterator.hasNext()) {
            product2.divisorList.add((Expression)listIterator.next());
        }
        return product2;
    }

    public OObject divide(Product product) {
        System.out.println("Dividing one product by another");
        Product product2 = this.clone();
        product2.complex = product2.complex.divide(product.complex);
        ListIterator listIterator = product.divisorList.listIterator();
        while (listIterator.hasNext()) {
            product2.expressionList.add(listIterator.next());
        }
        listIterator = product.expressionList.listIterator();
        while (listIterator.hasNext()) {
            product2.divisorList.add((Expression)listIterator.next());
        }
        return product2;
    }

    public boolean isNegative() {
        if (this.complex.isZero()) {
            return false;
        }
        boolean bl = this.complex.isNegative();
        ListIterator listIterator = this.expressionList.listIterator();
        while (listIterator.hasNext()) {
            Expression expression = (Expression)listIterator.next();
            if (expression.isZero()) {
                return false;
            }
            boolean bl2 = expression.isNegative();
            bl = bl ? !bl2 : bl2;
        }
        return bl;
    }

    public OObject unBox() {
        if (this.divisorList.isEmpty() && this.expressionList.size() == 1 && this.complex.subtract(new Complex(1.0)).isZero()) {
            return (OObject)this.expressionList.getFirst();
        }
        if (this.divisorList.isEmpty() && this.expressionList.isEmpty()) {
            return this.complex;
        }
        return this;
    }

    public int compareTo(Product product) {
        this.sort();
        int n = Product.compare(this.expressionList, product.expressionList);
        if (n != 0) {
            return n;
        }
        return Product.compare(this.divisorList, product.divisorList);
    }

    public StringArray toHTMLSubString(int n, int n2, Base base, Notation notation, double d) {
        Expression expression;
        StringArray stringArray = new StringArray();
        StringArray stringArray2 = this.complex.toHTMLParenString(n, n2, base, notation, d);
        boolean bl = false;
        if (!this.expressionList.isEmpty()) {
            if (stringArray2.isMinusOne()) {
                stringArray.add(DoubleFormat.minus.firstElement());
            } else if (stringArray2.isOne()) {
                bl = true;
            } else {
                stringArray.addAll(stringArray2);
            }
        } else {
            stringArray.addAll(stringArray2);
        }
        if (bl && this.expressionList.size() == 1 && this.divisorList.isEmpty()) {
            Expression expression2 = (Expression)this.expressionList.getFirst();
            return expression2.toHTMLSubString(n, n2, base, notation, d);
        }
        ListIterator listIterator = this.expressionList.listIterator();
        while (listIterator.hasNext()) {
            expression = (Expression)listIterator.next();
            if (expression instanceof Power) {
                stringArray.addAll(expression.toHTMLSubString(n, n2, base, notation, d));
                continue;
            }
            if (expression == null) continue;
            stringArray.addAll(expression.toHTMLParenString(n, n2, base, notation, d));
        }
        if (!this.divisorList.isEmpty()) {
            stringArray.add("&#247;");
            if (this.divisorList.size() == 1) {
                stringArray.addAll(this.divisorList.getFirst().toHTMLParenString(n, n2, base, notation, d));
            } else {
                stringArray.add("(");
                listIterator = this.divisorList.listIterator();
                while (listIterator.hasNext()) {
                    expression = (Expression)listIterator.next();
                    stringArray.addAll(expression.toHTMLParenString(n, n2, base, notation, d));
                }
                stringArray.add(")");
            }
        }
        return stringArray;
    }

    public StringArray toHTMLParenString(int n, int n2, Base base, Notation notation, double d) {
        StringArray stringArray = this.complex.toHTMLParenString(n, n2, base, notation, d);
        if (this.getExpressionList().isEmpty() && this.divisorList.isEmpty()) {
            return stringArray;
        }
        if (this.getExpressionList().size() == 1 && this.divisorList.isEmpty() && stringArray.isOne()) {
            return this.getExpressionList().getFirst().toHTMLParenString(n, n2, base, notation, d);
        }
        if (this.getExpressionList().size() == 1 && this.divisorList.isEmpty() && stringArray.isMinusOne()) {
            StringArray stringArray2 = new StringArray();
            stringArray2.add(DoubleFormat.minus.firstElement());
            stringArray2.addAll(this.getExpressionList().getFirst().toHTMLParenString(n, n2, base, notation, d));
            return stringArray2;
        }
        StringArray stringArray3 = new StringArray();
        stringArray3.add("(");
        stringArray3.addAll(this.toHTMLSubString(n, n2, base, notation, d));
        stringArray3.add(")");
        return stringArray3;
    }

    public StringArray toHTMLParenStringL(int n, int n2, Base base, Notation notation, double d) {
        StringArray stringArray;
        StringArray stringArray2 = this.complex.toHTMLParenString(n, n2, base, notation, d);
        if (this.expressionList.isEmpty() && this.divisorList.isEmpty()) {
            return stringArray2;
        }
        if (this.expressionList.size() == 1 && this.divisorList.isEmpty()) {
            if (stringArray2.isOne()) {
                return ((Expression)this.expressionList.getFirst()).toHTMLParenString(n, n2, base, notation, d);
            }
            if (stringArray2.isMinusOne() && (stringArray = ((Expression)this.expressionList.getFirst()).toHTMLParenString(n, n2, base, notation, d)).size() > 0 && !((String)((Vector)stringArray.firstElement()).firstElement()).equals("(")) {
                StringArray stringArray3 = new StringArray();
                stringArray3.add(DoubleFormat.minus.firstElement());
                stringArray3.addAll(stringArray);
                return stringArray3;
            }
        }
        stringArray = new StringArray();
        stringArray.add("(");
        stringArray.addAll(this.toHTMLSubString(n, n2, base, notation, d));
        stringArray.add(")");
        return stringArray;
    }

    OObject integer_power(long l) {
        Expression expression;
        Complex complex = new Complex(l);
        Product product = new Product();
        product.complex = this.complex.pow(complex);
        ListIterator listIterator = this.expressionList.listIterator();
        while (listIterator.hasNext()) {
            expression = (Expression)listIterator.next();
            product.expressionList.add(new Power(expression, complex));
        }
        listIterator = this.divisorList.listIterator();
        while (listIterator.hasNext()) {
            expression = (Expression)listIterator.next();
            product.divisorList.add(new Power(expression, complex));
        }
        return product;
    }

    public void sort() {
        super.sort();
        for (Expression expression : this.divisorList) {
            expression.sort();
        }
        Collections.sort(this.divisorList);
    }

    public OObject auto_simplify() {
        OObject oObject;
        OObject oObject2;
        ListIterator<Expression> listIterator = this.divisorList.listIterator();
        while (listIterator.hasNext()) {
            oObject2 = (Expression)listIterator.next();
            oObject = new Power(oObject2, new Complex(-1.0)).auto_simplify();
            if (oObject instanceof Complex) {
                this.complex = this.complex.divide((Complex)oObject);
                continue;
            }
            if (oObject instanceof Expression) {
                this.expressionList.add((Expression)oObject);
                continue;
            }
            return new Error("Product.auto_simplify() error");
        }
        this.divisorList.clear();
        listIterator = this.expressionList.listIterator();
        while (listIterator.hasNext()) {
            oObject2 = ((Expression)listIterator.next()).auto_simplify();
            if (oObject2 instanceof Complex) {
                this.complex = this.complex.multiply((Complex)oObject2);
                listIterator.remove();
                continue;
            }
            if (oObject2 instanceof Expression) {
                listIterator.set((Expression)oObject2);
                continue;
            }
            return new Error("Product.auto_simplify() error");
        }
        this.sort();
        if (this.expressionList.isEmpty()) {
            return this.unBox();
        }
        listIterator = this.expressionList.listIterator();
        oObject2 = null;
        oObject = (Expression)listIterator.next();
        while (listIterator.hasNext()) {
            OObject oObject3 = oObject;
            OObject oObject4 = new Complex(1.0);
            if (oObject instanceof Power) {
                oObject3 = ((Power)oObject).base();
                oObject4 = ((Power)oObject).exponent();
            }
            OObject oObject5 = oObject2 = (Expression)listIterator.next();
            OObject oObject6 = new Complex(1.0);
            if (oObject2 instanceof Power) {
                oObject5 = ((Power)oObject2).base();
                oObject6 = ((Power)oObject2).exponent();
            }
            if (oObject3.compareTo(oObject5) == 0) {
                OObject oObject7;
                OObject oObject8 = oObject4.add(oObject6);
                if (oObject8 instanceof Expression) {
                    oObject8 = ((Expression)oObject8).auto_simplify();
                }
                if ((oObject7 = new Power(oObject3, oObject8).auto_simplify()) instanceof Complex) {
                    this.complex = this.complex.multiply((Complex)oObject7);
                    listIterator.remove();
                    listIterator.previous();
                    listIterator.remove();
                    if (listIterator.hasNext()) {
                        oObject = (Expression)listIterator.next();
                    }
                } else if (oObject7 instanceof Expression) {
                    listIterator.remove();
                    listIterator.previous();
                    listIterator.set((Expression)oObject7);
                    oObject2 = (Expression)listIterator.next();
                } else {
                    return new Error("Product.auto_simplify() error");
                }
            }
            oObject = oObject2;
        }
        return this.unBox();
    }

    public OObject substitute(Substitution substitution) {
        OObject oObject;
        Expression expression;
        Product product = this.clone();
        ListIterator<Expression> listIterator = product.expressionList.listIterator();
        while (listIterator.hasNext()) {
            expression = (Expression)listIterator.next();
            oObject = expression.substitute(substitution);
            if (oObject instanceof Complex) {
                listIterator.remove();
                product.complex = product.complex.multiply((Complex)oObject);
                continue;
            }
            if (oObject instanceof Expression) {
                listIterator.set((Expression)oObject);
                continue;
            }
            return new Error("Product.substitution() Error");
        }
        listIterator = product.divisorList.listIterator();
        while (listIterator.hasNext()) {
            expression = (Expression)listIterator.next();
            oObject = expression.substitute(substitution);
            if (oObject instanceof Complex) {
                listIterator.remove();
                product.complex = product.complex.divide((Complex)oObject);
                continue;
            }
            if (oObject instanceof Expression) {
                listIterator.set((Expression)oObject);
                continue;
            }
            return new Error("Product.substitution() Error");
        }
        return product.auto_simplify();
    }

    public static void main(String[] stringArray) {
    }
}

