/*
 * Decompiled with CFR 0.152.
 */
package jscicalc.graph;

import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import jscicalc.graph.Axis;
import jscicalc.graph.Model;
import jscicalc.graph.View;

public class VAxis
extends Axis {
    protected double x;

    public VAxis() {
        this.setX(0.0);
    }

    public void setX(double d) {
        this.x = d;
    }

    public void draw(Model model, View view, Graphics2D graphics2D) {
        double d;
        double d2 = view.getTransformation().toModelY(0.0);
        double d3 = view.getTransformation().toModelY(view.getHeight());
        double d4 = view.getTransformation().toViewX(this.x);
        Line2D.Double double_ = new Line2D.Double(d4, 0.0, d4, view.getHeight());
        graphics2D.draw(double_);
        if (this.getShowMajorUnit()) {
            d = view.getTransformation().getYMajorUnit();
            double d5 = view.getTransformation().getOriginY();
            for (int i = (int)Math.ceil(d3 / d) - 2; i < (int)Math.floor(d2 / d) + 1; ++i) {
                double d6 = view.getTransformation().toViewY((double)i * d);
                double_ = new Line2D.Double(d4, d6, d4 - (double)this.getMajorUnitTickLength(), d6);
                graphics2D.draw(double_);
                if ((double)i * d == d5) continue;
                String string = this.convertDouble((double)i * d);
                graphics2D.setFont(view.getFont());
                TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), graphics2D.getFontRenderContext());
                float f = textLayout.getAdvance();
                float f2 = textLayout.getAscent();
                graphics2D.drawString(string, (float)d4 - f - (float)this.getMajorUnitTickLength() - 2.0f, (float)d6 + 0.5f * f2);
            }
        }
        if (this.getShowMinorUnit()) {
            d = view.getTransformation().getYMinorUnit();
            for (int i = (int)Math.ceil(d3 / d) - 2; i < (int)Math.floor(d2 / d) + 1; ++i) {
                double d7 = view.getTransformation().toViewY((double)i * d);
                double_ = new Line2D.Double(d4, d7, d4 - (double)this.getMinorUnitTickLength(), d7);
                graphics2D.draw(double_);
            }
        }
    }
}

