/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui;

import gov.nasa.giss.gui.CommonShortcuts;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JTable;

public class JTableKeystrokeAdapter {
    private static String CUT_ACTION_NAME = "cut";
    private static String COPY_ACTION_NAME = "copy";
    private static String PASTE_ACTION_NAME = "paste";
    private static String SELECTALL_ACTION_NAME = "select all";
    private static Clipboard systemClip = Toolkit.getDefaultToolkit().getSystemClipboard();
    private static int commandMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private JTable table;
    private boolean cutAllowed = false;
    private boolean copyAllowed = true;
    private boolean pasteAllowed = false;
    private boolean selectAllAllowed = true;

    public JTableKeystrokeAdapter(JTable aTable) {
        this.table = aTable;
        if (CommonShortcuts.get(CUT_ACTION_NAME) != null) {
            this.table.getInputMap().put(CommonShortcuts.get(CUT_ACTION_NAME), CUT_ACTION_NAME);
            AbstractAction cutAction = new AbstractAction(CUT_ACTION_NAME){

                public void actionPerformed(ActionEvent e) {
                    if (!JTableKeystrokeAdapter.this.cutAllowed) {
                        return;
                    }
                }
            };
            this.table.getActionMap().put(cutAction.getValue("Name"), cutAction);
        }
        if (CommonShortcuts.get(COPY_ACTION_NAME) != null) {
            this.table.getInputMap().put(CommonShortcuts.get(COPY_ACTION_NAME), COPY_ACTION_NAME);
            AbstractAction copyAction = new AbstractAction(COPY_ACTION_NAME){

                public void actionPerformed(ActionEvent e) {
                    if (!JTableKeystrokeAdapter.this.copyAllowed) {
                        return;
                    }
                    StringBuffer sbf = new StringBuffer();
                    int numcols = JTableKeystrokeAdapter.this.table.getSelectedColumnCount();
                    int numrows = JTableKeystrokeAdapter.this.table.getSelectedRowCount();
                    int[] rSelected = JTableKeystrokeAdapter.this.table.getSelectedRows();
                    int[] cSelected = JTableKeystrokeAdapter.this.table.getSelectedColumns();
                    if (numrows - 1 != rSelected[rSelected.length - 1] - rSelected[0] || numrows != rSelected.length || numcols - 1 != cSelected[cSelected.length - 1] - cSelected[0] || numcols != cSelected.length) {
                        return;
                    }
                    int i = 0;
                    while (i < numrows) {
                        int j = 0;
                        while (j < numcols) {
                            sbf.append(JTableKeystrokeAdapter.this.table.getValueAt(rSelected[i], cSelected[j]));
                            if (j < numcols - 1) {
                                sbf.append("\t");
                            }
                            ++j;
                        }
                        sbf.append("\n");
                        ++i;
                    }
                    StringSelection strSelection = new StringSelection(sbf.toString());
                    systemClip = Toolkit.getDefaultToolkit().getSystemClipboard();
                    systemClip.setContents(strSelection, strSelection);
                }
            };
            this.table.getActionMap().put(copyAction.getValue("Name"), copyAction);
        }
        if (CommonShortcuts.get(PASTE_ACTION_NAME) != null) {
            this.table.getInputMap().put(CommonShortcuts.get(PASTE_ACTION_NAME), PASTE_ACTION_NAME);
            AbstractAction pasteAction = new AbstractAction(PASTE_ACTION_NAME){

                public void actionPerformed(ActionEvent e) {
                    if (!JTableKeystrokeAdapter.this.pasteAllowed) {
                        return;
                    }
                    int startRow = JTableKeystrokeAdapter.this.table.getSelectedRows()[0];
                    int startCol = JTableKeystrokeAdapter.this.table.getSelectedColumns()[0];
                    try {
                        String trstring = (String)systemClip.getContents(this).getTransferData(DataFlavor.stringFlavor);
                        StringTokenizer st1 = new StringTokenizer(trstring, "\n");
                        int i = 0;
                        while (st1.hasMoreTokens()) {
                            String rowstring = st1.nextToken();
                            StringTokenizer st2 = new StringTokenizer(rowstring, "\t");
                            int j = 0;
                            while (st2.hasMoreTokens()) {
                                String value = st2.nextToken();
                                if (startRow + i < JTableKeystrokeAdapter.this.table.getRowCount() && startCol + j < JTableKeystrokeAdapter.this.table.getColumnCount()) {
                                    JTableKeystrokeAdapter.this.table.setValueAt(value, startRow + i, startCol + j);
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            };
            this.table.getActionMap().put(pasteAction.getValue("Name"), pasteAction);
        }
        if (CommonShortcuts.get(SELECTALL_ACTION_NAME) != null) {
            this.table.getInputMap().put(CommonShortcuts.get(SELECTALL_ACTION_NAME), SELECTALL_ACTION_NAME);
            AbstractAction selectAllAction = new AbstractAction(SELECTALL_ACTION_NAME){

                public void actionPerformed(ActionEvent e) {
                    JTableKeystrokeAdapter.this.table.changeSelection(0, 0, false, false);
                    JTableKeystrokeAdapter.this.table.addColumnSelectionInterval(0, JTableKeystrokeAdapter.this.table.getColumnCount() - 1);
                    JTableKeystrokeAdapter.this.table.addRowSelectionInterval(0, JTableKeystrokeAdapter.this.table.getRowCount() - 1);
                }
            };
            this.table.getActionMap().put(selectAllAction.getValue("Name"), selectAllAction);
        }
    }

    public JTable getJTable() {
        return this.table;
    }

    public void setJTable(JTable table) {
        this.table = table;
    }
}

