/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping;

import java.awt.Checkbox;
import java.awt.Color;

public class Landmark {
    public static final int LANDER = 1;
    public static final int PLANNED = 2;
    public static final int CRASHSITE = 3;
    public static final int FEATURE = 4;
    public static final int UNKNOWN = 99;
    private double longitude;
    private double latitude;
    private boolean defaultSite;
    private int placetype;
    private String abbrev;
    private String name;
    private Color color;
    public Checkbox cbox;

    public Landmark(int placetype, double longitude, double latitude, boolean defaultSite, String abbrev, String name) {
        this(placetype, longitude, latitude, defaultSite, abbrev, name, Color.green);
    }

    public Landmark(int placetype, double longitude, double latitude, boolean defaultSite, String abbrev, String name, Color color) {
        this.placetype = placetype;
        this.longitude = longitude;
        this.latitude = latitude;
        this.defaultSite = defaultSite;
        this.abbrev = abbrev;
        this.name = name;
        this.color = color;
    }

    public int getType() {
        return this.placetype;
    }

    public String getName() {
        return this.name;
    }

    public String getAbbrev() {
        return this.abbrev;
    }

    public boolean isDefaultSite() {
        return this.defaultSite;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean getState() {
        return this.cbox.getState();
    }

    public void setState(boolean isChecked) {
        this.cbox.setState(isChecked);
    }

    public void flipState() {
        this.cbox.setState(!this.cbox.getState());
    }

    public int compareTo(Landmark theOther) {
        if (this.placetype > theOther.placetype) {
            return 1;
        }
        if (this.placetype < theOther.placetype) {
            return -1;
        }
        return this.name.compareTo(theOther.name);
    }
}

