/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class Hammer
extends AbstractProjection {
    private static final String PROJECTION_NAME = "Hammer";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double FIT_WIDTH = 2.0 * Math.sqrt(2.0);
    private static final double FIT_HEIGHT = Math.sqrt(2.0);
    public static final double ASPECT_RATIO = FIT_WIDTH / FIT_HEIGHT;
    private double scaleFactor = 1.0;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;

    public Hammer(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0);
    }

    public Hammer(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude);
    }

    public Hammer(int dw, int dh, int xm, int ym, double longitude) {
        this.init(dw, dh, xm, ym, longitude, 0.0);
        this.radius = Math.min(0.5 * (double)this.useHeight / FIT_HEIGHT, 0.5 * (double)this.useWidth / FIT_WIDTH);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / this.rS;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        int row = this.yMargin;
        while (row < this.dstHeight - this.yMargin) {
            double y = this.yCenter - row;
            double y2 = y * y;
            int col = this.xMargin;
            while (col < this.dstWidth - this.xMargin) {
                block5: {
                    double phiRad;
                    double dlambdaRad;
                    block6: {
                        block4: {
                            double cosC;
                            double x = col - this.xCenter;
                            if (x == 0.0 && y == 0.0) break block4;
                            double a = Math.sqrt(0.25 * x * x + y2);
                            double c = 2.0 * Math.asin(0.5 * a * this.oneOverRS);
                            double sinC = Math.sin(c);
                            dlambdaRad = 2.0 * Math.atan2(0.5 * x * sinC, a * (cosC = Math.cos(c)));
                            if (dlambdaRad > Math.PI || dlambdaRad <= -Math.PI) break block5;
                            phiRad = Math.asin(y * sinC / a);
                            break block6;
                        }
                        phiRad = 0.0;
                        dlambdaRad = 0.0;
                    }
                    int yMap = (int)(this.srcYPixPerDeg * (90.0 - AbstractProjection.toDegrees(phiRad)));
                    int xMap = (int)(this.srcXPixPerDeg * (180.0 + AbstractProjection.toDegrees(dlambdaRad) - this.copLon));
                    while (xMap >= this.srcWidth) {
                        xMap -= this.srcWidth;
                    }
                    while (xMap < 0) {
                        xMap += this.srcWidth;
                    }
                    this.invArray[row * this.dstWidth + col] = yMap * this.srcWidth + xMap;
                }
                ++col;
            }
            ++row;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double lon, double lat) {
        double dlambda = lon - this.copLon;
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        double dlambdaRadOver2 = -0.5 * AbstractProjection.toRadians(dlambda);
        double cosLat = Math.cos(AbstractProjection.toRadians(lat));
        double sinLat = Math.sin(AbstractProjection.toRadians(lat));
        double k = Math.sqrt(2.0 / (1.0 + cosLat * Math.cos(dlambdaRadOver2)));
        double x = 2.0 * this.rS * k * cosLat * Math.sin(dlambdaRadOver2);
        double y = this.rS * k * sinLat;
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

