/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.PointDouble;
import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;

public class Projection {
    private static final Class[] PROJ_CLASSES = new Class[]{null, class$gov$nasa$giss$mapping$proj$Equirectangular == null ? (class$gov$nasa$giss$mapping$proj$Equirectangular = Projection.class$("gov.nasa.giss.mapping.proj.Equirectangular")) : class$gov$nasa$giss$mapping$proj$Equirectangular, class$gov$nasa$giss$mapping$proj$Orthographic == null ? (class$gov$nasa$giss$mapping$proj$Orthographic = Projection.class$("gov.nasa.giss.mapping.proj.Orthographic")) : class$gov$nasa$giss$mapping$proj$Orthographic, class$gov$nasa$giss$mapping$proj$Mollweide == null ? (class$gov$nasa$giss$mapping$proj$Mollweide = Projection.class$("gov.nasa.giss.mapping.proj.Mollweide")) : class$gov$nasa$giss$mapping$proj$Mollweide, class$gov$nasa$giss$mapping$proj$Stereographic == null ? (class$gov$nasa$giss$mapping$proj$Stereographic = Projection.class$("gov.nasa.giss.mapping.proj.Stereographic")) : class$gov$nasa$giss$mapping$proj$Stereographic, class$gov$nasa$giss$mapping$proj$Aitoff == null ? (class$gov$nasa$giss$mapping$proj$Aitoff = Projection.class$("gov.nasa.giss.mapping.proj.Aitoff")) : class$gov$nasa$giss$mapping$proj$Aitoff, class$gov$nasa$giss$mapping$proj$AzimEquidistant == null ? (class$gov$nasa$giss$mapping$proj$AzimEquidistant = Projection.class$("gov.nasa.giss.mapping.proj.AzimEquidistant")) : class$gov$nasa$giss$mapping$proj$AzimEquidistant, class$gov$nasa$giss$mapping$proj$AzimEqualarea == null ? (class$gov$nasa$giss$mapping$proj$AzimEqualarea = Projection.class$("gov.nasa.giss.mapping.proj.AzimEqualarea")) : class$gov$nasa$giss$mapping$proj$AzimEqualarea, class$gov$nasa$giss$mapping$proj$Hammer == null ? (class$gov$nasa$giss$mapping$proj$Hammer = Projection.class$("gov.nasa.giss.mapping.proj.Hammer")) : class$gov$nasa$giss$mapping$proj$Hammer, class$gov$nasa$giss$mapping$proj$Sinusoidal == null ? (class$gov$nasa$giss$mapping$proj$Sinusoidal = Projection.class$("gov.nasa.giss.mapping.proj.Sinusoidal")) : class$gov$nasa$giss$mapping$proj$Sinusoidal, class$gov$nasa$giss$mapping$proj$Parabolic == null ? (class$gov$nasa$giss$mapping$proj$Parabolic = Projection.class$("gov.nasa.giss.mapping.proj.Parabolic")) : class$gov$nasa$giss$mapping$proj$Parabolic, class$gov$nasa$giss$mapping$proj$Eckert4 == null ? (class$gov$nasa$giss$mapping$proj$Eckert4 = Projection.class$("gov.nasa.giss.mapping.proj.Eckert4")) : class$gov$nasa$giss$mapping$proj$Eckert4, class$gov$nasa$giss$mapping$proj$Eckert6 == null ? (class$gov$nasa$giss$mapping$proj$Eckert6 = Projection.class$("gov.nasa.giss.mapping.proj.Eckert6")) : class$gov$nasa$giss$mapping$proj$Eckert6, class$gov$nasa$giss$mapping$proj$Eckert5 == null ? (class$gov$nasa$giss$mapping$proj$Eckert5 = Projection.class$("gov.nasa.giss.mapping.proj.Eckert5")) : class$gov$nasa$giss$mapping$proj$Eckert5, class$gov$nasa$giss$mapping$proj$EckertGreifendorff == null ? (class$gov$nasa$giss$mapping$proj$EckertGreifendorff = Projection.class$("gov.nasa.giss.mapping.proj.EckertGreifendorff")) : class$gov$nasa$giss$mapping$proj$EckertGreifendorff, class$gov$nasa$giss$mapping$proj$QuarticAuthalic == null ? (class$gov$nasa$giss$mapping$proj$QuarticAuthalic = Projection.class$("gov.nasa.giss.mapping.proj.QuarticAuthalic")) : class$gov$nasa$giss$mapping$proj$QuarticAuthalic, class$gov$nasa$giss$mapping$proj$FlatPolarQuartic == null ? (class$gov$nasa$giss$mapping$proj$FlatPolarQuartic = Projection.class$("gov.nasa.giss.mapping.proj.FlatPolarQuartic")) : class$gov$nasa$giss$mapping$proj$FlatPolarQuartic, class$gov$nasa$giss$mapping$proj$FlatPolarSinusoidal == null ? (class$gov$nasa$giss$mapping$proj$FlatPolarSinusoidal = Projection.class$("gov.nasa.giss.mapping.proj.FlatPolarSinusoidal")) : class$gov$nasa$giss$mapping$proj$FlatPolarSinusoidal, class$gov$nasa$giss$mapping$proj$FlatPolarParabolic == null ? (class$gov$nasa$giss$mapping$proj$FlatPolarParabolic = Projection.class$("gov.nasa.giss.mapping.proj.FlatPolarParabolic")) : class$gov$nasa$giss$mapping$proj$FlatPolarParabolic, class$gov$nasa$giss$mapping$proj$Eckert3 == null ? (class$gov$nasa$giss$mapping$proj$Eckert3 = Projection.class$("gov.nasa.giss.mapping.proj.Eckert3")) : class$gov$nasa$giss$mapping$proj$Eckert3, class$gov$nasa$giss$mapping$proj$Wagner4 == null ? (class$gov$nasa$giss$mapping$proj$Wagner4 = Projection.class$("gov.nasa.giss.mapping.proj.Wagner4")) : class$gov$nasa$giss$mapping$proj$Wagner4, class$gov$nasa$giss$mapping$proj$Kavraisky7 == null ? (class$gov$nasa$giss$mapping$proj$Kavraisky7 = Projection.class$("gov.nasa.giss.mapping.proj.Kavraisky7")) : class$gov$nasa$giss$mapping$proj$Kavraisky7, class$gov$nasa$giss$mapping$proj$PutninsP3 == null ? (class$gov$nasa$giss$mapping$proj$PutninsP3 = Projection.class$("gov.nasa.giss.mapping.proj.PutninsP3")) : class$gov$nasa$giss$mapping$proj$PutninsP3, class$gov$nasa$giss$mapping$proj$PutninsP3p == null ? (class$gov$nasa$giss$mapping$proj$PutninsP3p = Projection.class$("gov.nasa.giss.mapping.proj.PutninsP3p")) : class$gov$nasa$giss$mapping$proj$PutninsP3p, class$gov$nasa$giss$mapping$proj$PutninsP5 == null ? (class$gov$nasa$giss$mapping$proj$PutninsP5 = Projection.class$("gov.nasa.giss.mapping.proj.PutninsP5")) : class$gov$nasa$giss$mapping$proj$PutninsP5, class$gov$nasa$giss$mapping$proj$PutninsP5p == null ? (class$gov$nasa$giss$mapping$proj$PutninsP5p = Projection.class$("gov.nasa.giss.mapping.proj.PutninsP5p")) : class$gov$nasa$giss$mapping$proj$PutninsP5p, class$gov$nasa$giss$mapping$proj$NellHammer == null ? (class$gov$nasa$giss$mapping$proj$NellHammer = Projection.class$("gov.nasa.giss.mapping.proj.NellHammer")) : class$gov$nasa$giss$mapping$proj$NellHammer, class$gov$nasa$giss$mapping$proj$Wagner1 == null ? (class$gov$nasa$giss$mapping$proj$Wagner1 = Projection.class$("gov.nasa.giss.mapping.proj.Wagner1")) : class$gov$nasa$giss$mapping$proj$Wagner1, class$gov$nasa$giss$mapping$proj$PutninsP4p == null ? (class$gov$nasa$giss$mapping$proj$PutninsP4p = Projection.class$("gov.nasa.giss.mapping.proj.PutninsP4p")) : class$gov$nasa$giss$mapping$proj$PutninsP4p, class$gov$nasa$giss$mapping$proj$Winkel1 == null ? (class$gov$nasa$giss$mapping$proj$Winkel1 = Projection.class$("gov.nasa.giss.mapping.proj.Winkel1")) : class$gov$nasa$giss$mapping$proj$Winkel1, class$gov$nasa$giss$mapping$proj$Wagner2 == null ? (class$gov$nasa$giss$mapping$proj$Wagner2 = Projection.class$("gov.nasa.giss.mapping.proj.Wagner2")) : class$gov$nasa$giss$mapping$proj$Wagner2, class$gov$nasa$giss$mapping$proj$Wagner5 == null ? (class$gov$nasa$giss$mapping$proj$Wagner5 = Projection.class$("gov.nasa.giss.mapping.proj.Wagner5")) : class$gov$nasa$giss$mapping$proj$Wagner5, class$gov$nasa$giss$mapping$proj$WinkelTripel == null ? (class$gov$nasa$giss$mapping$proj$WinkelTripel = Projection.class$("gov.nasa.giss.mapping.proj.WinkelTripel")) : class$gov$nasa$giss$mapping$proj$WinkelTripel};
    private static final int NOT_SELECTED = 0;
    private static final double DEFAULT_COP_LON = 0.0;
    private static final double DEFAULT_COP_LAT = 45.0;
    private static String[] projNames;
    private static Vector sortedNames;
    private int projectionID = 0;
    private AbstractProjection theProjection;
    private int dstWidth;
    private int dstHeight;
    private int xMargin;
    private int yMargin;
    private double copLon;
    private double copLat;
    private Color bgcolor;
    private Color gridColor;
    private boolean gridLabeled;
    private Color outlineColor;
    private PointDouble[] outlineDots;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$Equirectangular;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$Orthographic;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$Mollweide;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$Stereographic;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$Aitoff;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$AzimEquidistant;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$AzimEqualarea;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$Hammer;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$Sinusoidal;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$Parabolic;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$Eckert4;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$Eckert6;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$Eckert5;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$EckertGreifendorff;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$QuarticAuthalic;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$FlatPolarQuartic;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$FlatPolarSinusoidal;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$FlatPolarParabolic;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$Eckert3;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$Wagner4;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$Kavraisky7;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$PutninsP3;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$PutninsP3p;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$PutninsP5;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$PutninsP5p;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$NellHammer;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$Wagner1;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$PutninsP4p;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$Winkel1;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$Wagner2;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$Wagner5;
    static /* synthetic */ Class class$gov$nasa$giss$mapping$proj$WinkelTripel;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;

    public Projection(int id, int w, int h) {
        this(id, w, h, 0, 0, 0.0, 45.0);
    }

    public Projection(int id, int w, int h, double lon, double lat) {
        this(id, w, h, 0, 0, lon, lat);
    }

    public Projection(int id, int w, int h, int xMargin, int yMargin, double lon, double lat) {
        this.projectionID = id;
        this.dstWidth = w;
        this.dstHeight = h;
        this.xMargin = xMargin;
        this.yMargin = yMargin;
        this.copLon = lon;
        this.copLat = lat;
        this.setProjection(this.projectionID);
    }

    public void setProjection(int id) {
        if (id < 0 || id > PROJ_CLASSES.length - 1 || PROJ_CLASSES[id] == null) {
            throw new IllegalArgumentException("Projection ID '" + id + "' not recognized.");
        }
        this.projectionID = id;
        try {
            Class aClass = PROJ_CLASSES[this.projectionID];
            if (Projection.isAzimuthal(this.projectionID)) {
                Class[] argTypes = new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = Projection.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = Projection.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = Projection.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = Projection.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Double == null ? (class$java$lang$Double = Projection.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Double == null ? (class$java$lang$Double = Projection.class$("java.lang.Double")) : class$java$lang$Double};
                Object[] args = new Object[]{new Integer(this.dstWidth), new Integer(this.dstHeight), new Integer(this.xMargin), new Integer(this.yMargin), new Double(this.copLon), new Double(this.copLat)};
                Constructor c = aClass.getConstructor(argTypes);
                this.theProjection = (AbstractProjection)c.newInstance(args);
            } else {
                Class[] argTypes = new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = Projection.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = Projection.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = Projection.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = Projection.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Double == null ? (class$java$lang$Double = Projection.class$("java.lang.Double")) : class$java$lang$Double};
                Object[] args = new Object[]{new Integer(this.dstWidth), new Integer(this.dstHeight), new Integer(this.xMargin), new Integer(this.yMargin), new Double(this.copLon)};
                Constructor c = aClass.getConstructor(argTypes);
                this.theProjection = (AbstractProjection)c.newInstance(args);
            }
            this.theProjection.setGridColor(this.gridColor);
            this.theProjection.setGridLabeled(this.gridLabeled);
            this.theProjection.setOutlineColor(this.outlineColor);
            this.theProjection.setOutlinePoints(this.outlineDots);
        }
        catch (Exception exc) {
            System.out.println("Projection construction error!");
            System.out.println("Projection is now set to null!");
            System.out.println(exc.toString());
        }
    }

    public String getName() {
        if (this.theProjection == null) {
            return null;
        }
        return Projection.getName(this.projectionID);
    }

    public static String getName(int id) {
        if (id < 0 || id > PROJ_CLASSES.length - 1 || PROJ_CLASSES[id] == null) {
            throw new IllegalArgumentException("Projection ID '" + id + "' not recognized.");
        }
        try {
            Class[] argTypes = new Class[]{};
            Object[] args = new Object[]{};
            Method theMethod = PROJ_CLASSES[id].getMethod("getProjectionName", argTypes);
            return (String)theMethod.invoke(null, args);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public double getAspectRatio() {
        if (this.theProjection == null) {
            return 0.0;
        }
        return Projection.getAspectRatio(this.projectionID);
    }

    public static double getAspectRatio(String aName) {
        return Projection.getAspectRatio(Projection.getProjectionID(aName));
    }

    public static double getAspectRatio(int id) {
        if (id < 0 || id > PROJ_CLASSES.length - 1 || PROJ_CLASSES[id] == null) {
            throw new IllegalArgumentException("Projection ID '" + id + "' not recognized.");
        }
        try {
            Class[] argTypes = new Class[]{};
            Object[] args = new Object[]{};
            Method theMethod = PROJ_CLASSES[id].getMethod("getAspectRatio", argTypes);
            return (Double)theMethod.invoke(null, args);
        }
        catch (Exception exc) {
            return 0.0;
        }
    }

    public boolean isAzimuthal() {
        if (this.theProjection == null) {
            return false;
        }
        return Projection.isAzimuthal(this.projectionID);
    }

    public static boolean isAzimuthal(String aName) {
        return Projection.isAzimuthal(Projection.getProjectionID(aName));
    }

    public static boolean isAzimuthal(int id) {
        if (id < 0 || id > PROJ_CLASSES.length - 1 || PROJ_CLASSES[id] == null) {
            throw new IllegalArgumentException("Projection ID '" + id + "' not recognized.");
        }
        try {
            Class[] argTypes = new Class[]{};
            Object[] args = new Object[]{};
            Method theMethod = PROJ_CLASSES[id].getMethod("isAzimuthal", argTypes);
            return (Boolean)theMethod.invoke(null, args);
        }
        catch (Exception exc) {
            return false;
        }
    }

    public Image getSourceMap() {
        if (this.theProjection != null) {
            return this.theProjection.getSourceMap();
        }
        return null;
    }

    public void setSourceMap(Image img) {
        if (this.theProjection == null) {
            throw new IllegalArgumentException("Can't assign a source map until a projection is selected.");
        }
        this.theProjection.setSourceMap(img);
    }

    public void setBackgroundColor(Color color) {
        this.theProjection.setBackgroundColor(color);
    }

    public void setDrawBorder(boolean choice) {
        this.theProjection.setDrawBorder(choice);
    }

    public void setCenter(double lon) {
        this.setCenter(lon, 0.0);
    }

    public void setCenter(double lon, double lat) {
        try {
            this.theProjection.setCenter(lon, lat);
            this.copLon = lon;
            this.copLat = lat;
        }
        catch (Exception exc) {}
    }

    public static Vector getProjectionList() {
        return sortedNames;
    }

    public static int getProjectionID(String aName) {
        if (aName == null) {
            return 0;
        }
        int i = 0;
        while (i < PROJ_CLASSES.length) {
            if (PROJ_CLASSES[i] != null && aName.equals(projNames[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void drawMap(Image src, Graphics g, int spacing) {
        this.drawMap(src, g);
        this.drawLLGrid(g, spacing);
    }

    public void drawMap(Image src, Graphics g) {
        this.theProjection.drawMap(src, g);
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
        this.theProjection.setGridColor(color);
    }

    public void setGridLabeled(boolean choice) {
        this.gridLabeled = choice;
        this.theProjection.setGridLabeled(choice);
    }

    public void drawLLGrid(Graphics g, int spacing) {
        if (spacing < 5) {
            return;
        }
        this.theProjection.drawLLGrid(g, spacing);
    }

    public void setOutlinePoints(PointDouble[] dots) {
        this.outlineDots = dots;
        this.theProjection.setOutlinePoints(this.outlineDots);
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
        this.theProjection.setOutlineColor(this.outlineColor);
    }

    public void drawOutline(Graphics g) {
        this.theProjection.drawOutline(g);
    }

    public PointDouble transformXY2LL(int x, int y) {
        return this.theProjection.transformXY2LL(x, y);
    }

    public Point transformLL2XY(double lon, double lat) {
        return this.theProjection.transformLL2XY(lon, lat);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Class[] argTypes = new Class[]{};
        Object[] args = new Object[]{};
        projNames = new String[PROJ_CLASSES.length];
        sortedNames = new Vector(PROJ_CLASSES.length);
        int i = 1;
        while (i < PROJ_CLASSES.length) {
            try {
                Method theMethod = PROJ_CLASSES[i].getMethod("getProjectionName", argTypes);
                Projection.projNames[i] = (String)theMethod.invoke(null, args);
                if (i == 1) {
                    sortedNames.addElement(projNames[i]);
                } else {
                    boolean inserted = false;
                    int j = 1;
                    while (j < i) {
                        if (projNames[i].compareTo((String)sortedNames.elementAt(j - 1)) < 0) {
                            inserted = true;
                            sortedNames.insertElementAt(projNames[i], j - 1);
                            break;
                        }
                        ++j;
                    }
                    if (!inserted) {
                        sortedNames.addElement(projNames[i]);
                    }
                }
            }
            catch (Exception exc) {
                Projection.projNames[i] = "[No Name Available]";
            }
            ++i;
        }
    }
}

