/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class Stereographic
extends AbstractProjection {
    private static final String PROJECTION_NAME = "Stereographic";
    private static final boolean IS_AZIMUTHAL = true;
    private static final double FIT_FACTOR = 2.0;
    private double scaleFactor = 1.0;
    public static final double ASPECT_RATIO = 1.0;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;
    private double r2s2;
    private double rhoMax;
    private double rhoMax2;

    public Stereographic(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0, 45.0);
    }

    public Stereographic(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude, Double latitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude, (double)latitude);
    }

    public Stereographic(int dw, int dh, int xm, int ym, double longitude, double latitude) {
        this.init(dw, dh, xm, ym, longitude, latitude);
        this.radius = Math.min(0.5 * (double)this.useHeight / 2.0, 0.5 * (double)this.useWidth / 2.0);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / (this.radius * this.scaleFactor);
        this.r2s2 = this.rS * this.rS;
        this.rhoMax = 0.5 * (double)Math.min(this.useHeight, this.useWidth);
        this.rhoMax2 = this.rhoMax * this.rhoMax;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return true;
    }

    public static double getAspectRatio() {
        return 1.0;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        int row = this.yMargin;
        while (row < this.dstHeight - this.yMargin) {
            double y = this.yCenter - row;
            double y2 = y * y;
            int col = this.xMargin;
            while (col < this.dstWidth - this.xMargin) {
                double x = col - this.xCenter;
                double rho2 = x * x + y2;
                if (!(rho2 > this.rhoMax2)) {
                    double dlambdaRad;
                    double phiRad;
                    double rho = Math.sqrt(rho2);
                    if (rho > 0.0) {
                        double c = 2.0 * Math.atan(0.5 * rho * this.oneOverRS);
                        double sinC = Math.sin(c);
                        double cosC = Math.cos(c);
                        phiRad = Math.asin(cosC * this.sinCOPLat + y * sinC * this.cosCOPLat / rho);
                        dlambdaRad = Math.atan2(x * sinC, rho * this.cosCOPLat * cosC - y * this.sinCOPLat * sinC);
                    } else {
                        phiRad = AbstractProjection.toRadians(this.copLat);
                        dlambdaRad = 0.0;
                    }
                    int yMap = (int)(this.srcYPixPerDeg * (90.0 - AbstractProjection.toDegrees(phiRad)));
                    int xMap = (int)(this.srcXPixPerDeg * (180.0 + AbstractProjection.toDegrees(dlambdaRad) - this.copLon));
                    while (xMap >= this.srcWidth) {
                        xMap -= this.srcWidth;
                    }
                    while (xMap < 0) {
                        xMap += this.srcWidth;
                    }
                    this.invArray[row * this.dstWidth + col] = yMap * this.srcWidth + xMap;
                }
                ++col;
            }
            ++row;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double longitude, double latitude) {
        double dlambdaRad = AbstractProjection.toRadians(this.copLon - longitude);
        double cosDLambda = Math.cos(dlambdaRad);
        double cosLat = Math.cos(AbstractProjection.toRadians(latitude));
        double sinLat = Math.sin(AbstractProjection.toRadians(latitude));
        double k = 2.0 * this.scaleFactor / (1.0 + this.sinCOPLat * sinLat + this.cosCOPLat * cosLat * cosDLambda);
        if (k > 2.0 * this.scaleFactor) {
            return null;
        }
        double x = this.rS * k * cosLat * Math.sin(dlambdaRad);
        double y = this.rS * k * (this.cosCOPLat * sinLat - this.sinCOPLat * cosLat * cosDLambda);
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

