/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class Unwinkel
extends AbstractProjection {
    private static final String PROJECTION_NAME = "Unwinkel";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double COS_PHI0 = 0.6366197723675814;
    private static final double FIT_WIDTH = 2.5707963267948966;
    private static final double FIT_HEIGHT = 1.5707963267948966;
    private double scaleFactor = 1.0;
    public static final double ASPECT_RATIO = 1.6366197723675813;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;

    public Unwinkel(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0);
    }

    public Unwinkel(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude);
    }

    public Unwinkel(int dw, int dh, int xm, int ym, double longitude) {
        this.init(1280, 782, 0, 0, 0.0, 0.0);
        this.radius = Math.min(0.5 * (double)this.useHeight / 1.5707963267948966, 0.5 * (double)this.useWidth / 2.5707963267948966);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / this.rS;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 1.6366197723675813;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        int y = 0;
        while (y < 700) {
            double longitude = 90.0 * (double)(this.yCenter - y) / (double)this.yCenter;
            int x = 0;
            while (x < 1200) {
                double latitude = 180.0 * (double)(this.xCenter - x) / (double)this.xCenter;
                Point p = this.transformLL2XY(longitude, latitude);
                int yMap = p.x;
                int xMap = p.y;
                while (xMap >= this.srcWidth) {
                    xMap -= this.srcWidth;
                }
                while (xMap < 0) {
                    xMap += this.srcWidth;
                }
                this.invArray[y * this.dstWidth + x] = yMap * this.srcWidth + xMap;
                ++x;
            }
            ++y;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double longitude, double latitude) {
        double dlambda = longitude - this.copLong;
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        double dlambdaRad = -AbstractProjection.toRadians(dlambda);
        double phiRad = AbstractProjection.toRadians(latitude);
        double dlambdaRadOver2 = 0.5 * dlambdaRad;
        double cosPhi = Math.cos(phiRad);
        double cosD = cosPhi * Math.cos(dlambdaRadOver2);
        double d = Math.acos(cosD);
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(d) < 1.0E-5) {
            x = 0.0;
            y = 0.0;
        } else {
            double dOverSqrtC = d / Math.sin(d);
            x = 0.5 * this.rS * (dlambdaRad * 0.6366197723675814 + 2.0 * dOverSqrtC * cosPhi * Math.sin(dlambdaRadOver2));
            y = 0.5 * this.rS * (phiRad + dOverSqrtC * Math.sin(phiRad));
        }
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

