/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class WinkelTripel
extends AbstractProjection {
    private static final String PROJECTION_NAME = "Winkel Tripel";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double COS_PHI0 = 0.6366197723675814;
    private static final double FIT_WIDTH = 2.5707963267948966;
    private static final double FIT_HEIGHT = 1.5707963267948966;
    private double scaleFactor = 1.0;
    public static final double ASPECT_RATIO = 1.6366197723675813;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;

    public WinkelTripel(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0);
    }

    public WinkelTripel(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude);
    }

    public WinkelTripel(int dw, int dh, int xm, int ym, double longitude) {
        this.init(dw, dh, xm, ym, longitude, 0.0);
        this.radius = Math.min(0.5 * (double)this.useHeight / 1.5707963267948966, 0.5 * (double)this.useWidth / 2.5707963267948966);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / this.rS;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 1.6366197723675813;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        int y = 0;
        while ((double)y < 0.5 * (double)this.useHeight) {
            int row = this.yCenter - y;
            int rowF = this.yCenter + y;
            double phiRad = this.oneOverRS * (double)y;
            double dlambdaRad = 0.0;
            int x = 0;
            while (x < this.xCenter) {
                int col = this.xCenter + x;
                int colF = this.xCenter - x;
                if (y > 0) {
                    phiRad += 1.0E-5;
                    dlambdaRad += 1.0E-5;
                    int iter = 0;
                    while (iter < 25) {
                        double dlambdaRadOver2 = 0.5 * dlambdaRad;
                        double cosPhi = Math.cos(phiRad);
                        double sinPhi = Math.sin(phiRad);
                        double sin2Phi = Math.sin(2.0 * phiRad);
                        double cosSquPhi = cosPhi * cosPhi;
                        double sinSquPhi = sinPhi * sinPhi;
                        double cosLambda = Math.cos(dlambdaRad);
                        double sinLambda = Math.sin(dlambdaRad);
                        double cosHalfLambda = Math.cos(dlambdaRadOver2);
                        double sinHalfLambda = Math.sin(dlambdaRadOver2);
                        double cosD = cosPhi * Math.cos(dlambdaRadOver2);
                        double d = Math.acos(cosD);
                        double c = 1.0 - cosD * cosD;
                        double oneOverC = 1.0 / c;
                        double sqrtC = Math.sqrt(c);
                        double oneOverSqrtC = 1.0 / sqrtC;
                        double dOverCSqrtC = d / (c * sqrtC);
                        double df1dPhi = 0.25 * sinLambda * sin2Phi * oneOverC - dOverCSqrtC * sinPhi * sinHalfLambda;
                        double df1dLambda = 0.5 * (cosSquPhi * sinHalfLambda * sinHalfLambda * oneOverC + dOverCSqrtC * cosPhi * cosHalfLambda * sinSquPhi + 0.6366197723675814);
                        double df2dPhi = 0.5 * (sinSquPhi * cosHalfLambda * oneOverC + dOverCSqrtC * (1.0 - cosHalfLambda * cosHalfLambda) * cosPhi + 1.0);
                        double df2dLambda = 0.125 * (sin2Phi * sinHalfLambda * oneOverC - dOverCSqrtC * sinPhi * cosSquPhi * sinLambda);
                        double f1 = 0.5 * (2.0 * d * cosPhi * sinHalfLambda * oneOverSqrtC + dlambdaRad * 0.6366197723675814) - (double)x * this.oneOverRS;
                        double f2 = 0.5 * (d * sinPhi * oneOverSqrtC + phiRad) - (double)y * this.oneOverRS;
                        double denom = df1dPhi * df2dLambda - df2dPhi * df1dLambda;
                        double dphiX = (f1 * df2dLambda - f2 * df1dLambda) / denom;
                        double dlambdaX = (f2 * df1dPhi - f1 * df2dPhi) / denom;
                        phiRad -= dphiX;
                        dlambdaRad -= dlambdaX;
                        if (!(Math.abs(dphiX) < 1.0E-5) || !(Math.abs(dlambdaX) < 1.0E-5)) {
                            ++iter;
                            continue;
                        }
                        break;
                    }
                } else {
                    phiRad = 0.0;
                    dlambdaRad = 2.0 * (this.oneOverRS * (double)x) / 1.6366197723675815;
                }
                if (Math.abs(dlambdaRad) > Math.PI) break;
                double phi = AbstractProjection.toDegrees(phiRad);
                double dlambda = -AbstractProjection.toDegrees(dlambdaRad);
                int yMap = (int)(this.srcYPixPerDeg * (90.0 - phi));
                int yMapF = (int)(this.srcYPixPerDeg * (90.0 + phi));
                int xMap = (int)(this.srcXPixPerDeg * (180.0 - this.copLon - dlambda));
                int xMapF = (int)(this.srcXPixPerDeg * (180.0 - this.copLon + dlambda));
                while (xMap >= this.srcWidth) {
                    xMap -= this.srcWidth;
                }
                while (xMapF >= this.srcWidth) {
                    xMapF -= this.srcWidth;
                }
                while (xMap < 0) {
                    xMap += this.srcWidth;
                }
                while (xMapF < 0) {
                    xMapF += this.srcWidth;
                }
                this.invArray[row * this.dstWidth + col] = yMap * this.srcWidth + xMap;
                this.invArray[row * this.dstWidth + colF] = yMap * this.srcWidth + xMapF;
                this.invArray[rowF * this.dstWidth + col] = yMapF * this.srcWidth + xMap;
                this.invArray[rowF * this.dstWidth + colF] = yMapF * this.srcWidth + xMapF;
                ++x;
            }
            ++y;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double lon, double lat) {
        double dlambda = lon - this.copLon;
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        double dlambdaRad = -AbstractProjection.toRadians(dlambda);
        double phiRad = AbstractProjection.toRadians(lat);
        double dlambdaRadOver2 = 0.5 * dlambdaRad;
        double cosPhi = Math.cos(phiRad);
        double cosD = cosPhi * Math.cos(dlambdaRadOver2);
        double d = Math.acos(cosD);
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(d) < 1.0E-5) {
            x = 0.0;
            y = 0.0;
        } else {
            double dOverSqrtC = d / Math.sin(d);
            x = 0.5 * this.rS * (dlambdaRad * 0.6366197723675814 + 2.0 * dOverSqrtC * cosPhi * Math.sin(dlambdaRadOver2));
            y = 0.5 * this.rS * (phiRad + dOverSqrtC * Math.sin(phiRad));
        }
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

