/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24.applet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class M24DayNightMap
extends Component {
    public static double RAD_PER_DEG = Math.PI / 180;
    public static double DEG_PER_RAD = 57.29577951308232;
    private static final double UNKNOWN = 9999.0;
    private static final double DEFAULT_SUBSOLAR_LON = 0.0;
    private static final double DEFAULT_SUBSOLAR_LAT = 0.0;
    private static final Color DEFAULT_DAYCOLOR = new Color(0xDD6611);
    private static final Color DEFAULT_BGCOLOR = new Color(0, 0, 0);
    private Image baseImage;
    private int baseWidth = 0;
    private int baseHeight = 0;
    private Image darkImage;
    private Image shadedImage;
    private Graphics shadedImageGfx;
    private Color bgcolor;
    private boolean needsRedraw = true;
    private int darkness = 50;
    private double pixPerDeg;
    private double degPerPix;
    private int pix180;
    private int pix360;
    private int pix540;
    private double[] mapLong;
    private double[] mapLat;
    private double[] cosMapColat;
    private double[] sinMapColat;
    private double[][] zenithAngle;
    private double[] cosDTheta;
    private double subsolarLong;
    private double subsolarLat;
    private double cosSubsolarColat;
    private double sinSubsolarColat;
    private static final Frame LISTENER = new Frame();

    public M24DayNightMap(Image img, int w, int d) {
        this.baseWidth = w;
        this.baseHeight = (int)(0.5 * (double)this.baseWidth);
        this.darkness = d;
        LISTENER.addNotify();
        if (img != (Image)null) {
            this.baseImage = LISTENER.createImage(this.baseWidth, this.baseHeight);
            this.setBaseImage(img);
        } else {
            this.makeDefaultImage();
        }
        this.pixPerDeg = (double)this.baseWidth / 360.0;
        this.degPerPix = 1.0 / this.pixPerDeg;
        this.pix180 = (int)(180.0 * this.pixPerDeg);
        this.pix360 = (int)(360.0 * this.pixPerDeg);
        this.pix540 = (int)(540.0 * this.pixPerDeg);
        this.zenithAngle = new double[this.baseWidth][this.baseHeight];
        this.cosDTheta = new double[this.baseWidth];
        this.mapLong = new double[this.baseWidth];
        this.mapLat = new double[this.baseHeight];
        this.cosMapColat = new double[this.baseHeight];
        this.sinMapColat = new double[this.baseHeight];
        int i = 0;
        while (i < this.pix360) {
            this.mapLong[i] = (double)i / this.pixPerDeg;
            ++i;
        }
        int j = 0;
        while (j < this.pix180) {
            double mapColat = (double)j / this.pixPerDeg;
            this.mapLat[j] = 90.0 - mapColat;
            this.cosMapColat[j] = Math.cos(M24DayNightMap.toRadians(mapColat));
            this.sinMapColat[j] = Math.sin(M24DayNightMap.toRadians(mapColat));
            ++j;
        }
        this.setSubsolarPoint(0.0, 0.0);
        this.setBackgroundColor(DEFAULT_BGCOLOR);
        this.shadedImage = LISTENER.createImage(this.baseWidth, this.baseHeight);
        this.shadedImageGfx = this.shadedImage.getGraphics();
    }

    public void setBaseImage(Image img) {
        Graphics g = this.baseImage.getGraphics();
        g.drawImage(img, 0, 0, this.baseWidth, this.baseHeight, LISTENER);
        BlackFilter filter = new BlackFilter(this.darkness);
        FilteredImageSource producer = new FilteredImageSource(this.baseImage.getSource(), filter);
        this.darkImage = LISTENER.createImage(producer);
        this.needsRedraw = true;
    }

    private void makeDefaultImage() {
        this.baseImage = LISTENER.createImage(720, 360);
        Graphics gfx = this.baseImage.getGraphics();
        gfx.setColor(Color.white);
        gfx.fillRect(0, 0, 720, 360);
        gfx.setColor(Color.red);
        gfx.fillRect(180, 0, 180, 180);
        gfx.fillRect(0, 180, 180, 180);
        gfx.setColor(Color.yellow);
        gfx.fillRect(360, 180, 180, 180);
        gfx.fillRect(540, 0, 180, 180);
        gfx.setColor(Color.green);
        gfx.fillRect(0, 0, 720, 5);
        gfx.setColor(Color.blue);
        gfx.fillRect(0, 355, 720, 5);
    }

    public void setSubsolarPoint(double lon, double lat) {
        this.subsolarLong = lon;
        this.subsolarLat = lat;
        this.cosSubsolarColat = Math.cos(M24DayNightMap.toRadians(90.0 - this.subsolarLat));
        this.sinSubsolarColat = Math.sin(M24DayNightMap.toRadians(90.0 - this.subsolarLat));
        this.needsRedraw = true;
    }

    public void setBackgroundColor(Color c) {
        this.bgcolor = c;
    }

    public Image getMap() {
        if (this.needsRedraw) {
            this.drawTerminator();
            this.needsRedraw = false;
        }
        return this.shadedImage;
    }

    private void drawTerminator() {
        int j;
        if (this.prepareImage(this.baseImage, LISTENER)) {
            this.shadedImageGfx.drawImage(this.baseImage, 0, 0, LISTENER);
        } else {
            this.shadedImageGfx.setColor(DEFAULT_DAYCOLOR);
            this.shadedImageGfx.fillRect(0, 0, this.baseWidth, this.baseHeight);
        }
        int darkSkip = (int)(60.0 * this.pixPerDeg);
        int i = 0;
        while (i < this.baseWidth) {
            this.cosDTheta[i] = 9999.0;
            j = 0;
            while (j < this.baseHeight) {
                this.zenithAngle[i][j] = 9999.0;
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < this.baseHeight) {
            int i2 = 0;
            while (i2 < this.baseWidth) {
                this.drawDarkness(i2, i2 + darkSkip, j, j + darkSkip);
                i2 += darkSkip;
            }
            j += darkSkip;
        }
        this.needsRedraw = false;
    }

    private void drawDarkness(int left, int right, int top, int bottom) {
        int width;
        if (left < 0) {
            left = 0;
        }
        if (left > this.pix360) {
            left = this.pix360;
        }
        if (right < 0) {
            right = 0;
        }
        if (right > this.pix360) {
            right = this.pix360;
        }
        if (top < 0) {
            top = 0;
        }
        if (top > this.pix180) {
            top = this.pix180;
        }
        if (bottom < 0) {
            bottom = 0;
        }
        if (bottom > this.pix180) {
            bottom = this.pix180;
        }
        if ((width = right - left) < 1) {
            return;
        }
        int height = bottom - top;
        if (height < 1) {
            return;
        }
        int darkness = 0;
        int k = 0;
        while (k < 4) {
            int jx;
            int ix;
            if (k == 0) {
                ix = left;
                jx = top;
            } else if (k == 1) {
                ix = right - 1;
                jx = top;
            } else if (k == 2) {
                ix = left;
                jx = bottom - 1;
            } else {
                ix = right - 1;
                jx = bottom - 1;
            }
            if (this.zenithAngle[ix][jx] == 9999.0) {
                if (this.cosDTheta[ix] == 9999.0) {
                    this.cosDTheta[ix] = Math.cos(M24DayNightMap.toRadians(this.subsolarLong - this.mapLong[ix]));
                }
                double cosZenithAngle = this.cosSubsolarColat * this.cosMapColat[jx] + this.sinSubsolarColat * this.sinMapColat[jx] * this.cosDTheta[ix];
                this.zenithAngle[ix][jx] = M24DayNightMap.toDegrees(Math.acos(cosZenithAngle));
            }
            darkness = this.zenithAngle[ix][jx] > 90.0 ? ++darkness : --darkness;
            ++k;
        }
        if (darkness == 4) {
            if (left < this.pix180) {
                this.shadedImageGfx.drawImage(this.darkImage, this.pix180 - right, top, this.pix180 - left, bottom, this.pix180 - right, top, this.pix180 - left, bottom, LISTENER);
            } else {
                this.shadedImageGfx.drawImage(this.darkImage, this.pix540 - right, top, this.pix540 - left, bottom, this.pix540 - right, top, this.pix540 - left, bottom, LISTENER);
            }
        } else if (darkness > -4) {
            if (width < height) {
                int vertAve = (top + bottom) / 2;
                this.drawDarkness(left, right, top, vertAve);
                this.drawDarkness(left, right, vertAve, bottom);
            } else {
                int horizAve = (left + right) / 2;
                this.drawDarkness(left, horizAve, top, bottom);
                this.drawDarkness(horizAve, right, top, bottom);
            }
        }
    }

    public static final double toDegrees(double radians) {
        return radians * DEG_PER_RAD;
    }

    public static final double toRadians(double degrees) {
        return degrees * RAD_PER_DEG;
    }

    public static class BlackFilter
    extends RGBImageFilter {
        private int howDark = 50;

        public BlackFilter() {
            this.canFilterIndexColorModel = true;
        }

        public BlackFilter(int darkSetting) {
            this.canFilterIndexColorModel = true;
            this.howDark = darkSetting < 0 ? 0 : (darkSetting > 100 ? 100 : darkSetting);
        }

        public int filterRGB(int x, int y, int rgb) {
            int a = rgb & 0xFF000000;
            int r = (rgb & 0xFF0000) * this.howDark / 100 & 0xFF0000;
            int g = (rgb & 0xFF00) * this.howDark / 100 & 0xFF00;
            int b = (rgb & 0xFF) * this.howDark / 100 & 0xFF;
            return a | r | g | b;
        }
    }
}

