/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24.application;

import gov.nasa.giss.mars24.M24Timekeeper;
import gov.nasa.giss.mars24.M24TimekeeperEvent;
import gov.nasa.giss.mars24.M24TimekeeperListener;
import gov.nasa.giss.mars24.application.M24DisplayPanel;
import gov.nasa.giss.math.Mathlib;
import gov.nasa.giss.time.EarthTime;
import gov.nasa.giss.time.JulianDate;
import gov.nasa.giss.time.MarsTime;
import gov.nasa.giss.time.MissionTime;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class M24TimePanel
extends JPanel
implements M24DisplayPanel,
M24TimekeeperListener {
    private static final double SEC_PER_AU = 499.0047838061357;
    public static final int SHOW_LTST = 1;
    public static final int SHOW_LMST = 2;
    public static final int SHOW_LMZT = 3;
    public static final int SHOW_MTC = 4;
    public static final int SHOW_VIK1 = 101;
    public static final int SHOW_VIK2 = 102;
    public static final int SHOW_MPF = 103;
    public static final int SHOW_BEAGLE = 104;
    public static final int SHOW_MERA = 105;
    public static final int SHOW_MERB = 106;
    public static final int SHOW_MERA_MERB = 1001;
    private static final int MARGIN = 12;
    private static final int GUTTER = 12;
    private static final DecimalFormat FORMAT_X0 = new DecimalFormat("0");
    private static final DecimalFormat FORMAT_20 = new DecimalFormat("00");
    private static final DecimalFormat FORMAT_X1 = new DecimalFormat("0.0");
    private static final DecimalFormat FORMAT_X2 = new DecimalFormat("0.00");
    private static final DecimalFormat FORMAT_X3 = new DecimalFormat("0.000");
    private M24Timekeeper timekeeper;
    private int timeForm = 2;
    private Image offscreen;
    private int panelWidth;
    private int panelHeight;
    private int halfWidth;
    private int colWidth;
    private int col1center;
    private int col2center;
    private int fHeightLarge;
    private int fHeightMedium;
    private int fHeightSmall;
    private Font fontLarge;
    private Font fontMedium;
    private Font fontSmall;
    private int fontWeight = 1;
    private FontMetrics fm;
    private boolean initialized = false;
    private MissionTime merACount;
    private MissionTime merBCount;
    private MissionTime beagleCount;

    public M24TimePanel() {
        throw new IllegalArgumentException("Use another constructor");
    }

    public M24TimePanel(M24Timekeeper tk) {
        if (tk == null) {
            throw new IllegalArgumentException("Timekeeper cannot be null");
        }
        this.timekeeper = tk;
        this.timekeeper.addTimekeeperListener(this);
        this.fHeightLarge = 26;
        this.fHeightMedium = 20;
        this.fHeightSmall = 18;
        this.fontLarge = new Font("Courier", this.fontWeight, this.fHeightLarge);
        this.fontMedium = new Font("Courier", this.fontWeight, this.fHeightMedium);
        this.fontSmall = new Font("Courier", this.fontWeight, this.fHeightSmall);
        this.colWidth = 10 + 32 * this.fHeightLarge / 3;
        this.panelWidth = 12 + this.colWidth + 12 + this.colWidth + 12;
        this.panelHeight = 12 + 9 * (this.fHeightLarge + 2) + 12 + 12;
        this.halfWidth = this.panelWidth / 2;
        this.col1center = 12 + this.colWidth / 2;
        this.col2center = this.panelWidth - 12 - this.colWidth / 2;
        this.setPreferredSize(new Dimension(this.panelWidth, this.panelHeight));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        this.setBackground(Color.black);
        this.setOpaque(true);
    }

    public void paintComponent(Graphics g) {
        if (!this.initialized) {
            this.offscreen = this.createImage(this.panelWidth, this.panelHeight);
            this.initialized = true;
        }
        MarsTime mTime = this.timekeeper.getMarsTime();
        EarthTime eTime = this.timekeeper.getEarthTime();
        JulianDate jTime = this.timekeeper.getJulianDate();
        Graphics ogfx = this.offscreen.getGraphics();
        ogfx.setColor(Color.black);
        ogfx.fillRect(0, 0, this.panelWidth, this.panelHeight);
        if (mTime == null) {
            ogfx.setColor(Color.red);
            ogfx.setFont(this.fontLarge);
            this.fm = ogfx.getFontMetrics();
            String message1 = "Time/date out of valid range or not";
            String message2 = "well-formatted. Please re-enter.";
            ogfx.drawString(message1, (this.panelWidth - this.fm.stringWidth(message1)) / 2, (this.panelHeight - this.fHeightLarge) / 2 - 2);
            ogfx.drawString(message2, (this.panelWidth - this.fm.stringWidth(message2)) / 2, (this.panelHeight + this.fHeightLarge) / 2 + 2);
            g.drawImage(this.offscreen, 0, 0, this);
            ogfx.dispose();
            return;
        }
        String airyMeanTime = mTime.getTimestr(0.0, 1, false);
        StringBuffer mTimestrBuffer = new StringBuffer("");
        switch (this.timeForm) {
            case 1: {
                mTimestrBuffer.append(mTime.getTimestr(this.timekeeper.getSiteLongitude(), 2, true));
                break;
            }
            case 3: {
                mTimestrBuffer.append(mTime.getTimestr(this.timekeeper.getZoneLongitude(), 1, false));
                mTimestrBuffer.append(" LMZT");
                break;
            }
            case 4: {
                mTimestrBuffer.append(airyMeanTime).append(" MTC");
                break;
            }
            default: {
                mTimestrBuffer.append(mTime.getTimestr(this.timekeeper.getZoneLongitude(), 1, true));
            }
        }
        double zenithAngle = mTime.getZenithAngle(this.timekeeper.getSiteLongitude(), this.timekeeper.getSiteLatitude());
        double azimuthAngle = mTime.getAzimuthAngle(this.timekeeper.getSiteLongitude(), this.timekeeper.getSiteLatitude());
        if (azimuthAngle < 0.0) {
            azimuthAngle += 360.0;
        }
        String elevationString = "Solar Elev. " + FORMAT_X1.format(90.0 - zenithAngle) + "\u00b0";
        String azimuthString = "Solar Azim. " + FORMAT_X1.format(azimuthAngle) + "\u00b0";
        int heightM = 5 * (this.fHeightLarge + 2);
        int heightE = 3 * (this.fHeightLarge + 2);
        ogfx.setColor(Color.white);
        ogfx.setFont(this.fontMedium);
        int y = 12 + this.fHeightMedium;
        this.drawText(ogfx, "MARS", 0, y);
        ogfx.setColor(Color.green);
        ogfx.setFont(this.fontLarge);
        y += 4 + this.fHeightLarge;
        switch (this.timeForm) {
            case 105: {
                this.merACount = mTime.getMissionTime("MERA");
                if (this.merACount.getSol() == Long.MIN_VALUE) {
                    this.drawText(ogfx, "MER-A T.B.L.", 0, y);
                    break;
                }
                if (this.merACount.getSol() < 0L) {
                    this.drawText(ogfx, "MER-A In Flight", 0, y);
                    break;
                }
                this.drawText(ogfx, "MER-A " + this.formatMissionTime(this.merACount), 0, y);
                break;
            }
            case 106: {
                this.merBCount = mTime.getMissionTime("MERB");
                if (this.merBCount.getSol() == Long.MIN_VALUE) {
                    this.drawText(ogfx, "MER-B T.B.L.", 0, y);
                    break;
                }
                if (this.merBCount.getSol() < 0L) {
                    this.drawText(ogfx, "MER-B In Flight", 0, y);
                    break;
                }
                this.drawText(ogfx, "MER-B " + this.formatMissionTime(this.merBCount), 0, y);
                break;
            }
            case 1001: {
                this.merACount = mTime.getMissionTime("MERA");
                if (this.merACount.getSol() == Long.MIN_VALUE) {
                    this.drawText(ogfx, "MER-A T.B.L.", 1, y);
                } else if (this.merACount.getSol() < 0L) {
                    this.drawText(ogfx, "MER-A In Flight", 1, y);
                } else {
                    this.drawText(ogfx, "MER-A " + this.formatMissionTime(this.merACount), 1, y);
                }
                this.merBCount = mTime.getMissionTime("MERB");
                if (this.merBCount.getSol() == Long.MIN_VALUE) {
                    this.drawText(ogfx, "MER-B T.B.L.", 2, y);
                    break;
                }
                if (this.merBCount.getSol() < 0L) {
                    this.drawText(ogfx, "MER-B In Flight", 2, y);
                    break;
                }
                this.drawText(ogfx, "MER-B " + this.formatMissionTime(this.merBCount), 2, y);
                break;
            }
            case 104: {
                this.beagleCount = mTime.getMissionTime("BEA");
                if (this.beagleCount.getSol() == Long.MIN_VALUE) {
                    this.drawText(ogfx, "BEA T.B.L.", 0, y);
                    break;
                }
                if (this.beagleCount.getSol() < 0L) {
                    this.drawText(ogfx, "BEA In Flight", 0, y);
                    break;
                }
                this.drawText(ogfx, "BEA " + this.formatMissionTime(this.beagleCount), 0, y);
                break;
            }
            default: {
                this.drawText(ogfx, airyMeanTime + " MTC", 1, y);
                this.drawText(ogfx, mTimestrBuffer.toString(), 2, y);
            }
        }
        ogfx.setColor(Color.red);
        ogfx.setFont(this.fontMedium);
        y += 4 + this.fHeightMedium;
        switch (this.timeForm) {
            case 105: {
                if (this.merACount.getSol() != Long.MIN_VALUE) {
                    this.drawText(ogfx, "Sol " + this.merACount.getSol(), 0, y);
                }
                y += 2;
                break;
            }
            case 106: {
                if (this.merBCount.getSol() != Long.MIN_VALUE) {
                    this.drawText(ogfx, "Sol " + this.merBCount.getSol(), 0, y);
                }
                y += 2;
                break;
            }
            case 1001: {
                if (this.merACount.getSol() != Long.MIN_VALUE) {
                    this.drawText(ogfx, "Sol " + this.merACount.getSol(), 1, y);
                }
                if (this.merBCount.getSol() != Long.MIN_VALUE) {
                    this.drawText(ogfx, "Sol " + this.merBCount.getSol(), 2, y);
                }
                y += 2;
                break;
            }
            case 104: {
                if (this.beagleCount.getSol() != Long.MIN_VALUE) {
                    this.drawText(ogfx, "Sol " + this.beagleCount.getSol(), 0, y);
                }
                y += 2;
                break;
            }
            default: {
                this.drawText(ogfx, "MSD " + FORMAT_X3.format(mTime.getMarsSolDate()), 1, y);
                this.drawText(ogfx, "at " + FORMAT_X2.format(this.timekeeper.getSiteLongitude()) + "\u00b0W " + FORMAT_X2.format(this.timekeeper.getSiteLatitude()) + "\u00b0N", 2, y);
            }
        }
        ogfx.setColor(Color.red);
        ogfx.setFont(this.fontSmall);
        y += 4 + this.fHeightSmall + 4;
        switch (this.timeForm) {
            case 105: 
            case 106: 
            case 1001: {
                this.drawText(ogfx, "MSD " + FORMAT_X3.format(mTime.getMarsSolDate()), 1, y);
                this.drawText(ogfx, "Ls " + FORMAT_X2.format(mTime.getSolarLongitude()) + "\u00b0", 2, y);
                break;
            }
            default: {
                this.drawText(ogfx, "Ls " + FORMAT_X2.format(mTime.getSolarLongitude()) + "\u00b0", 1, y);
                this.drawText(ogfx, elevationString, 2, y);
            }
        }
        ogfx.setColor(Color.red);
        ogfx.setFont(this.fontSmall);
        y += 4 + this.fHeightSmall;
        switch (this.timeForm) {
            case 105: 
            case 106: 
            case 1001: {
                this.drawText(ogfx, airyMeanTime + " MTC", 1, y);
                this.drawText(ogfx, mTime.getSeason(this.timekeeper.getSiteLatitude() >= 0.0), 2, y);
                break;
            }
            default: {
                this.drawText(ogfx, mTime.getSeason(this.timekeeper.getSiteLatitude() >= 0.0), 1, y);
                this.drawText(ogfx, azimuthString, 2, y);
            }
        }
        y += 16;
        ogfx.setColor(Color.white);
        ogfx.setFont(this.fontMedium);
        this.drawText(ogfx, "EARTH", 0, y += this.fHeightMedium);
        ogfx.setColor(Color.green);
        ogfx.setFont(this.fontLarge);
        this.drawText(ogfx, eTime.getTime(), 1, y += 4 + this.fHeightLarge);
        this.drawText(ogfx, eTime.getTime(true), 2, y);
        ogfx.setColor(Color.red);
        ogfx.setFont(this.fontMedium);
        this.drawText(ogfx, eTime.getDate(false, this.timekeeper.getShowDateAsDOY()), 1, y += 4 + this.fHeightMedium);
        this.drawText(ogfx, eTime.getDate(true, this.timekeeper.getShowDateAsDOY()), 2, y);
        ogfx.setColor(Color.red);
        ogfx.setFont(this.fontSmall);
        this.drawText(ogfx, "MJD " + FORMAT_X3.format(jTime.getJDate(2)), 1, y += 4 + this.fHeightSmall + 4);
        this.drawText(ogfx, "Light dist. " + this.getLightTime(mTime, eTime), 2, y);
        g.drawImage(this.offscreen, 0, 0, this);
        ogfx.dispose();
        if ((y += 16) != this.panelHeight) {
            this.panelHeight = y;
            this.setPreferredSize(new Dimension(this.panelWidth, this.panelHeight));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            JFrame f = (JFrame)this.getTopLevelAncestor();
            if (f != null) {
                f.pack();
            }
        }
        g.setColor(Color.gray);
        g.drawRect(0, 0, this.panelWidth - 1, this.panelHeight - 1);
    }

    private void drawText(Graphics g, String text, int col, int y) {
        int w = g.getFontMetrics().stringWidth(text);
        if (col == 0) {
            g.drawString(text, (this.panelWidth - w) / 2, y);
            return;
        }
        if (col == 1) {
            g.drawString(text, this.col1center - w / 2, y);
        } else if (col == 2) {
            g.drawString(text, this.col2center - w / 2, y);
        }
    }

    public String formatMissionTime(MissionTime mt) {
        double t = mt.getTimeOfDay();
        int hour = (int)(t * 24.0);
        t = t * 24.0 % 1.0;
        int min = (int)(t * 60.0);
        t = t * 60.0 % 1.0;
        int sec = (int)(t * 60.0);
        t = t * 60.0 % 1.0;
        return FORMAT_20.format(hour) + ":" + FORMAT_20.format(min) + ":" + FORMAT_20.format(sec);
    }

    public int getTimeForm() {
        return this.timeForm;
    }

    public void setTimeForm(int form) {
        this.timeForm = form;
    }

    private String getLightTime(MarsTime marsTime, EarthTime earthTime) {
        double rM = marsTime.getHeliocentricDistance();
        double rE = earthTime.getHeliocentricDistance();
        double lambdaM = marsTime.getHeliocentricLongitude();
        double lambdaE = earthTime.getHeliocentricLongitude();
        double psiM = marsTime.getHeliocentricLatitude();
        double angle = Mathlib.toRadians(lambdaM - lambdaE);
        double distAU = Math.sqrt(rE * rE + rM * rM - 2.0 * rE * rM * Math.cos(angle) * Math.cos(Mathlib.toRadians(psiM)));
        double distLight = distAU * 499.0047838061357;
        int isec = (int)Math.round(distLight);
        int isecX = isec % 60;
        int iminX = (isec - isecX) / 60;
        return iminX + ":" + FORMAT_20.format(isecX);
    }

    public Image getImage() {
        return this.offscreen;
    }

    public void timeChanged(M24TimekeeperEvent e) {
        this.repaint();
    }

    public void formatChanged(M24TimekeeperEvent e) {
        this.repaint();
    }

    public void siteChanged(M24TimekeeperEvent e) {
        this.repaint();
    }
}

