/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.netcdf.NCDataset;
import gov.nasa.giss.netcdf.NCDimensionChoice;
import gov.nasa.giss.netcdf.NCPlotAxis;
import gov.nasa.giss.netcdf.NCVariable;
import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.nc2.Variable;
import ucar.nc2.VariableStandardized;
import ucar.nc2.dataset.VariableDS;

public class NCVariablePlottable {
    public static final int OTHER_VAR = 0;
    public static final int LON_LAT_VAR = 1;
    public static final int LON_LAT_VERT_VAR = 2;
    public static final int LAT_VERT_VAR = 3;
    protected NCDataset dataset;
    protected VariableDS varDS;
    protected VariableStandardized varST;
    protected Array slice;
    protected int plotType = 0;
    protected boolean hasMissing = false;
    protected int noVerts = -1;
    protected int noLats = -1;
    protected int noLons = -1;
    protected String vertName = null;
    protected String latName = null;
    protected String lonName = null;
    protected NCPlotAxis vertAxis;
    protected NCPlotAxis latAxis;
    protected NCPlotAxis lonAxis;
    protected int rank;
    protected int[] shape;
    protected int sliceRank;
    protected int[] sliceIndex;
    protected boolean sliceMade = false;
    protected ArrayList sliceMenuList = new ArrayList(3);
    protected double minimum = Double.NaN;
    protected double maximum = Double.NaN;

    protected NCVariablePlottable() {
    }

    public NCVariablePlottable(NCDataset d, String name) {
        this(d, d.findVariable(name));
    }

    public NCVariablePlottable(NCDataset d, NCVariable v) {
        this(d, (VariableDS)v.getObject());
    }

    public NCVariablePlottable(NCDataset d, VariableDS v) {
        this.dataset = d;
        this.varDS = v;
        this.init();
    }

    private void init() {
        this.plotType = this.getPlottingType();
        if (this.plotType == 0) {
            throw new IllegalArgumentException("Not a plottable variable");
        }
        this.varST = new VariableStandardized((Variable)this.varDS, true);
        this.hasMissing = this.varST.hasMissing();
        this.rank = this.varDS.getRank();
        int lonDim = -1;
        int latDim = -1;
        int vertDim = -1;
        if (this.plotType == 1) {
            latDim = this.rank - 2;
            lonDim = this.rank - 1;
        } else if (this.plotType == 2) {
            vertDim = this.rank - 3;
            latDim = this.rank - 2;
            lonDim = this.rank - 1;
        } else if (this.plotType == 3) {
            vertDim = this.rank - 2;
            latDim = this.rank - 1;
        }
        if (vertDim > -1) {
            this.noVerts = this.varDS.getDimension(vertDim).getLength();
            this.vertName = this.varDS.getDimension(vertDim).getName();
            this.vertAxis = new NCPlotAxis(this.dataset, this.vertName);
        }
        if (latDim > -1) {
            this.noLats = this.varDS.getDimension(latDim).getLength();
            this.latName = this.varDS.getDimension(latDim).getName();
            this.latAxis = new NCPlotAxis(this.dataset, this.latName);
        }
        if (lonDim > -1) {
            this.noLons = this.varDS.getDimension(lonDim).getLength();
            this.lonName = this.varDS.getDimension(lonDim).getName();
            this.lonAxis = new NCPlotAxis(this.dataset, this.lonName);
        }
        this.shape = this.varDS.getShape();
        this.sliceRank = this.rank - 2;
        if (this.sliceRank > 0) {
            this.sliceIndex = new int[this.sliceRank];
            this.sliceMenuList.ensureCapacity(this.sliceRank);
            int i = 0;
            while (i < this.sliceRank) {
                this.sliceIndex[i] = 0;
                this.sliceMenuList.add(new NCDimensionChoice(this.dataset, this.varDS.getDimension(i)));
                ++i;
            }
            this.sliceMenuList.trimToSize();
        }
    }

    public NCDataset getDataset() {
        return this.dataset;
    }

    public String getUnits() {
        StringBuffer sb = new StringBuffer();
        if (this.varDS.findAttribute("units") == null) {
            return "";
        }
        sb.append(this.varDS.findAttribute("units").getStringValue());
        if (sb.charAt(sb.length() - 1) != ' ') {
            return sb.toString();
        }
        int isize = sb.length();
        int i = 0;
        while (i < isize) {
            if (sb.charAt(sb.length() - 1) != ' ') {
                return sb.toString();
            }
            sb.deleteCharAt(sb.length() - 1);
            ++i;
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.toString();
    }

    public boolean hasMissingValue() {
        return this.hasMissing;
    }

    public boolean isMissing(double value) {
        if (this.hasMissing) {
            return this.varST.isMissing(value);
        }
        return false;
    }

    public NCPlotAxis getAxis(String gname) {
        if (gname.equals("latitude")) {
            return this.latAxis;
        }
        if (gname.equals("longitude")) {
            return this.lonAxis;
        }
        if (gname.equals("vertical")) {
            return this.vertAxis;
        }
        return null;
    }

    public int getAxisLength(String gname) {
        if (gname.equals("latitude")) {
            return this.noLats;
        }
        if (gname.equals("longitude")) {
            return this.noLons;
        }
        if (gname.equals("vertical")) {
            return this.noVerts;
        }
        return -1;
    }

    public ArrayList getSliceMenus() {
        return this.sliceMenuList;
    }

    public double minimumValue() {
        if (!this.sliceMade) {
            this.makeSlice();
        }
        return this.minimum;
    }

    public double maximumValue() {
        if (!this.sliceMade) {
            this.makeSlice();
        }
        return this.maximum;
    }

    public void setSliceIndex(int whichDimension, int indexValue) {
        this.sliceMade = false;
        this.minimum = Double.NaN;
        this.maximum = Double.NaN;
        if (whichDimension + 1 > this.sliceRank) {
            return;
        }
        this.sliceIndex[whichDimension] = indexValue;
    }

    public double valueAt(int row, int col) {
        if (!this.sliceMade) {
            this.makeSlice();
        }
        try {
            return this.slice.getDouble(this.slice.getIndex().set(row, col));
        }
        catch (Exception exc) {
            System.out.println(exc.toString());
            System.out.println("NCVP.valueAt " + row + " , " + col);
            System.out.println("slice " + this.slice);
            System.out.println("index " + this.slice.getIndex());
            System.out.println("shape " + this.slice.getShape());
            System.out.println("=====");
            exc.printStackTrace();
            System.exit(0);
            return 0.0;
        }
    }

    public double zonalAverageOf(int row) {
        if (!this.sliceMade) {
            this.makeSlice();
        }
        if (this.plotType == 3) {
            throw new IllegalArgumentException("LatVert does not have zonal avg.");
        }
        double result = Double.NaN;
        int count = 0;
        int i = 0;
        while (i < this.noLons) {
            double val = this.slice.getDouble(this.slice.getIndex().set(row, i));
            if (!Double.isNaN(val)) {
                result = count > 1 ? (result += val) : val;
                ++count;
            }
            ++i;
        }
        if (count < 2) {
            return result;
        }
        return result /= (double)count;
    }

    protected boolean makeSlice() {
        try {
            int[] sOrigin = new int[this.rank];
            int[] sShape = new int[this.rank];
            int i = 0;
            while (i < this.sliceRank) {
                sOrigin[i] = this.sliceIndex[i];
                sShape[i] = 1;
                ++i;
            }
            sOrigin[this.rank - 2] = 0;
            sOrigin[this.rank - 1] = 0;
            sShape[this.rank - 2] = this.shape[this.rank - 2];
            sShape[this.rank - 1] = this.shape[this.rank - 1];
            this.slice = this.varST.read(sOrigin, sShape).reduce();
            if (this.vertAxis != null && this.vertAxis.isFlipped()) {
                this.slice = this.slice.flip(0);
            }
            if (this.latAxis != null && this.latAxis.isFlipped()) {
                this.slice = this.plotType == 3 ? this.slice.flip(1) : this.slice.flip(0);
            }
            this.sliceMade = true;
            this.findExtrema();
        }
        catch (Exception exc) {
            System.out.println("NCVP.makeSlice : " + exc.toString());
            exc.printStackTrace();
            System.exit(0);
        }
        return this.sliceMade;
    }

    protected void findExtrema() {
        int imax = 0;
        int jmax = 0;
        if (this.plotType == 1 || this.plotType == 2) {
            imax = this.noLons;
            jmax = this.noLats;
        } else if (this.plotType == 3) {
            imax = this.noLats;
            jmax = this.noVerts;
        }
        try {
            if (this.hasMissing) {
                int j = 0;
                while (j < jmax) {
                    int i = 0;
                    while (i < imax) {
                        double value = this.valueAt(j, i);
                        if (!this.varST.isMissing(value)) {
                            if (Double.isNaN(this.minimum) || value < this.minimum) {
                                this.minimum = value;
                            } else if (Double.isNaN(this.maximum) || value > this.maximum) {
                                this.maximum = value;
                            }
                        }
                        ++i;
                    }
                    ++j;
                }
            } else {
                int j = 0;
                while (j < jmax) {
                    int i = 0;
                    while (i < imax) {
                        double value = this.valueAt(j, i);
                        if (Double.isNaN(this.minimum) || value < this.minimum) {
                            this.minimum = value;
                        } else if (Double.isNaN(this.maximum) || value > this.maximum) {
                            this.maximum = value;
                        }
                        ++i;
                    }
                    ++j;
                }
            }
        }
        catch (Exception exc) {
            System.out.println("variable.findExtrema : " + exc.toString());
        }
    }

    public String getName() {
        return this.varDS.getName();
    }

    public String getLongName() {
        StringBuffer sb = new StringBuffer();
        if (this.varDS.findAttribute("long_name") != null) {
            sb.append(this.varDS.findAttribute("long_name").getStringValue());
        } else if (this.varDS.findAttribute("standard_name") != null) {
            sb.append(this.varDS.findAttribute("standard_name").getStringValue().replace('_', ' '));
        } else {
            return "-";
        }
        if (sb.charAt(sb.length() - 1) != ' ') {
            return sb.toString();
        }
        int isize = sb.length();
        int i = 0;
        while (i < isize) {
            if (sb.charAt(sb.length() - 1) != ' ') {
                return sb.toString();
            }
            sb.deleteCharAt(sb.length() - 1);
            ++i;
        }
        if (sb.length() == 0) {
            return "-";
        }
        return sb.toString();
    }

    public String getDetail() {
        StringBuffer sb = new StringBuffer("");
        if (this.varDS.isCoordinateVariable()) {
            sb.append("coordinate variable");
        } else {
            sb.append("variable");
        }
        sb.append(" \"").append(this.getName()).append("\"\n");
        sb.append("--------\n");
        sb.append(this.varDS.toString());
        return sb.toString();
    }

    public int getPlottingType() {
        return NCVariable.getPlottingType(this.varDS);
    }
}

