/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.netcdf.NCDataset;
import gov.nasa.giss.netcdf.NCDimensionChoice;
import gov.nasa.giss.netcdf.NCPlotAxis;
import gov.nasa.giss.netcdf.NCVariable;
import gov.nasa.giss.netcdf.NCVariablePlottable;
import ucar.nc2.Variable;
import ucar.nc2.VariableStandardized;
import ucar.nc2.dataset.VariableDS;

public class NCVariablePlottable3D
extends NCVariablePlottable {
    private double[][][] values3D;
    private double[][] averages;

    public NCVariablePlottable3D(NCDataset d, String name) {
        this(d, d.findVariable(name));
    }

    public NCVariablePlottable3D(NCDataset d, NCVariable v) {
        this(d, (VariableDS)v.getObject());
    }

    public NCVariablePlottable3D(NCDataset d, VariableDS v) {
        this.dataset = d;
        this.varDS = v;
        this.init();
    }

    private void init() {
        this.plotType = this.getPlottingType();
        if (this.plotType != 2) {
            throw new IllegalArgumentException("Not a plottable 3D variable");
        }
        this.varST = new VariableStandardized((Variable)this.varDS, true);
        this.hasMissing = this.varST.hasMissing();
        this.rank = this.varDS.getRank();
        int lonDim = this.rank - 1;
        int latDim = this.rank - 2;
        int vertDim = this.rank - 3;
        this.shape = this.varDS.getShape();
        this.noVerts = this.varDS.getDimension(vertDim).getLength();
        this.vertName = this.varDS.getDimension(vertDim).getName();
        this.vertAxis = new NCPlotAxis(this.dataset, this.vertName);
        this.noLats = this.varDS.getDimension(latDim).getLength();
        this.latName = this.varDS.getDimension(latDim).getName();
        this.latAxis = new NCPlotAxis(this.dataset, this.latName);
        this.sliceRank = this.rank - 2;
        if (this.sliceRank > 0) {
            this.sliceIndex = new int[this.sliceRank];
            this.sliceMenuList.ensureCapacity(this.sliceRank);
            int i = 0;
            while (i < this.sliceRank - 1) {
                this.sliceMenuList.add(new NCDimensionChoice(this.dataset, this.varDS.getDimension(i)));
                this.sliceIndex[i] = 0;
                ++i;
            }
            this.sliceMenuList.add(new NCDimensionChoice(this.dataset, this.varDS.getDimension(this.rank - 1), true));
            this.sliceIndex[this.sliceRank - 1] = 0;
            this.sliceMenuList.trimToSize();
        }
        this.values3D = new double[this.shape[this.rank - 3]][this.shape[this.rank - 2]][this.shape[this.rank - 1]];
        this.averages = new double[this.shape[this.rank - 3]][this.shape[this.rank - 2]];
    }

    protected boolean makeSlice() {
        try {
            int[] sOrigin = new int[this.rank];
            int[] sShape = new int[this.rank];
            int i = 0;
            while (i < this.sliceRank - 1) {
                sOrigin[i] = this.sliceIndex[i];
                sShape[i] = 1;
                ++i;
            }
            sOrigin[this.rank - 3] = 0;
            sOrigin[this.rank - 2] = 0;
            sShape[this.rank - 3] = this.shape[this.rank - 3];
            sShape[this.rank - 2] = this.shape[this.rank - 2];
            sOrigin[this.rank - 1] = 0;
            sShape[this.rank - 1] = this.shape[this.rank - 1];
            this.slice = this.varST.read(sOrigin, sShape).reduce();
            if (this.vertAxis.isFlipped()) {
                this.slice = this.slice.flip(0);
            }
            if (this.latAxis.isFlipped()) {
                this.slice = this.slice.flip(1);
            }
            this.sliceMade = true;
            int k = 0;
            while (k < this.shape[this.rank - 3]) {
                int j = 0;
                while (j < this.shape[this.rank - 2]) {
                    this.averages[k][j] = 0.0;
                    int count = 0;
                    int i2 = 0;
                    while (i2 < this.shape[this.rank - 1]) {
                        double v;
                        this.values3D[k][j][i2] = v = this.slice.getDouble(this.slice.getIndex().set(k, j, i2));
                        if (!this.varST.isMissing(v)) {
                            double[] dArray = this.averages[k];
                            int n = j;
                            dArray[n] = dArray[n] + v;
                            ++count;
                        }
                        ++i2;
                    }
                    double[] dArray = this.averages[k];
                    int n = j++;
                    dArray[n] = dArray[n] / (double)count;
                }
                ++k;
            }
            this.findExtrema();
        }
        catch (Exception exc) {
            System.out.println("NCVP3D.makeSlice : " + exc.toString());
            exc.printStackTrace();
        }
        return this.sliceMade;
    }

    protected void findExtrema() {
        try {
            if (this.hasMissing) {
                int k = 0;
                while (k < this.noVerts) {
                    int j = 0;
                    while (j < this.noLats) {
                        double value = this.valueAt(k, j);
                        if (!this.isMissing(value)) {
                            if (Double.isNaN(this.minimum) || value < this.minimum) {
                                this.minimum = value;
                            } else if (Double.isNaN(this.maximum) || value > this.maximum) {
                                this.maximum = value;
                            }
                        }
                        ++j;
                    }
                    ++k;
                }
            } else {
                int k = 0;
                while (k < this.noVerts) {
                    int j = 0;
                    while (j < this.noLats) {
                        double value = this.valueAt(k, j);
                        if (Double.isNaN(this.minimum) || value < this.minimum) {
                            this.minimum = value;
                        } else if (Double.isNaN(this.maximum) || value > this.maximum) {
                            this.maximum = value;
                        }
                        ++j;
                    }
                    ++k;
                }
            }
        }
        catch (Exception exc) {
            System.out.println("NCPV3D.findExtrema : " + exc.toString());
        }
    }

    public void setSliceIndex(int whichDimension, int indexValue) {
        if (!this.sliceMade || whichDimension != this.sliceIndex.length - 1) {
            this.sliceMade = false;
            this.minimum = Double.NaN;
            this.maximum = Double.NaN;
            if (whichDimension + 1 > this.sliceRank) {
                return;
            }
        }
        this.sliceIndex[whichDimension] = indexValue;
    }

    public double valueAt(int row, int col) {
        if (!this.sliceMade) {
            this.makeSlice();
        }
        if (this.sliceIndex[this.sliceRank - 1] == this.shape[this.rank - 1]) {
            return this.averages[row][col];
        }
        return this.values3D[row][col][this.sliceIndex[this.sliceRank - 1]];
    }
}

