/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.netcdf.NCDataset;
import gov.nasa.giss.time.ClimateModelCalendar;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import ucar.nc2.Variable;

public class RelativeTime {
    private static final String[] ISO_FORMAT_STRINGS = new String[]{"yyyy-MM-dd HH:mm:ss z", "yyyy-MM-dd'T'HH:mm:ss z", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd", "yyyy-MM", "yyyy"};
    private static final String HOUR_FORMAT_STRING = "yyyy-MM-dd HH:mm";
    private static final String DATE_FORMAT_STRING = "yyyy-MM-dd";
    private static final String MONTH_FORMAT_STRING = "yyyy-MM";
    private int incrementField;
    private Date reference;
    private Calendar calendar;
    private SimpleDateFormat dtFormat;

    public RelativeTime(String units) throws ParseException {
        this(units, "gregorian");
    }

    public RelativeTime(String units, String calendarName) throws ParseException {
        this.init(units, calendarName);
    }

    public RelativeTime(NCDataset dataset, Variable dimVar) throws ParseException {
        String units;
        try {
            units = dimVar.findAttribute("units").getStringValue();
        }
        catch (Exception exc) {
            throw new ParseException("Variable has no units!", -1);
        }
        String calendarName = dimVar.findAttribute("calendar") != null ? dimVar.findAttribute("calendar").getStringValue().toLowerCase() : (dataset != null && dataset.findGlobalAttribute("calendar") != null ? dataset.findGlobalAttribute("calendar").getStringValue().toLowerCase() : "gregorian");
        this.init(units, calendarName);
    }

    private void init(String units, String calendarName) throws ParseException {
        int sinceIndex = units.indexOf(" since ");
        if (sinceIndex < 1) {
            throw new ParseException("Not relative time units", -1);
        }
        if (units.startsWith("year")) {
            this.incrementField = 1;
        } else if (units.startsWith("month")) {
            this.incrementField = 2;
        } else if (units.startsWith("day")) {
            this.incrementField = 5;
        } else if (units.startsWith("hour")) {
            this.incrementField = 10;
        } else if (units.startsWith("minute")) {
            this.incrementField = 12;
        } else if (units.startsWith("sec")) {
            this.incrementField = 13;
        } else if (units.startsWith("msec") || units.startsWith("millisec")) {
            this.incrementField = 14;
        } else {
            throw new ParseException("I don't know how to handle units '" + units + "'", -1);
        }
        if (calendarName.equals("standard")) {
            calendarName = "gregorian";
        } else if (calendarName.equals("no_leap") || calendarName.equals("common_year") || calendarName.equals("365_day")) {
            calendarName = "noleap";
        } else if (calendarName.equals("366_day")) {
            calendarName = "all_leap";
        } else if (calendarName.equals("360")) {
            calendarName = "360_day";
        }
        if (calendarName.equals("gregorian") || calendarName.equals("proleptic_gregorian") || calendarName.equals("julian")) {
            this.calendar = new GregorianCalendar();
            if (calendarName.equals("proleptic_gregorian")) {
                ((GregorianCalendar)this.calendar).setGregorianChange(new Date(Long.MIN_VALUE));
            } else if (calendarName.equals("julian")) {
                ((GregorianCalendar)this.calendar).setGregorianChange(new Date(Long.MAX_VALUE));
            }
        } else if (calendarName.equals("noleap")) {
            this.calendar = new ClimateModelCalendar(0);
        } else if (calendarName.equals("all-leap")) {
            this.calendar = new ClimateModelCalendar(1);
        } else if (calendarName.equals("360-day")) {
            this.calendar = new ClimateModelCalendar(2);
        } else {
            throw new ParseException("Calendar attribute is a mystery to me.", -1);
        }
        this.dtFormat = new SimpleDateFormat();
        this.dtFormat.setCalendar(this.calendar);
        String referenceString = units.substring(sinceIndex + 7);
        int i = 0;
        while (i < ISO_FORMAT_STRINGS.length) {
            try {
                this.dtFormat.applyPattern(ISO_FORMAT_STRINGS[i]);
                this.reference = this.dtFormat.parse(referenceString);
                if (this.incrementField == 14 || this.incrementField == 13 || this.incrementField == 12) {
                    return;
                }
                this.calendar.setTime(this.reference);
                if (this.calendar.get(13) != 0 || this.calendar.get(12) != 0) {
                    return;
                }
                this.dtFormat.applyPattern(HOUR_FORMAT_STRING);
                if (this.calendar.get(10) != 0 || this.incrementField == 10 || this.incrementField == 5) {
                    return;
                }
                this.dtFormat.applyPattern(DATE_FORMAT_STRING);
                if (this.calendar.get(5) != 1) {
                    return;
                }
                this.dtFormat.applyPattern(MONTH_FORMAT_STRING);
                return;
            }
            catch (Exception exc) {
                ++i;
            }
        }
        throw new ParseException("I can't parse '" + referenceString + "'", -1);
    }

    public String add(double delta) {
        return this.add((int)delta);
    }

    public String add(int delta) {
        this.calendar.setTime(this.reference);
        this.calendar.add(this.incrementField, delta);
        return this.dtFormat.format(this.calendar.getTime());
    }
}

