/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.math.Constants;
import gov.nasa.giss.math.MathStrings;
import gov.nasa.giss.math.Mathlib;
import gov.nasa.giss.time.JulianDate;

public class TitanTime
extends JulianDate {
    private static final boolean DEBUG = false;
    public static final int MEAN_SOLAR = 1;
    public static final int TRUE_SOLAR = 2;
    public static final double TIME_RATIO = 1.027491252;
    public double meanAnomalyRad = 0.0;
    public double alphaFMS = 0.0;
    public double ellS = 0.0;
    public double ellSRad = 0.0;
    public double deltaS = 0.0;
    public double rM = 0.0;
    public double lambdaM = 0.0;
    public double equationOfTime = 0.0;
    public double primeMeridian = 0.0;
    private static final double[] pbsA = new double[]{0.0, 0.0071, 0.0057, 0.0039, 0.0037, 0.0021, 0.002, 0.0018, 0.0};
    private static final double[] pbsTau = new double[]{1.0, 2.2353, 2.7543, 1.1177, 15.7866, 2.1354, 2.4694, 32.8493, 0.0};
    private static final double[] pbsPhi = new double[]{0.0, 49.409, 168.173, 191.837, 21.736, 15.704, 95.528, 49.095, 0.0};
    private static final double[] pbsTauIn = new double[]{0.985626, 0.44093678700845523, 0.3578499074174926, 0.8818341236467747, 0.06243434305043518, 0.46156504636133744, 0.3991358224669961, 0.030004474981202036};

    public TitanTime() {
        super(System.currentTimeMillis());
        this.init();
    }

    public TitanTime(long aTime) {
        super(aTime);
        this.init();
    }

    private void init() {
        this.meanAnomalyRad = Mathlib.toRadians(19.387 + 0.52402075 * this.delta2000);
        double sin1MeanAnom = Math.sin(this.meanAnomalyRad);
        double sin2MeanAnom = Math.sin(2.0 * this.meanAnomalyRad);
        double sin3MeanAnom = Math.sin(3.0 * this.meanAnomalyRad);
        double sin4MeanAnom = Math.sin(4.0 * this.meanAnomalyRad);
        double sin5MeanAnom = Math.sin(5.0 * this.meanAnomalyRad);
        this.alphaFMS = 270.3863 + 0.5240384 * this.delta2000;
        double pbs = 0.0;
        int k = 1;
        while (k < 8) {
            pbs += pbsA[k] * Math.cos((pbsTauIn[k] * this.delta2000 + pbsPhi[k]) * Constants.RAD_PER_DEG);
            ++k;
        }
        this.ellS = this.alphaFMS + (10.691 + 3.0E-7 * this.delta2000) * sin1MeanAnom + 0.623 * sin2MeanAnom + 0.05 * sin3MeanAnom + 0.005 * sin4MeanAnom + 5.0E-4 * sin5MeanAnom + pbs;
        while (this.ellS < 0.0) {
            this.ellS += 360.0;
        }
        while (this.ellS > 360.0) {
            this.ellS -= 360.0;
        }
        this.ellSRad = Mathlib.toRadians(this.ellS);
        this.deltaS = Mathlib.toDegrees(Math.asin(0.42565 * Math.sin(this.ellSRad))) + 0.25 * Math.sin(this.ellSRad);
        this.rM = 1.5236 * (1.00436 - 0.09309 * Math.cos(this.meanAnomalyRad) - 0.00436 * Math.cos(2.0 * this.meanAnomalyRad) - 3.1E-4 * Math.cos(3.0 * this.meanAnomalyRad));
        this.lambdaM = this.ellS + 85.061 - 0.015 * Math.sin(Mathlib.toRadians(2.0 * this.ellS + 71.0)) - 5.5E-6 * this.delta2000;
        while (this.lambdaM < 0.0) {
            this.lambdaM += 360.0;
        }
        while (this.lambdaM > 360.0) {
            this.lambdaM -= 360.0;
        }
        this.equationOfTime = 2.861 * Math.sin(2.0 * this.ellSRad) - 0.071 * Math.sin(4.0 * this.ellSRad) + 0.002 * Math.sin(6.0 * this.ellSRad) - ((10.691 + 3.0E-7 * this.delta2000) * sin1MeanAnom + 0.623 * sin2MeanAnom + 0.05 * sin3MeanAnom + 0.005 * sin4MeanAnom + 5.0E-4 * sin5MeanAnom + pbs);
        this.primeMeridian = 313.384 + 350.8919852 * this.delta2000;
        while (this.primeMeridian < 0.0) {
            this.primeMeridian += 360.0;
        }
        while (this.primeMeridian > 360.0) {
            this.primeMeridian -= 360.0;
        }
    }

    public double getSolarLongitude() {
        return this.ellS;
    }

    public String getSolarLongitudeString(long inPrecision) {
        return MathStrings.formatDouble(this.ellS, (int)inPrecision);
    }

    public double getSolarDeclination() {
        return this.deltaS;
    }

    public double getSubsolarLongitude() {
        double result = 15.0 * this.getTime(0.0, 2) - 180.0;
        while (result < 0.0) {
            result += 360.0;
        }
        while (result > 360.0) {
            result -= 360.0;
        }
        return result;
    }

    public double getHeliocentricLongitude() {
        return this.lambdaM;
    }

    public double getHeliocentricDistance() {
        return this.rM;
    }

    public double getTitanSolDate() {
        return (this.jdTT - 2400000.5 - 51549.0) / 1.027491252 + 44796.0 - 9.6E-4;
    }

    public double getTime(double longitude, int timeType) {
        double mst0 = 44795.99904 + (this.jdTT - 2451549.5) / 1.027491252;
        double mst = (mst0 - (double)((long)mst0)) * 24.0;
        double result = mst - longitude * 0.06666666666666667;
        if (timeType == 2) {
            result += this.equationOfTime / 15.0;
        }
        while (result < 0.0) {
            result += 24.0;
        }
        while (result > 24.0) {
            result -= 24.0;
        }
        return result;
    }

    public String getTimestr(double longitude, int timeType) {
        return this.getTimestr(longitude, timeType, true);
    }

    public String getTimestr(double longitude, int timeType, boolean appendType) {
        double localTime = this.getTime(longitude, timeType);
        long tHour = (long)localTime;
        long tMin = (long)((localTime - (double)tHour) * 60.0);
        long tSec = (long)(((localTime - (double)tHour) * 60.0 - (double)tMin) * 60.0);
        StringBuffer result = new StringBuffer(MathStrings.zeroPadInt(tHour, 2) + ":" + MathStrings.zeroPadInt(tMin, 2) + ":" + MathStrings.zeroPadInt(tSec, 2));
        if (appendType) {
            if (timeType == 2) {
                result.append(" LTST");
            } else {
                result.append(" LMST");
            }
        }
        return result.toString();
    }

    public double getZenithAngle(double longitude, double latitude) {
        double subsolarLat = this.getSolarDeclination();
        double subsolarLong = this.getSubsolarLongitude();
        double cosLatitudeS = Math.cos(Mathlib.toRadians(subsolarLat));
        double sinLatitudeS = Math.sin(Mathlib.toRadians(subsolarLat));
        double cosDTheta = Math.cos(Mathlib.toRadians(subsolarLong - longitude));
        double cosLatitudeX = Math.cos(Mathlib.toRadians(latitude));
        double sinLatitudeX = Math.sin(Mathlib.toRadians(latitude));
        return Mathlib.toDegrees(Math.acos(sinLatitudeS * sinLatitudeX + cosLatitudeS * cosLatitudeX * cosDTheta));
    }

    public double getAzimuthAngle(double longitude, double latitude) {
        double zenithAngle = this.getZenithAngle(longitude, latitude);
        if (zenithAngle > 0.0) {
            double subsolarLat = this.getSolarDeclination();
            double subsolarLong = this.getSubsolarLongitude();
            double cosLatitudeS = Math.cos(Mathlib.toRadians(subsolarLat));
            double sinLatitudeS = Math.sin(Mathlib.toRadians(subsolarLat));
            if (cosLatitudeS == 0.0) {
                return 0.0;
            }
            double hourAngle = longitude - subsolarLong;
            if (hourAngle > 180.0) {
                hourAngle -= 360.0;
            } else if (hourAngle < -180.0) {
                hourAngle += 360.0;
            }
            double cosLatitudeX = Math.cos(Mathlib.toRadians(latitude));
            double sinLatitudeX = Math.sin(Mathlib.toRadians(latitude));
            double cosDTheta = Math.cos(Mathlib.toRadians(hourAngle));
            double sinDTheta = Math.sin(Mathlib.toRadians(hourAngle));
            return Mathlib.toDegrees(Math.atan2(sinDTheta, cosLatitudeX * sinLatitudeS / cosLatitudeS - sinLatitudeX * cosDTheta));
        }
        return 0.0;
    }

    public String getSeason(boolean inNorth) {
        String theSeason;
        long theSeasonNo;
        if (inNorth) {
            if (this.ellS >= 0.0 && this.ellS <= 0.5 || this.ellS >= 359.5 && this.ellS <= 360.0) {
                return "NH Vernal Equinox";
            }
            if (this.ellS >= 89.5 && this.ellS <= 90.5) {
                return "NH Summer Solstice";
            }
            if (this.ellS >= 179.5 && this.ellS <= 180.5) {
                return "NH Autumnal Equinox";
            }
            if (this.ellS >= 269.0 && this.ellS <= 270.5) {
                return "NH Winter Solstice";
            }
            theSeasonNo = (long)(this.ellS / 90.0);
            theSeason = theSeasonNo == 0L ? "NH Spring" : (theSeasonNo == 1L ? "NH Summer" : (theSeasonNo == 2L ? "NH Autumn" : "NH Winter"));
        } else {
            if (this.ellS >= 0.0 && this.ellS <= 0.5 || this.ellS >= 359.5 && this.ellS <= 360.0) {
                return "SH Autumnal Equinox";
            }
            if (this.ellS >= 89.5 && this.ellS <= 90.5) {
                return "SH Winter Solstice";
            }
            if (this.ellS >= 179.5 && this.ellS <= 180.5) {
                return "SH Vernal Equinox";
            }
            if (this.ellS >= 269.0 && this.ellS <= 270.5) {
                return "SH Summer Solstice";
            }
            theSeasonNo = (long)(this.ellS / 90.0);
            theSeason = theSeasonNo == 0L ? "SH Autumn" : (theSeasonNo == 1L ? "SH Winter" : (theSeasonNo == 2L ? "SH Spring" : "SH Summer"));
        }
        double theSection = this.ellS % 90.0;
        if (theSection < 30.0) {
            return "Early " + theSeason;
        }
        if (theSection < 60.0) {
            return "Mid " + theSeason;
        }
        return "Late " + theSeason;
    }
}

