/*
 * Decompiled with CFR 0.152.
 */
package bin;

import bin.Configurations;
import bin.Credits;
import bin.Display;
import bin.FontChooser;
import bin.Language;
import bin.LanguageGallery;
import bin.ReadFiles;
import bin.ReadingDuration;
import bin.ThemeGallery;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Scanner;
import javax.imageio.ImageIO;
import javax.swing.JColorChooser;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class Menu {
    private BufferedImage menuImage;
    private BufferedImage hoverMenuImage;
    private boolean hMI = false;
    private JTextField gotoPageField = new JTextField(6);
    private BufferedImage menuMapImage;
    private BufferedImage mMI;
    private BufferedImage hMMI;
    private int menuHover = 0;
    private Configurations cf;
    private Display d;

    public Menu(Display dis, Configurations conf) {
        this.d = dis;
        this.cf = conf;
        this.d.setLayout(null);
        this.gotoPageField.setLocation(141, 14);
        this.gotoPageField.setSize(74, 25);
        this.gotoPageField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.gotoPageField.setBackground(Color.WHITE);
        this.gotoPageField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                Menu.this.d.pressKey(ke);
                ke.consume();
            }
        });
        this.d.add(this.gotoPageField);
        try {
            Language.loadResources();
            this.mMI = ImageIO.read(new File("images/gui/menumap.bmp"));
            this.hMMI = ImageIO.read(new File("images/gui/hovermenumap.bmp"));
        }
        catch (Exception ex) {
            System.out.println(String.valueOf(Language.getText(0)) + ex);
            System.exit(0);
        }
        this.menuImage = Language.getMenu();
        this.hoverMenuImage = Language.getHoverMenu();
        this.menuMapImage = this.mMI;
    }

    public void mouseReleased(MouseEvent e) {
        switch (this.colorMapIndicator(e)) {
            case 1: {
                this.d.dispose();
                this.cf.setBookPath("");
                this.cf.setPageNum(0);
                this.cf.saveConfigurations();
                new Display();
                break;
            }
            case 2: {
                this.hMI = !this.hMI;
                this.menuMapImage = this.hMI ? this.hMMI : this.mMI;
                this.gotoPageField.setEnabled(!this.hMI);
                this.d.repaint();
                break;
            }
            case 3: {
                try {
                    Scanner scan = new Scanner(this.gotoPageField.getText());
                    this.d.toPage(scan.nextInt() - 1);
                }
                catch (Exception eex) {
                    this.gotoPageField.setText("");
                }
                break;
            }
            case 4: {
                this.d.updateConfig();
                try {
                    ReadFiles a = new ReadFiles();
                    this.cf.setBookPath(a.getPath());
                    this.cf.setPageNum(0);
                    this.d.updateConfig();
                    this.d.dispose();
                    new Display();
                }
                catch (Exception ex) {}
                break;
            }
            case 5: {
                new LanguageGallery(this.d);
                break;
            }
            case 6: {
                System.exit(0);
                break;
            }
            case 7: {
                this.d.firstPage();
                break;
            }
            case 8: {
                this.d.prevPage();
                break;
            }
            case 9: {
                new Credits();
                break;
            }
            case 10: {
                this.d.nextPage();
                break;
            }
            case 11: {
                this.d.lastPage();
                break;
            }
            case 12: {
                if (FontChooser.isAlreadyOpen()) break;
                FontChooser chooseFont = new FontChooser(this.d, this.d.getFont().getName());
                chooseFont.setLocationRelativeTo(null);
                chooseFont.setVisible(true);
                break;
            }
            case 13: {
                Color newFontColor = JColorChooser.showDialog(null, Language.getText(2), this.cf.getFontColor());
                if (newFontColor == null) break;
                this.cf.setFontColor(newFontColor);
                this.d.repaint();
                this.d.updateConfig();
                break;
            }
            case 14: {
                this.cf.setUseBGImage(!this.cf.isUseBGImage());
                this.d.repaint();
                this.d.updateConfig();
                break;
            }
            case 15: {
                this.d.changeBGImage();
                break;
            }
            case 16: {
                Color newBackColor = JColorChooser.showDialog(null, Language.getText(3), this.cf.getBackColor());
                if (newBackColor == null) break;
                this.cf.setBackColor(newBackColor);
                this.d.repaint();
                this.d.updateConfig();
                break;
            }
            case 17: {
                new ThemeGallery(this.d, this.cf);
                break;
            }
            case 18: {
                ReadingDuration.showTime();
            }
        }
        e.consume();
    }

    public void mouseMoved(MouseEvent e) {
        int newerMenuHover = this.colorMapIndicator(e);
        if (newerMenuHover != this.menuHover) {
            this.menuHover = newerMenuHover;
            if (newerMenuHover == 0) {
                this.d.setCursor(0);
            } else {
                this.d.setCursor(12);
            }
        }
        e.consume();
    }

    private int colorMapIndicator(MouseEvent e) {
        int posX = e.getX();
        if (posX >= 0 && posX < 500) {
            return this.menuMapImage.getRGB(posX, e.getY()) & 0xFFFFFF;
        }
        return 0;
    }

    public void render(Graphics2D g2d) {
        g2d.drawImage(this.menuImage, null, 0, 0);
        if (this.hMI) {
            g2d.drawImage(this.hoverMenuImage, null, 0, 0);
        } else {
            this.gotoPageField.repaint();
        }
    }

    public boolean isIdle(MouseEvent pressed) {
        return this.colorMapIndicator(pressed) == 0;
    }
}

