/**
 * @(#)Language.java
 * The class which provides the appropiate
 * resources for the current language.
 *
 * @author Mehmet Mithat Cinar
 * @version 1.00 21.12.2009
 */
 
package bin;
 
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import java.io.*;

public class Language {
	
	/**
     * <code>currentLang</code><br>
     * The current language index.
     */
    private static int currentLang=0;
	
	/**
     * <code>languages</code><br>
     * List of available languages.
     */
    private static final String[] languages = {
		"English",	// ENGLISH
		"Trke"	// TURKISH
	};

    /**
     * <code>translators</code><br>
     * List of the translators.
     */
    private static final String[] translators = {
		"Nerd4Ever",	// ENGLISH
		"Nerd4Ever"		// TURKISH
	};
	
	/**
     * <code>menu</code><br>
     * The image used for the menu. Language-specific.
     */
    private static BufferedImage menu;
    
    /**
     * <code>hoverMenu</code><br>
     * The image used for the hoverMenu. Language-specific.
     */
    private static BufferedImage hoverMenu;
	
	/**
     * <code>loadResources</code><br>
     * Loads the language-based image resources.
     * @throws An exception if the images are not found.
     */
    public static void loadResources() throws Exception {
    	// Load the menu image
    	menu = ImageIO.read(new File("images/gui/lang/"+currentLang+"/menu.png"));
    	// Load the hoverMenu image
    	hoverMenu = ImageIO.read(new File("images/gui/lang/"+currentLang+"/hovermenu.png"));
	}
	
	/**
     * <code>help</code><br>
     * An array which stores the user's 
     * manual in different languages.
     */
    private static final String[] help = {
    	// ENGLISH
			"	Welcome to jLibris eBook Reader! \n" +
			"\n" +
			"	To start the unique experience of reading " +
			"with jLibris, click on the \"Open File\" " +
			"button in the toolbar. \n" +
			"\n" +
			"	About the Toolbar\n" +
			"\n" +
			"	jLibris has an easy-to-use toolbar which gives " +
			"you full control over the appearance of your " +
			"program. You can personalize your reader or easily " +
			"navigate through pages via the toolbar. Alternatively, " +
			"you can use UP or LEFT ARROW buttons in your keyboard " +
			"instead of \"Prev. Page\" button, and RIGHT or DOWN ARROWS " +
			"instead of \"Next Page\" button.\n" +
			"\n" +
			"	Style Menu\n\n" +
			"	jLibris has an extra menu which is controlling the appearance " +
			"of the reader. By clicking on the \"Style Menu\", you can enable " + 
			"this menu.\n" + 
			"	In this menu, by pressing \"Choose " +
			"Image\" button in the toolbar, you can either select one of the " +
			"images provided or load your own image. Using \"Toggle BG Img\" " +
			"button, you can easily cycle between background image and a solid " +
			"background color. To choose a solid background color, you can click " +
			"on the \"Back Color\" button. \n" + 
			"\n" +
			"	To determine text's foreground color, click on the \"Font Color\" button.\n" +
			"\n" +
			"	\"Font Face\" opens a special font face chooser which allows you to choose " +
			"a desired font face, font size and to decide whether the text should be italic, " +
			"bold, either of them, or plain. \n" +
			"\n" +
			"	The little clock on the top of the Style Menu shows you how long you have been reading. " +
			"\n\n" + 
			"	And finally, the \"Apply Preset Theme\" button provides predefined stylistic " +
			"appearances.\n\n" +
			"	Now let's advance to the main menu's buttons:\n" +
			"\n" +
			"	Now try to input a number inside the upper white arrow and "+
			"press \"GO\". This will directly open that page.\n"+
			"\n	Pressing one of the \"First Page\" or \"Last Page\" buttons will send you to " + 
			"the first or the last page of the book. \n"+
			"\n	Very surprisingly, X closes the program.\n" +
			"\n" +
			"	If you wonder who we are, you can see \"Credits\" with a single click "+
			"on the jLibris logo in the middle of the navigation toolbar. \n" +
			"\n" +
			"	\"U Not Engrish?\" Don't worry, by clicking the \"EN\" sign above, you can choose " +
			"one of the supported languages. (We still don't know how you can read this if you don't"+
			" know English)\n" +
			"	By the way, by pressing R , you can toggle \"Eye Relaxing Mode\", which " +
			"continuously darkens and lightens the screen slowly so that your eyes don't " +
			"have to bear the same amount of light all the time. Give it a try.\n" +
			"\n" +
			"	Well... May the force be with you,\n" +
			"\n" +
			"Lorem ipsum dolor sit amet..." +
			"\n\n				Nerd4Ever Team",
		// TURKISH
			"	jLibris e-Kitap Okuyucu'ya hogeldiniz! \n" +
			"\n" +
			"	jLibris kullanarak kitap okumann doyumsuz zevkine varmak iin, ara ubuundaki \"Dosya A\" dmesine tklayn. \n"+
			"\n" +
			"	Ara ubuu Hakknda\n" +
			"\n" +
			"	jLibris, kullancya programn grnm zerinde snrsz kontrol imkan tanyan kullanm kolay bir ara ubuuna sahiptir. "+
			"Ara ubuu sayesinde okuyucunuzu kolayca kiiselletirebilir veya sayfalar arasnda gezinebilirsiniz. " +
			"Ayrca \"nceki Sayfa\" dmesi yerine klavyenizden YUKARI veya SOL YN TUUna, \"Sonraki Sayfa\" yerine de AAI veya SA YN TUUna basabilirsiniz.\n" +
			"\n" +
			"	Stil Mens\n\n" +
			"	jLibris'in, okuyucunun grnmn kontrol eden fazladan bir mens vardr."+
			" \"Stil Mens\"ne tklayarak bu meny etkinletirebilirsiniz. \n" +
			"	Bu mende, \"Arkaplan Resmi Se\" dmesine tklayarak hazr bulunan resimlerden birini seebilir veya kendi resminizi ykleyebilirsiniz. " +
			" \"A.P. Resmini A/Kapa\" dmesini kullanarak arkaplan resmiyle dz bir renk arasnda kolayca gei yapabilirsiniz. " +
			" Dz bir arkaplan rengi semek iin \"Arkaplan Rengi\" dmesine tklayabilirsiniz. \n" +
			"\n" +
			"	Yaz rengini ayarlamak iin \"Yaztipi Rengi Se\" dmesine tklayn.\n" +
			"\n" +
			"	\"Yaz Tipi Se\" dmesi; istediiniz yaz tipini, boyutunu ve stilini semenize imkan tanyan zel bir yaz tipi seme ekran aar. \n" +
			"\n" +
			"	Stil Mens'nn st tarafndaki kk saat, size ne kadar sredir okumakta olduunuzu gsterir. " +
			"\n\n" + 
			"	Son olarak, \"Hazr Tema Uygula\" dmesi size nceden tanmlanm grnmler sunar.\n\n" +
			"	imdi ana mennn dmelerine bakalm:\n" +
			"\n" +
			"	Yukardaki beyaz okun ierisine bir say girip \"Git\"e basn. Bu, dorudan o sayfay aacaktr.\n" +
			"\n \"lk Sayfa\" ve \"Son Sayfa\" dmelerinden birine tklamak sizi kitabn ilk ya da son sayfasna gnderir. \n" +
			"\n	artc ama, X program kapatr.\n" +
			"\n" +
			"	Kim olduumuzu merak ediyorsanz, gezinti ara ubuunun ortasndaki jLibris dmesine tklayarak \"Katkda Bulunanlar\" grebilirsiniz. \n" +
			"\n" +
			"	Trke bilmiyor musunuz? Merak etmeyin, yukardaki \"TR\" simgesine tklayarak, desteklenen dillerden birini seebilirsiniz. "+
			"(Trkeniz yoksa bunu nasl okuyabileceinizi ise bilmiyoruz.)\n" +
			"	Bu arada, R'ye basarak, ekran srekli yavaa aydnlatp karartan ve gznzn yorulmasn engelleyen \"Gz Rahatlatma Modu\"na girebilirsiniz. Bir deneyin. \n" +
			"\n" +
			"	Bu kadar... G sizinle olsun,\n" +
			"\n" +
			"Lorem ipsum dolor sit amet..." +
			"\n\n				Nerd4Ever Takm",
	};
		
	/**
     * <code>textres</code><br>
     * An array list which stores the text 
     * resources in different languages.
     */
    private static final String[][] textres = new String[][] {
/* 0*/  {"ERROR: ","HATA: "},
/* 1*/  {"Supported Image Files","Desteklenen Resim Dosyalar"},
/* 2*/  {"Choose Font Color...","Yaztipi Rengini Sein..."},
/* 3*/  {"Choose Background Color...","Arkaplan Rengini Sein..."},
/* 4*/  {"jLibris eBook Reader","jLibris e-Kitap Okuyucu"},
/* 5*/  {"Choose a theme...","Bir tema sein..."},
/* 6*/  {"Choose a language...","Bir dil sein..."},
/* 7*/  {"Font face: ","Yaz tipi: "},
/* 8*/  {"Style:","Biem:"},
/* 9*/  {"Plain","Normal"},
/*10*/  {"Bold","Kaln"},
/*11*/  {"Italic","talik"},
/*12*/  {"Bold Italic","Kaln talik"},
/*13*/  {"Size:","Boyut:"},
/*14*/  {"Apply","Uygula"},
/*15*/  {"TXT Files","TXT Dosyalar"},
/*16*/  {"Credits","Katkda Bulunanlar"},
/*17*/  {"Programmer","Programc"},
/*18*/  {"Instructor","Eitmen"},
/*19*/  {"Lab Assistant","Lab Asistan"},
/*20*/  {"Team Leader","Takm Lideri"},
/*21*/  {"Beta Tester","Deneti"},
/*22*/  {"Artwork","Grsel Tasarm"},
/*23*/  {"THE END","SON"},
/*24*/  {"Reading Duration","Okuma Sresi"},
/*25*/  {"hour(s)","saat"},
/*26*/  {"minute(s)","dakika"},
/*27*/	{"Code Commentary","Kod Aklamalar"},
/*28*/	{"<RESOURCE NOT FOUND>","<KAYNAK BULUNAMADI>"},
/*29*/	{"<LANGUAGE NOT FOUND>","<DL BULUNAMADI>"},
/*30*/	{"Help","Yardm"},
/*31*/	{"Translators","evirenler"}
    };
	
	/**
     * <code>getHelp</code><br>
     * Returns a String object in the current language.
     * @return Help in the current language.
     */
    public static String getHelp() {
		return help[currentLang];
	}
	
	/**
     * <code>getText</code><br>
     * Returns the nth String resource object in the current language.
     * @param i The index number of the text resource.
     * @return Text in the current language.
     */
    public static String getText(int i) {
    	// If the index is out of bounds
    	if (i<0 || i>=textres.length)
    		// Set the i integer to which belongs to "<RESOURCE NOT FOUND>"
    		i = 28;
    	// Return the text resource in the given language
		return textres[i][currentLang];
	}
	
	/**
     * <code>getLanguageName</code><br>
     * Returns the name of the current language.
     * @return The name of the current language.
     */
    public static String getLanguageName() {
    	// Return the language name
		return getLanguageName(currentLang);
	}
	
	/**
     * <code>getLanguageName</code><br>
     * Returns the name of the current language.
     * @param i The index of the language
     * @return The name of the current language.
     */
    public static String getLanguageName(int i) {
    	// If the language is not there
    	if (i<0 || i>=languages.length)
    		// Return "<LANGUAGE NOT FOUND>" in the current language
    		return getText(29);
    	// Return the name of the language
		return languages[i];
	}
	/**
     * <code>getTranslatorName</code><br>
     * Returns the name of the language's translator.
     * @param i The index of the translator's name
     * @return The name of the language's translator.
     */
    public static String getTranslatorName(int i) {
    	// If the language is not there
    	if (i<0 || i>=translators.length)
    		// Return "Nerd4Ever"
    		return "Nerd4Ever";
    	// Return the name of the language
		return translators[i];
	}
		
	/**
     * <code>getLanguageIndex</code><br>
     * Returns the current language index.
     * @return The current language index.
     */
    public static int getLanguageIndex() {
    	// Return the current language's index
		return currentLang;
	}
		
	/**
     * <code>chooseLanguage</code><br>
     * Chooses the language in the determined index.
     * @param i The index of the desired language.
     */
    public static void chooseLanguage(int i) {
    	// Limit i in the array boundary and return the result
		currentLang = (i>=0)?((i<languages.length)?i:0):(languages.length-1);
	}
	
	/**
     * <code>languageCount</code><br>
     * Returns the count of the languages.
     * @return The count of the languages as an int.
     */
    public static int languageCount() {
    	// Return how many languages are there
		return languages.length;
	}
	
	/**
     * <code>getMenu</code><br>
     * Returns the BufferedImage <code>menu</code>.
     * @return The menu image.
     */
	public static BufferedImage getMenu() {
		// Return the menu image
		return menu;
	}
	
	/**
     * <code>getHoverMenu</code><br>
     * Returns the BufferedImage <code>hoverMenu</code>.
     * @return The hoverMenu image.
     */
	public static BufferedImage getHoverMenu() {
		// Return the hoverMenu image
		return hoverMenu;
	}
}