/*
 * Decompiled with CFR 0.152.
 */
package de.beagtex.gui;

import de.beagtex.control.RedoAction;
import de.beagtex.control.UndoAction;
import de.beagtex.gui.BFrame;
import de.beagtex.gui.MyOpenChooser;
import de.beagtex.gui.MySaveChooser;
import de.beagtex.gui.SearchWindow;
import de.beagtex.listener.control.MyKeyListener;
import de.beagtex.listener.control.MyMouseListener;
import de.beagtex.listener.control.MyUndoableEditListener;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.undo.UndoManager;

public class Editor
extends JTextArea {
    private static final long serialVersionUID = 1L;
    protected UndoManager undoMan = new UndoManager();
    public UndoAction undoAction = new UndoAction(this);
    public RedoAction redoAction = new RedoAction(this);
    private BFrame bFrame;
    private File savefile;
    private boolean saved = false;
    private static int number = 1;

    public Editor(BFrame pBFrame) {
        this.bFrame = pBFrame;
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.addKeyListener(new MyKeyListener(this));
        Font t = new Font("eigen", 0, 16);
        this.setFont(t);
        this.addMouseListener(new MyMouseListener(this));
        this.getDocument().addUndoableEditListener(new MyUndoableEditListener(this));
    }

    public void open() {
        block6: {
            try {
                MyOpenChooser oc = new MyOpenChooser(this);
                oc.setVisible(true);
                if (oc.getSelectedFile() != null) {
                    String choice = oc.getSelectedFile().getName();
                    this.getBFrame().setTitle("BeaGTex - " + choice);
                    FileReader fily = new FileReader(oc.getSelectedFile());
                    BufferedReader buffyRead = new BufferedReader(fily);
                    this.savefile = oc.getSelectedFile();
                    boolean eof = false;
                    while (!eof) {
                        String line = buffyRead.readLine();
                        if (line == null) {
                            eof = true;
                            line = "";
                            continue;
                        }
                        this.getDocument();
                        this.append(String.valueOf(line) + "\r\n");
                    }
                    break block6;
                }
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void save() {
        try {
            if (this.savefile != null) {
                this.getBFrame().setTitle("BeaGTex - " + this.savefile);
                StringBuffer buffy = new StringBuffer();
                String text = this.getText();
                buffy.append(text);
                FileWriter fily = new FileWriter(this.savefile);
                fily.write(buffy.toString());
                fily.close();
                this.getBFrame().getBlButtons().getSaveB().setEnabled(false);
                this.setSaved(true);
                System.out.println("BeaGTex has saved your file to " + this.savefile);
                this.requestFocus();
                if (Editor.getNumber() == 0) {
                    System.out.println("number: " + Editor.getNumber());
                    System.exit(0);
                }
            } else {
                this.saveAs();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveAs() {
        try {
            MySaveChooser sc = new MySaveChooser(this);
            sc.setVisible(true);
            if (sc.getSelectedFile() != null) {
                String filename = sc.getSelectedFile().getName();
                this.getBFrame().setTitle("BeaGTex - " + filename);
                StringBuffer buffy = new StringBuffer();
                String text = this.getText();
                buffy.append(text);
                FileWriter fily = new FileWriter(sc.getSelectedFile());
                fily.write(buffy.toString());
                fily.close();
                this.getBFrame().getBlButtons().getSaveB().setEnabled(false);
                this.setSaved(true);
                this.savefile = sc.getSelectedFile();
                System.out.println("BeaGTex has saved your file to " + filename);
                this.requestFocus();
                if (Editor.getNumber() == 0) {
                    System.out.println("number: " + Editor.getNumber());
                    System.exit(0);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean search(SearchWindow searchWindow) {
        boolean found = false;
        StringBuffer buffy = new StringBuffer(this.getText());
        int end = buffy.toString().length();
        int actual = this.getCaretPosition();
        StringBuffer searchBuffy = new StringBuffer(buffy.substring(actual, end));
        StringTokenizer toky = new StringTokenizer(searchBuffy.toString(), " \t\n\r\f ! ? . , - ' ; : / { } \\ ");
        while (toky.hasMoreTokens()) {
            String searchString;
            String test = toky.nextToken();
            if (!test.equalsIgnoreCase(searchString = searchWindow.searchTF.getText())) continue;
            int mStart = searchBuffy.toString().indexOf(searchString) + actual;
            int mEnd = searchBuffy.toString().indexOf(searchString) + searchString.length() + actual;
            this.select(mStart, mEnd);
            found = true;
        }
        return found;
    }

    public void replace(SearchWindow searchWindow) {
        String alternativeString = searchWindow.replaceTF.getText();
        if (this.getSelectedText() != null) {
            this.replaceSelection(alternativeString);
        } else {
            JOptionPane.showMessageDialog(null, BFrame.get_prop().getProperty("beagtex.editor.replace"), BFrame.get_prop().getProperty("beagtex.editor.replacetitle"), 1);
        }
    }

    public static void incrementNumber() {
        System.out.println(++number);
    }

    public static void decrementNumber() {
        System.err.println(--number);
    }

    protected void resetUndoManager() {
        this.undoMan.discardAllEdits();
        this.undoAction.update();
        this.redoAction.update();
    }

    public UndoManager getUndoMan() {
        return this.undoMan;
    }

    public BFrame getBFrame() {
        return this.bFrame;
    }

    public File getSaveFile() {
        return this.savefile;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean pSaved) {
        this.saved = pSaved;
    }

    public static int getNumber() {
        return number;
    }

    public static void setNumber(int pNumber) {
        number = pNumber;
    }
}

