package de.beagtex.control;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

/**
 * Standard-methods for working with files
 * 
 * @author Benjamin Haag
 */
public class FileWorkMethods {

	/** Lineseperator */
	private final static String LS = System.getProperty("line.separator");

	/**
	 * Constructor
	 */
	public FileWorkMethods() {
		super();
	}

	/**
	 * Writes a StringBuffer into the File. Existing files will be overwritten
	 * 
	 * @param pBuffy :
	 *            StringBuffer
	 * @param pFilename :
	 *            File
	 * @throws IOException
	 */
	public static void writeFile(StringBuffer pBuffy, String pFilename)
			throws IOException {

		FileWriter out = new FileWriter(pFilename);
		out.write(pBuffy.toString());
		out.close();
	}

	/**
	 * Writes a List into the file. Existing files will be overwritten
	 * 
	 * @param pList :
	 *            List
	 * @param pFilename :
	 *            File
	 * @throws IOException
	 */
	public static void writeFile(ArrayList pList, String pFilename)
			throws IOException {

		StringBuffer buffyOut = new StringBuffer();
		Iterator iter = pList.iterator();
		while (iter.hasNext()) {
			String ciar = (String) iter.next();
			buffyOut.append(ciar + LS);
		}
		writeFile(buffyOut, pFilename);
	}

	/**
	 * Creates a Stringbuffer from File-content
	 * 
	 * @param pFilename :
	 *            File
	 * @return StringBuffer
	 * @throws IOException
	 */
	public static StringBuffer createStringBufferFromFile(String pFilename)
			throws IOException {

		StringBuffer buffy = new StringBuffer();
		BufferedReader buffyIn = new BufferedReader(new FileReader(pFilename));
		String line = "";
		while ((line = buffyIn.readLine()) != null) {
			buffy.append(line + LS);
		}
		buffyIn.close();
		return buffy;
	}

	/**
	 * Creates a List with the Lines of the File
	 * 
	 * @param pFilename :
	 *            File
	 * @return List
	 * @throws IOException
	 */
	public static ArrayList createListFromFile(String pFilename)
			throws IOException {

		ArrayList ali = new ArrayList();
		BufferedReader buffyIn = new BufferedReader(new FileReader(pFilename));
		String line = "";
		while ((line = buffyIn.readLine()) != null) {
			ali.add(line);
		}
		buffyIn.close();
		return ali;
	}

	/**
	 * Reads properties-files
	 * 
	 * @param pPropFileName :
	 *            Name of Properties-File
	 * @return p: the loaded Properties
	 * @throws IOException
	 */
	public static Properties readProperties(String pPropFileName)
			throws IOException {
		InputStream fis = new FileInputStream(pPropFileName);
		Properties p = new Properties();
		p.load(fis);
		fis.close();
		return p;
	}

}
