package de.beagtex.control;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;

/**
 * Picture shown during programm-start
 * 
 * @author Benjamin Haag
 */
public class Splash extends Window {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;
	Image image;
	Image back = null;

	/**
	 * Constructor
	 * 
	 * @param splash:
	 *            das wanted Splash-Object
	 */
	Splash(String splash) {
		super(new Frame()); // ntig, weil Window abgeleitet sein muss
		image = Toolkit.getDefaultToolkit().getImage(splash);
	}

	/**
	 * Method that paints the pic
	 */
	public void paint(Graphics g) {

		if (back != null)
			g.drawImage(back, 0, 0, this);
		g.drawImage(image, 0, 0, this);
	}

	/**
	 * Places the ic in the middle of the screen
	 */
	public void show() {
		int w = image.getWidth(this), h = image.getHeight(this);
		if (w != -1 && h != -1) {
			Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
			setBounds((d.width - w) / 2, (d.height - h) / 3, w, h);

			// This doesn't work with linux. WHY???
			// try {
			// back = new Robot().createScreenCapture(getBounds());
			// } catch (AWTException e) {
			// System.err.println(e);
		}
		super.show();
		// }
	}

	/**
	 * Update-method
	 */
	public boolean imageUpdate(Image img, int infoflags, int x, int y, int w,
			int h) {
		if ((infoflags & WIDTH + HEIGHT) != 0) {
			show();
		}
		return super.imageUpdate(img, infoflags, x, y, w, h);
	}
}
