package de.beagtex.gui;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

import de.beagtex.listener.control.OpenListener;
import de.beagtex.listener.control.StartNewListener;
import de.beagtex.listener.gui.MyWindowListener;

/**
 * Startscreen; offers a choice of actions: Open existing File, create new File
 * (Standard-, Input-, Format-);
 * 
 * @author Benjamin Haag
 */
public class StartChoiceWindow extends BWindow {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;

	BFrame bFrame;
	JPanel choice;
	JButton newB;
	public JButton open;
	JLabel hello;
	JLabel advertisement;
	public JComboBox newChoice;
	JLabel new1;

	/**
	 * Constructor
	 * 
	 * @param pBFrame :
	 *            the calling BFrame
	 */
	public StartChoiceWindow(BFrame pBFrame) {

		this.bFrame = pBFrame;
		paint();
	}

	/**
	 * Paints the window
	 * 
	 */
	public void paint() {

		setTitle(BFrame.get_prop().getProperty("beagtex.startchoice.title"));
		setSize(400, 150);
		// setLocation(200, 200);
		setResizable(false);
		this.addWindowListener(new MyWindowListener(bFrame));
		choice = new JPanel();
		hello = new JLabel(BFrame.get_prop().getProperty(
				"beagtex.startchoice.hello"));
		advertisement = new JLabel(BFrame.get_prop().getProperty(
				"beagtex.startchoice.advertisement"));
		open = new JButton(BFrame.get_prop().getProperty(
				"beagtex.startchoice.existingbutton"));
		open.addActionListener(new OpenListener(bFrame.getEdit(), this));
		String[] toChoose = {
				BFrame.get_prop()
						.getProperty("beagtex.startchoice.texstandard"),
				BFrame.get_prop().getProperty("beagtex.startchoice.texinput"),
				BFrame.get_prop().getProperty("beagtex.startchoice.texformat"),
				BFrame.get_prop().getProperty(
						"beagtex.startchoice.texformatgui") };
		newChoice = new JComboBox(toChoose);
		newChoice.addActionListener(new StartNewListener(bFrame, this));
		new1 = new JLabel(BFrame.get_prop().getProperty(
				"beagtex.startchoice.newlabel")
				+ " ");
		choice.add(hello);
		choice.add(open);
		JPanel neuWahl = new JPanel();
		neuWahl.add(new1);
		neuWahl.add(newChoice);
		choice.add(neuWahl);
		choice.add(advertisement);
		setContentPane(choice);
	}
}