package de.beagtex.listener.control;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import de.beagtex.gui.Editor;

/**
 * Listener for self-defined Key-Options
 * 
 * @author Benjamin Haag
 */
public class MyKeyListener implements KeyListener {

	Editor editor;

	/**
	 * Construktor
	 * 
	 * @param pEditor:
	 *            dthe calling editor-object
	 */
	public MyKeyListener(Editor pEditor) {
		this.editor = pEditor;
	}


	public void keyTyped(KeyEvent ke) {

	}

	public void keyPressed(KeyEvent ke) {

		// if (isTab)
		// ed = tab.getEdit();
		// else
		// ed = editor.getEdit();

		int key = ke.getKeyCode();
		String anfLinks = "\\glqq ";
		String anfRechts = "\\grqq\\ ";

		if (ke.isAltDown()) {
			if (key == KeyEvent.VK_Q)
				editor.insert(anfLinks, editor.getCaretPosition());
			if (key == KeyEvent.VK_W)
				editor.insert(anfRechts, editor.getCaretPosition());
			if (key == KeyEvent.VK_T)
				editor.insert("\\TeX\\", editor.getCaretPosition());
			if (key == KeyEvent.VK_L)
				editor.insert("\\LaTeX\\", editor.getCaretPosition());
			if (key == KeyEvent.VK_B)
				editor.insert("BeaG\\TeX\\", editor.getCaretPosition());
		}
		if (ke.isControlDown()) {
			if (key == KeyEvent.VK_ENTER)
				editor.insert("\\\\" + "\r\n", editor.getCaretPosition());
		}
	}

	public void keyReleased(KeyEvent ke) {

	}

}
