package de.beagtex.listener.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.beagtex.gui.BFrame;
import de.beagtex.gui.Editor;
import de.beagtex.gui.FormatFileWindow;
import de.beagtex.gui.StartChoiceWindow;

/**
 * Listener for StartChoiceWindow; opens or fills a file or calls
 * FormatFileWindow
 * 
 * NEW WINDOW!!!
 * 
 * @author Benjamin Haag
 */
public class StartNewListener implements ActionListener {

	Editor editor;
	BFrame bFrame;
	StartChoiceWindow startChoice;
	FormatFileWindow fenster;

	/**
	 * Constructor
	 * 
	 * @param pBFrame:
	 *            the calling BFrame
	 * @param pstartChoice:
	 *            the calling StartChoiceWindow
	 */
	public StartNewListener(BFrame pBFrame, StartChoiceWindow pStartChoice) {
		this.bFrame = pBFrame;
		this.startChoice = pStartChoice;
		editor = pBFrame.getEdit();
		pBFrame.setLocation(150, 150);
	}

	public void actionPerformed(ActionEvent arg0) {

		if (startChoice.newChoice.getSelectedIndex() == 0) { // Standard-Tex
			editor.append(BFrame.get_prop().getProperty("beagtex.startnew.standard"));
			startChoice.setVisible(false);
			bFrame.setVisible(true);
		}

		if (startChoice.newChoice.getSelectedIndex() == 1) { // Input-Tex
			editor.append("");
			startChoice.setVisible(false);
			bFrame.setVisible(true);
		}

		if (startChoice.newChoice.getSelectedIndex() == 2) { // Format-Tex
			editor
					.append(BFrame.get_prop().getProperty("beagtex.startnew.format"));
			startChoice.setVisible(false);
			bFrame.setVisible(true);
		}

		if (startChoice.newChoice.getSelectedIndex() == 3) {
			// Format grafical
			fenster = new FormatFileWindow(bFrame);
			bFrame.setVisible(true);
			startChoice.setVisible(false);
			fenster.show(450, 400);
		}
	}
	
	public void actionPerformed(ActionEvent arg0, boolean isGerman) {

		if (startChoice.newChoice.getSelectedIndex() == 0) { // Standard-Tex
			editor.append("\\input{FORMATDATEI}" + "\r\n" + "\\begin{document}"
					+ "\r\n" + "\r\n" + "\\end{document}");
			startChoice.setVisible(false);
			bFrame.setVisible(true);
		}

		if (startChoice.newChoice.getSelectedIndex() == 1) { // Input-Tex
			editor.append("");
			startChoice.setVisible(false);
			bFrame.setVisible(true);
		}

		if (startChoice.newChoice.getSelectedIndex() == 2) { // Format-Tex
			editor
					.append("%BEISPIEL EINER FUNKTIONIERENDEN FORMAT-DATEI"
							+ "\r\n"
							+ "\\documentclass[a4paper, 12pt]{scrreprt} % oder srcarticle, srcbook..."
							+ "\r\n"
							+ "\\usepackage[T1]{fontenc}"
							+ "\r\n"
							+ "\\usepackage[latin1]{inputenc}"
							+ "\r\n"
							+ "\\usepackage{ngerman}"
							+ "\r\n"
							+ "\\usepackage{pifont}"
							+ "\r\n"
							+ "\\usepackage{amsmath}"
							+ "\r\n"
							+ "\\usepackage[right]{eurosym}"
							+ "\r\n"
							+ "\\usepackage{scrpage2}"
							+ "\r\n"
							+ "\\usepackage{graphicx}"
							+ "\r\n"
							+ "\\usepackage{color}"
							+ "\r\n"
							+ "\\usepackage{makeidx}"
							+ "\r\n"
							+ "\\makeindex"
							+ "\r\n"
							+ "\\pagestyle{scrheadings}"
							+ "\r\n"
							+ "%\\chead{- \\pagemark\\ -} %Kopfzeile Mitte Seitenzahl"
							+ "\r\n"
							+ "\\setlength{\\parindent}{1em} %Einrckung erste Zeile Absatz"
							+ "\r\n"
							+ "\\setlength{\\parskip}{2.0ex plus 1.0ex minus 0.5ex} %Abstand zwischen Abstzen"
							+ "\r\n"
							+ "\\setlength{\\topmargin}{0mm} %von oben"
							+ "\r\n"
							+ "%\\setlength{\\oddsidemargin}{1,5mm} %von links"
							+ "\r\n"
							+ "%\\setlength{\\textwidth}{173mm} %blockbreite"
							+ "\r\n"
							+ "%\\setlength{\\textheight}{245mm} %blockhhe");
			startChoice.setVisible(false);
			bFrame.setVisible(true);
		}

		if (startChoice.newChoice.getSelectedIndex() == 3) {
			// Format grafical
			fenster = new FormatFileWindow(bFrame);
			bFrame.setVisible(true);
			startChoice.setVisible(false);
			fenster.show(450, 400);
		}
	}
}