package de.beagtex.listener.format;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JColorChooser;

import de.beagtex.gui.Editor;

/**
 * Listener for visible color-change in the editor-field. Does NOT EFFECT
 * text-color in LaTex-Document
 * 
 * @author Benjamin Haag
 */
public class ColorListener implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public ColorListener(Editor editor) {
		this.editor = editor;
	}

	/**
	 * Opens a ColorChooser and set the chosen color for the whole editor-text
	 */
	public void actionPerformed(ActionEvent arg0) {

		Color newColor;
		newColor = JColorChooser.showDialog(editor, "Choose a color", editor
				.getSelectedTextColor());
		editor.setForeground(newColor);
	}

}
