package de.beagtex.listener.format;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.beagtex.gui.Editor;

/**
 * Listener for defining new colors; creates a LaTex-command for a
 * RGB-Color-definition and inserts it at the current cursor-position
 * 
 * @author Benjamin Haag
 * 
 */
public class ColordefListener implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public ColordefListener(Editor editor) {
		this.editor = editor;
	}

	
	public void actionPerformed(ActionEvent arg0) {

		editor.insert("\r\n"
				+ "\\definecolor{COLORNAME}{rgb}{R-VALUE, G-VALUE, B-VALUE}"
				+ "\r\n", editor.getCaretPosition());
		editor.requestFocus();
		editor.setCaretPosition(editor.getCaretPosition());
	}

}
