package de.beagtex.listener.format;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.beagtex.gui.Editor;

/**
 * 
 * Listener for Italic-formating in LaTex-Code
 * 
 * @author Benjamin Haag
 */
public class ItalicListener implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public ItalicListener(Editor editor) {
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent arg0) {

		if (editor.getSelectedText() == null) {
			editor.insert("\\textit{}", editor.getCaretPosition());
			editor.requestFocus();
			editor.setCaretPosition(editor.getCaretPosition() - 1);
		} else {
			editor.insert("\\textit{", editor.getSelectionStart());
			editor.insert("}", editor.getSelectionEnd());
			editor.requestFocus();
			editor.setCaretPosition(editor.getSelectionEnd());
		}

	}

}
