package de.beagtex.listener.format;


import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JComboBox;

import de.beagtex.gui.Editor;


/**
 * Listener for Standard-Colors; 
 * analyzes ComboBox for Text-Colors and inserts the needed command; 
 * Colors: red, yellow, green, blue, white, black 
 * 
 * @author Benjamin Haag
 *
 * 
 */
public class StandardColorsListener implements ActionListener {

	Editor editor;
	JComboBox color;
	
	final int red = 0;
	final int yellow = 1;
	final int green = 2;
	final int blue = 3;
	final int black = 4;
	final int white = 5;

	/**
	 * Constructor
	 * @param editor: the calling editor
	 */
	public StandardColorsListener(Editor editor) {
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent arg0) {

		color = editor.getBFrame().getFormate().getCbColors();
		switch (color.getSelectedIndex()) {

			case red :
				if (editor.getSelectedText() == null) {
					editor.insert("\\textcolor{red}{}", editor.getCaretPosition());
					editor.requestFocus();
					editor.setCaretPosition(editor.getCaretPosition() - 1);
				} else {
					editor.insert("\\textcolor{red}{", editor.getSelectionStart());
					editor.insert("}", editor.getSelectionEnd());
					editor.requestFocus();
					editor.setCaretPosition(editor.getSelectionEnd());
				}
				break;

			case yellow :
				if (editor.getSelectedText() == null) {
					editor.insert("\\textcolor{yellow}{}", editor.getCaretPosition());
					editor.requestFocus();
					editor.setCaretPosition(editor.getCaretPosition() - 1);
				} else {
					editor.insert("\\textcolor{yellow}{", editor.getSelectionStart());
					editor.insert("}", editor.getSelectionEnd());
					editor.requestFocus();
					editor.setCaretPosition(editor.getSelectionEnd());
				}
				break;

			case green :
				if (editor.getSelectedText() == null) {
					editor.insert("\\textcolor{green}{}", editor.getCaretPosition());
					editor.requestFocus();
					editor.setCaretPosition(editor.getCaretPosition() - 1);
				} else {
					editor.insert("\\textcolor{green}{", editor.getSelectionStart());
					editor.insert("}", editor.getSelectionEnd());
					editor.requestFocus();
					editor.setCaretPosition(editor.getSelectionEnd());
				}
				break;

			case blue :
				if (editor.getSelectedText() == null) {
					editor.insert("\\textcolor{blue}{}", editor.getCaretPosition());
					editor.requestFocus();
					editor.setCaretPosition(editor.getCaretPosition() - 1);
				} else {
					editor.insert("\\textcolor{blue}{", editor.getSelectionStart());
					editor.insert("}", editor.getSelectionEnd());
					editor.requestFocus();
					editor.setCaretPosition(editor.getSelectionEnd());
				}
				break;

			case black :
				if (editor.getSelectedText() == null) {
					editor.insert("\\textcolor{black}{}", editor.getCaretPosition());
					editor.requestFocus();
					editor.setCaretPosition(editor.getCaretPosition() - 1);
				} else {
					editor.insert("\\textcolor{black}{", editor.getSelectionStart());
					editor.insert("}", editor.getSelectionEnd());
					editor.requestFocus();
					editor.setCaretPosition(editor.getSelectionEnd());
				}
				break;

			case white :
				if (editor.getSelectedText() == null) {
					editor.insert("\\textcolor{white}{}", editor.getCaretPosition());
					editor.requestFocus();
					editor.setCaretPosition(editor.getCaretPosition() - 1);
				} else {
					editor.insert("\\textcolor{white}{", editor.getSelectionStart());
					editor.insert("}", editor.getSelectionEnd());
					editor.requestFocus();
					editor.setCaretPosition(editor.getSelectionEnd());
				}
				break;
		}
	}

}
