package de.beagtex.listener.gui;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.JOptionPane;

import de.beagtex.gui.BFrame;
import de.beagtex.gui.Editor;

/**
 * Listener for window-events; implements only the closinng-event
 * 
 * @author Benjamin Haag
 */
public class MyWindowListener implements WindowListener {

	BFrame bFrame;

	/**
	 * Constructor
	 * 
	 * @param pBFrame:
	 *            The calling bFrame
	 */
	public MyWindowListener(BFrame pBFrame) {

		this.bFrame = pBFrame;
	}

	public void windowOpened(WindowEvent arg0) {

	}

	/**
	 * Actions when a window gets closed; is it saved?; decrement numbers
	 */
	public void windowClosing(WindowEvent arg0) {

		String test = bFrame.getEdit().getText();
		Editor.decrementNumber();
		if (!test.equalsIgnoreCase("")) {
			if (bFrame.getEdit().isSaved() != true) {
				if (JOptionPane
						.showConfirmDialog(
								null,
								BFrame.get_prop().getProperty(
										"beagtex.exitlistener.saveconfirm"),
								BFrame
										.get_prop()
										.getProperty(
												"beagtex.exitlistener.saveconfirmtitle"),
								JOptionPane.YES_NO_OPTION,
								JOptionPane.QUESTION_MESSAGE) == JOptionPane.YES_OPTION)
					bFrame.getEdit().saveAs();
			}
		}
		if (Editor.getNumber() == 0)
			System.exit(0);

	}

	public void windowClosed(WindowEvent arg0) {

	}

	public void windowIconified(WindowEvent arg0) {

	}

	public void windowDeiconified(WindowEvent arg0) {

	}

	public void windowActivated(WindowEvent arg0) {

	}

	public void windowDeactivated(WindowEvent arg0) {

	}

}
