package de.beagtex.listener.insert;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.beagtex.gui.Editor;

/**
 * Listener for insering footnotes in LaTex-Code
 * 
 * @author Benjamin Haag
 */
public class FootnoteListener implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public FootnoteListener(Editor editor) {
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent arg0) {

		if (editor.getSelectedText() == null) {
			editor.insert("\\footnote{}", editor.getCaretPosition());
			editor.requestFocus();
			editor.setCaretPosition(editor.getCaretPosition() - 1);
		} else {
			editor.insert("\\footnote{", editor.getSelectionStart());
			editor.insert("}", editor.getSelectionEnd());
			editor.requestFocus();
			editor.setCaretPosition(editor.getSelectionEnd());
		}
	}

}
