package de.beagtex.listener.insert;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFileChooser;

import de.beagtex.gui.Editor;
import de.beagtex.gui.MyOpenChooser;

/**
 * Listener for inserting a LaTex-Input-File
 * 
 * @author Benjamin Haag
 */
public class LatexListener implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public LatexListener(Editor editor) {
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent arg0) {

		editor.insert("\\input{" + getFile() + "} ", editor.getCaretPosition());
	}

	/**
	 * Opens a FileChooser
	 * 
	 * @return file: Filename without ending
	 */
	public String getFile() {
		String file = "FILENAME WITHOUT .tex";
		JFileChooser choosy = new MyOpenChooser(editor);
		choosy.setCurrentDirectory(choosy.getCurrentDirectory());
		choosy.setVisible(true);
		if (choosy.getSelectedFile() != null) {
			file = choosy.getSelectedFile().getName();
			file = file.replaceAll(".tex", "");
		}
		return file;
	}

}
