/*
 * Decompiled with CFR 0.152.
 */
package com.sonoransoft.codequill;

import com.sonoransoft.codequill.BufferMgr;
import com.sonoransoft.codequill.CommandLine;
import com.sonoransoft.codequill.CommandMgr;
import com.sonoransoft.codequill.CqMessageDialog;
import com.sonoransoft.codequill.CqOutOfMemoryException;
import com.sonoransoft.codequill.CqPrint;
import com.sonoransoft.codequill.DecisionDialog;
import com.sonoransoft.codequill.EditSession;
import com.sonoransoft.codequill.EditSessionInt;
import com.sonoransoft.codequill.ExitClient;
import com.sonoransoft.codequill.ExtensionDialog;
import com.sonoransoft.codequill.HelpDialog;
import com.sonoransoft.codequill.InformationArea;
import com.sonoransoft.codequill.InformationBar;
import com.sonoransoft.codequill.Key;
import com.sonoransoft.codequill.LinkedList;
import com.sonoransoft.codequill.Options;
import com.sonoransoft.codequill.PrintOptionDialog;
import com.sonoransoft.codequill.RadioMenu;
import com.sonoransoft.codequill.RecallMenu;
import com.sonoransoft.codequill.Registration;
import com.sonoransoft.codequill.SearchMgr;
import com.sonoransoft.codequill.SyntaxMetaMgr;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class CodeQuill
extends Frame
implements EditSessionInt,
ActionListener,
ItemListener,
KeyListener,
WindowListener,
FocusListener {
    private static final char CMD_NEW = '\u0001';
    private static final char CMD_EDIT = '\u0002';
    private static final char CMD_VERSION = '\u0003';
    private EditSession session;
    private SearchMgr searchMgr;
    private BufferMgr bufferMgr;
    private CommandLine commandLine;
    private LinkedList sessionList = new LinkedList();
    private Options options;
    private StringBuffer titleLine = new StringBuffer("CodeQuill");
    private InformationBar informationBar;
    private InformationArea informationArea;
    private String fileDialogPath;
    private CommandMgr commandMgr;
    private boolean markAreaValid = false;
    private RecallMenu recallMenu;
    private Menu fileMenu = new Menu("File");
    private MenuItem newFileMenuItem = new MenuItem("New");
    private MenuItem openFileMenuItem = new MenuItem("Open...");
    private MenuItem saveFileMenuItem = new MenuItem("Save");
    private MenuItem saveAsFileMenuItem = new MenuItem("Save as...");
    private MenuItem closeFileMenuItem = new MenuItem("Close");
    private CheckboxMenuItem compressFileMenuItem = new CheckboxMenuItem("Tab compression");
    private Menu printFileMenu = new Menu("Print");
    private MenuItem markedPrintFileMenuItem = new MenuItem("Marked area");
    private MenuItem allPrintFileMenuItem = new MenuItem("All");
    private MenuItem quitFileMenuItem = new MenuItem("Quit");
    private MenuItem undoEditMenuItem = new MenuItem("Undo");
    private MenuItem copyEditMenuItem = new MenuItem("Copy");
    private MenuItem copyBufferEditMenuItem = new MenuItem("Copy buffer");
    private MenuItem cutEditMenuItem = new MenuItem("Cut");
    private MenuItem pasteEditMenuItem = new MenuItem("Paste");
    private MenuItem searchEditMenuItem = new MenuItem("Search...");
    private RadioMenu fontNameOptionMenu = new RadioMenu("Font name");
    private RadioMenu fontPointOptionMenu = new RadioMenu("Font point");
    private CheckboxMenuItem fontBoldOptionMenuItem = new CheckboxMenuItem("Font bold");
    private CheckboxMenuItem autoIndentOptionMenuItem = new CheckboxMenuItem("Auto indent");
    private CheckboxMenuItem backspaceTabOptionMenuItem = new CheckboxMenuItem("Backspace tab");
    private RadioMenu tabColumnOptionMenu = new RadioMenu("Tab column");
    private RadioMenu newFileDefaultFormatOptionMenu = new RadioMenu("New file format");
    private CheckboxMenuItem defaultTabCompressionOptionMenuItem = new CheckboxMenuItem("Save with tabs");
    private CheckboxMenuItem defaultSpaceExpansionOptionMenuItem = new CheckboxMenuItem("Save with spaces");
    private RadioMenu fileSaveFormatOptionMenu = new RadioMenu("File save format");
    private CheckboxMenuItem saveDefaultCompressionOptionMenuItem = new CheckboxMenuItem("Use existing format");
    private CheckboxMenuItem saveTabCompressionOptionMenuItem = new CheckboxMenuItem("Save with tabs");
    private CheckboxMenuItem saveSpaceExpansionOptionMenuItem = new CheckboxMenuItem("Save with spaces");
    private CheckboxMenuItem stripEolSpacesOptionMenuItem = new CheckboxMenuItem("Strip EOL spaces");
    private Menu searchOptionMenu = new Menu("Search");
    private CheckboxMenuItem matchCaseSearchOptionMenuItem = new CheckboxMenuItem("Match case");
    private Menu cursorOptionMenu = new Menu("Cursor");
    private CheckboxMenuItem eolIndependentCursorOptionMenuItem = new CheckboxMenuItem("EOL independent");
    private Menu colorOptionMenu = new Menu("Color");
    private RadioMenu backgroundColorOptionRadioMenu = new RadioMenu("Background");
    private RadioMenu textColorOptionRadioMenu = new RadioMenu("Text");
    private RadioMenu commentsColorOptionRadioMenu = new RadioMenu("Comments");
    private RadioMenu keywordsColorOptionRadioMenu = new RadioMenu("Key words");
    private Menu commandLineOptionMenu = new Menu("Command line");
    private CheckboxMenuItem fontBoldCommandLineOptionMenuItem = new CheckboxMenuItem("Font bold");
    private RadioMenu fontPointCommandLineOptionMenu = new RadioMenu("Font point");
    private MenuItem extensionOptionMenuItem = new MenuItem("Extension...");
    private MenuItem saveOptionMenuItem = new MenuItem("Save options");
    private MenuItem printOptionMenuItem = new MenuItem("Print...");
    private MenuItem helpHelpMenuItem = new MenuItem("Help...");
    private MenuItem aboutHelpMenuItem = new MenuItem("About...");
    private MenuItem registrationHelpMenuItem = new MenuItem("Registration...");
    private MenuShortcut copyShortcut = new MenuShortcut(67);
    private MenuShortcut pasteShortcut = new MenuShortcut(86);
    private MenuShortcut cutShortcut = new MenuShortcut(88);
    private MenuShortcut undoShortcut = new MenuShortcut(90);
    private MenuShortcut newShortcut = new MenuShortcut(78);
    private MenuShortcut openShortcut = new MenuShortcut(79);
    private MenuShortcut saveShortcut = new MenuShortcut(83);
    private MenuShortcut closeShortcut = new MenuShortcut(87);
    private MenuShortcut quitShortcut = new MenuShortcut(81);
    private String version = new String("1.1.4 beta");
    private String licenseNumber = new String();
    private Integer cqObjectFormatId = new Integer(0);
    private Dimension windowStartSize;
    private Point windowStartLocation;
    private boolean registered;
    private SyntaxMetaMgr syntaxMetaMgr;
    private Color backgroundColor;
    private Panel sessionPanel;
    private String cqobjectFileName;

    public CodeQuill(String[] stringArray) {
        this.updateTitleLine();
        this.options = new Options();
        this.windowStartSize = new Dimension(this.options.getDefaultWidth(), this.options.getDefaultHeight());
        this.restoreCodeQuill();
        this.initializeMenus();
        this.commandMgr = new CommandMgr();
        this.setupCommands();
        this.informationBar = new InformationBar();
        this.fileDialogPath = System.getProperty("user.dir");
        this.syntaxMetaMgr = new SyntaxMetaMgr(this.options);
        this.bufferMgr = new BufferMgr();
        this.searchMgr = new SearchMgr();
        this.searchMgr.setCaseIndependent(this.options.isSearchCaseIndependent());
        this.commandLine = new CommandLine();
        this.setCommandLineFont();
        this.informationArea = new InformationArea(this.commandLine, this.informationBar);
        this.sessionPanel = new Panel(new BorderLayout());
        this.add((Component)this.sessionPanel, "Center");
        if (stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                this.openSession(stringArray[n++]);
            }
        } else {
            EditSession editSession = new EditSession(this, this, this.syntaxMetaMgr, this.bufferMgr, this.options, this.informationBar, this.searchMgr);
            if (editSession != null) {
                this.sessionList.append(editSession);
                editSession.addKeyListener(this);
                this.nextSession();
                this.setSessionMenu();
            } else {
                this.postMessage("Could not create a new session");
            }
        }
        this.sessionList.first();
        this.session = (EditSession)this.sessionList.get();
        if (this.session != null) {
            this.sessionPanel.add((Component)this.session, "Center");
        }
        this.add((Component)this.informationArea, "South");
        this.setSessionMenu();
        this.updateTitleLine();
        this.commandLine.addFocusListener(this);
        this.commandLine.addActionListener(this);
        this.addWindowListener(this);
        this.addFocusListener(this);
        this.registered = true;
        this.checkRegistration();
        this.updateOptions();
    }

    private void updateOptions() {
        this.backgroundColor = this.options.getBackgroundColor().equals("Default") ? SystemColor.window : this.text2Color(this.options.getBackgroundColor());
        this.sessionPanel.setBackground(this.backgroundColor);
    }

    private Color text2Color(String string) {
        if (string.compareTo("Default") == 0) {
            return Color.black;
        }
        if (string.compareTo("White") == 0) {
            return Color.white;
        }
        if (string.compareTo("Light gray") == 0) {
            return Color.lightGray;
        }
        if (string.compareTo("Gray") == 0) {
            return Color.gray;
        }
        if (string.compareTo("Dark gray") == 0) {
            return Color.darkGray;
        }
        if (string.compareTo("Black") == 0) {
            return Color.black;
        }
        if (string.compareTo("Red") == 0) {
            return Color.red;
        }
        if (string.compareTo("Pink") == 0) {
            return Color.pink;
        }
        if (string.compareTo("Orange") == 0) {
            return Color.orange;
        }
        if (string.compareTo("Green") == 0) {
            return Color.green;
        }
        if (string.compareTo("Magenta") == 0) {
            return Color.magenta;
        }
        if (string.compareTo("Cyan") == 0) {
            return Color.cyan;
        }
        if (string.compareTo("Blue") == 0) {
            return Color.blue;
        }
        if (string.compareTo("Yellow") == 0) {
            return Color.yellow;
        }
        return Color.black;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this.commandLine) {
            this.commandLine.addKeyListener(this);
            this.pasteEditMenuItem.setEnabled(false);
            if (this.session != null) {
                this.session.editEngineResetMarkArea();
            }
        } else {
            this.setCurrentSessionFocus();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this.commandLine) {
            this.commandLine.removeKeyListener(this);
            if (this.session != null) {
                this.pasteEditMenuItem.setEnabled(true);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof MenuItem) {
            if (((MenuItem)actionEvent.getSource()).getParent() == this.recallMenu) {
                this.openSession(((MenuItem)actionEvent.getSource()).getLabel());
            } else {
                this.menuItemActionPerformed(actionEvent);
            }
        } else if (actionEvent.getSource() == this.commandLine) {
            this.commandLineActionPerformed(actionEvent);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.informationBar.clearMessage();
        MenuItem menuItem = (MenuItem)itemEvent.getSource();
        if (menuItem.getParent() == this.backgroundColorOptionRadioMenu) {
            this.setBackgroundColor();
        }
        if (menuItem.getParent() == this.textColorOptionRadioMenu) {
            this.setTextColor();
        }
        if (menuItem.getParent() == this.fontNameOptionMenu) {
            this.setFontName();
        }
        if (menuItem.getParent() == this.fontPointOptionMenu) {
            this.setFontPoint();
        }
        if (menuItem.getParent() == this.fontPointCommandLineOptionMenu) {
            this.setCommandLineFontPoint();
            this.commandLine.setSize(0, 0);
            this.validate();
            this.setCurrentSessionFocus();
        } else if (menuItem.getParent() == this.tabColumnOptionMenu) {
            this.setTabColumn();
        } else if (menuItem.getParent() == this.newFileDefaultFormatOptionMenu) {
            this.options.setDefaultTabCompression(this.defaultTabCompressionOptionMenuItem.getState());
        } else if (menuItem.getParent() == this.fileSaveFormatOptionMenu) {
            this.setFileSaveFormat(menuItem);
        } else if (menuItem == this.compressFileMenuItem) {
            this.session.setEnableTabCompression(this.compressFileMenuItem.getState());
        } else if (menuItem == this.fontBoldOptionMenuItem) {
            this.options.setFontBold(this.fontBoldOptionMenuItem.getState());
            this.updateSessionOptions();
        } else if (menuItem == this.fontBoldCommandLineOptionMenuItem) {
            this.options.setCommandLineFontBold(this.fontBoldCommandLineOptionMenuItem.getState());
            this.setCommandLineFont();
            this.commandLine.setSize(0, 0);
            this.validate();
            this.setCurrentSessionFocus();
        } else if (menuItem == this.autoIndentOptionMenuItem) {
            this.options.setAutoIndent(this.autoIndentOptionMenuItem.getState());
            this.updateSessionOptions();
        } else if (menuItem == this.backspaceTabOptionMenuItem) {
            this.options.setBackspaceTab(this.backspaceTabOptionMenuItem.getState());
            this.updateSessionOptions();
        } else if (menuItem == this.stripEolSpacesOptionMenuItem) {
            this.options.setStripEolSpaces(this.stripEolSpacesOptionMenuItem.getState());
        } else if (menuItem == this.matchCaseSearchOptionMenuItem) {
            this.options.setSearchCaseIndependent(!this.matchCaseSearchOptionMenuItem.getState());
            this.searchMgr.setCaseIndependent(!this.matchCaseSearchOptionMenuItem.getState());
        } else if (menuItem == this.eolIndependentCursorOptionMenuItem) {
            this.options.setEolIndependentCursor(this.eolIndependentCursorOptionMenuItem.getState());
            this.updateSessionOptions();
        }
    }

    private void updateSessionOptions() {
        this.updateOptions();
        this.sessionList.push();
        this.sessionList.first();
        EditSession editSession = (EditSession)this.sessionList.get();
        while (editSession != null) {
            editSession.updateOptions();
            editSession.setSyntaxMetaMgr(this.syntaxMetaMgr);
            editSession = (EditSession)this.sessionList.getNext();
        }
        this.sessionList.pop();
    }

    private void commandLineActionPerformed(ActionEvent actionEvent) {
        if (this.session != null) {
            this.session.requestFocus();
        }
        switch (this.commandLine.getSearchRequest()) {
            case 0: 
            case 3: {
                String string = this.commandLine.getCommandString();
                string = string.trim();
                this.informationBar.clearMessage();
                if (this.session != null && this.session.processCommandLine(string) || this.processCommandLine(string)) break;
                if (this.session == null) {
                    this.informationBar.setMessage("Invalid system command, use \"new\" \"edit\" or \"e\" to start session");
                    break;
                }
                this.informationBar.setMessage("Invalid command");
                break;
            }
            case 1: {
                if (this.session == null) {
                    this.informationBar.setMessage("Must have open file to search");
                    break;
                }
                this.searchMgr.setSearchString(this.commandLine.getSearchString());
                this.searchMgr.setSearchForward(true);
                this.session.search();
                break;
            }
            case 2: {
                if (this.session == null) {
                    this.informationBar.setMessage("Must have open file to search");
                    break;
                }
                this.searchMgr.setSearchString(this.commandLine.getSearchString());
                this.searchMgr.setSearchForward(false);
                this.session.search();
            }
        }
        this.commandLine.clear();
    }

    public static void main(String[] stringArray) {
        CodeQuill codeQuill = new CodeQuill(stringArray);
        codeQuill.pack();
        ((Component)codeQuill).setSize(codeQuill.getStartSize());
        codeQuill.show();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.processSessionRequest(keyEvent)) {
            keyEvent.consume();
            return;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        Key key = new Key(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this.processSystemKey(keyEvent)) {
            keyEvent.consume();
            return;
        }
        if (keyEvent.getComponent() == this.commandLine && keyEvent.getKeyCode() == 27) {
            this.informationBar.clearMessage();
            this.commandLine.clear();
            if (this.session != null) {
                this.session.requestFocus();
            }
            keyEvent.consume();
            return;
        }
    }

    private boolean processSystemKey(KeyEvent keyEvent) {
        boolean bl = false;
        if (keyEvent.getKeyCode() == 112) {
            this.informationBar.setMessage("F2 - Next file, F3 - Previous file, F4 - File information");
            bl = true;
        } else if (keyEvent.getKeyCode() == 113) {
            if (this.session == null) {
                this.informationBar.setMessage("No current sessions");
            } else if (keyEvent.getComponent() != this.commandLine) {
                if (this.sessionList.getSize() == 1) {
                    this.informationBar.setMessage("Only one session");
                } else {
                    this.informationBar.clearMessage();
                    this.nextSession();
                    this.setSessionMenu();
                }
            }
            bl = true;
        } else if (keyEvent.getKeyCode() == 114) {
            if (this.session == null) {
                this.informationBar.setMessage("No current sessions");
            } else if (keyEvent.getComponent() != this.commandLine) {
                if (this.sessionList.getSize() == 1) {
                    this.informationBar.setMessage("Only one session");
                } else {
                    this.informationBar.clearMessage();
                    this.previousSession();
                }
            }
            bl = true;
        } else if (keyEvent.getKeyCode() == 115) {
            if (this.session == null) {
                this.informationBar.setMessage("No current sessions");
            } else {
                this.informationBar.setMessage(this.session.getFileInformation(), this.session.getName(), this.session.getSeparator());
            }
            bl = true;
        }
        return bl;
    }

    private boolean processSessionRequest(KeyEvent keyEvent) {
        if (this.session == null) {
            return false;
        }
        char c = this.session.request();
        if (c != '\u0000') {
            switch (c) {
                case '\u0000': {
                    break;
                }
                case '\u0002': {
                    this.commandLine.requestCommand();
                    this.informationBar.setMessage("Command line");
                    return true;
                }
                case '\u0003': {
                    this.commandLine.requestSearchForward();
                    this.informationBar.setMessage("Search forward");
                    return true;
                }
                case '\u0004': {
                    this.commandLine.requestSearchBack();
                    this.informationBar.setMessage("Search back");
                    return true;
                }
                case '\u0001': {
                    this.closeSession(true);
                    return true;
                }
            }
        }
        return false;
    }

    void postMessage(String string) {
        CqMessageDialog cqMessageDialog = new CqMessageDialog((Frame)this, "CodeQuill message", string);
        cqMessageDialog.setResizable(false);
        cqMessageDialog.setVisible(true);
        cqMessageDialog.dispose();
        this.setCurrentSessionFocus();
    }

    void postSyntaxReadFail(String string) {
        String[] stringArray = new String[]{"Could not read syntax file:", string};
        CqMessageDialog cqMessageDialog = new CqMessageDialog((Frame)this, "Syntax file read failure", stringArray);
        cqMessageDialog.setResizable(false);
        cqMessageDialog.setVisible(true);
        cqMessageDialog.dispose();
        this.setCurrentSessionFocus();
    }

    void postRegistrationThankYou(String string) {
        String[] stringArray = new String[3];
        stringArray[0] = "CodeQuill registration validated.";
        stringArray[1] = "Registered to: ";
        stringArray[1] = stringArray[1].concat(string);
        stringArray[2] = "Thank you for registering!";
        CqMessageDialog cqMessageDialog = new CqMessageDialog((Frame)this, "CodeQuill registration thank you", stringArray);
        cqMessageDialog.setResizable(false);
        cqMessageDialog.setVisible(true);
        cqMessageDialog.dispose();
        this.setCurrentSessionFocus();
    }

    void postAboutMessage() {
        String[] stringArray = new String[]{"CodeQuill", "version " + this.version, "Copyright (c) 2001 Sonoran Software Guild, Inc.", "All rights reserved."};
        CqMessageDialog cqMessageDialog = new CqMessageDialog((Frame)this, "About Code Quill", stringArray);
        cqMessageDialog.setResizable(false);
        cqMessageDialog.setVisible(true);
        cqMessageDialog.dispose();
        this.setCurrentSessionFocus();
    }

    void postHelpMessage() {
        HelpDialog helpDialog = new HelpDialog((Frame)this, "CodeQuill Help", "CodeQuillHelp.txt");
        helpDialog.setVisible(true);
        helpDialog.dispose();
        this.setCurrentSessionFocus();
    }

    private boolean openSession(String string) {
        if (string != null && string.length() > 0) {
            EditSession editSession;
            String string2;
            StringBuffer stringBuffer = new StringBuffer(string);
            File file = new File(string);
            try {
                string2 = file.getCanonicalPath();
                int n = file.getName().lastIndexOf(46);
                String string3 = n == -1 || n == file.getName().length() ? "" : file.getName().substring(n + 1);
            }
            catch (Exception exception) {
                this.informationBar.setMessage("Could not open, illegal file path");
                return false;
            }
            if (file.isDirectory()) {
                this.informationBar.setMessage("Could not open, file is a directory");
                return false;
            }
            this.sessionList.push();
            this.sessionList.first();
            EditSession editSession2 = (EditSession)this.sessionList.get();
            while (editSession2 != null) {
                String string4 = editSession2.getCanonicalPath();
                if (string4 != null && (!this.options.isFileCaseSensitive() && string4.toLowerCase().compareTo(string2.toLowerCase()) == 0 || string4.compareTo(string2) == 0)) {
                    this.sessionList.pop();
                    this.setSession(editSession2);
                    this.recallMenu.insert(editSession2.getName(), this);
                    return true;
                }
                editSession2 = (EditSession)this.sessionList.getNext();
            }
            this.sessionList.pop();
            if (this.checkOpenFileLimit()) {
                return false;
            }
            try {
                editSession = new EditSession(this, this, string2, this.syntaxMetaMgr, this.bufferMgr, this.options, this.informationBar, this.searchMgr);
            }
            catch (CqOutOfMemoryException cqOutOfMemoryException) {
                editSession = null;
                this.postMessage("Could not open file due to memory limitations.\nThe file may be too large.\nPlease try closing open files and try again.");
            }
            if (editSession != null) {
                this.closeOnlyUnnamedSession();
                this.sessionList.append(editSession);
                editSession.addKeyListener(this);
                this.nextSession();
                this.setSessionMenu();
                this.recallMenu.insert(this.session.getName(), this);
                return true;
            }
        }
        return false;
    }

    private boolean openSession() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Open", 0);
        fileDialog.setDirectory(this.fileDialogPath);
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        fileDialog.dispose();
        this.fileDialogPath = fileDialog.getDirectory();
        if (string != null && string.length() > 0) {
            EditSession editSession;
            String string2;
            StringBuffer stringBuffer = new StringBuffer(this.fileDialogPath);
            stringBuffer.append(string);
            File file = new File(stringBuffer.toString());
            try {
                string2 = file.getCanonicalPath();
                int n = file.getName().lastIndexOf(46);
                String string3 = n == -1 || n == file.getName().length() ? "" : file.getName().substring(n + 1);
            }
            catch (Exception exception) {
                this.postMessage("Could not open, invalid file path");
                return false;
            }
            this.sessionList.push();
            this.sessionList.first();
            EditSession editSession2 = (EditSession)this.sessionList.get();
            while (editSession2 != null) {
                String string4 = editSession2.getCanonicalPath();
                if (string4 != null && (!this.options.isFileCaseSensitive() && string4.toLowerCase().compareTo(string2.toLowerCase()) == 0 || string4.compareTo(string2) == 0)) {
                    this.sessionList.pop();
                    this.setSession(editSession2);
                    this.recallMenu.insert(this.session.getName(), this);
                    return true;
                }
                editSession2 = (EditSession)this.sessionList.getNext();
            }
            this.sessionList.pop();
            if (this.checkOpenFileLimit()) {
                return false;
            }
            try {
                editSession = new EditSession(this, this, string2, this.syntaxMetaMgr, this.bufferMgr, this.options, this.informationBar, this.searchMgr);
            }
            catch (CqOutOfMemoryException cqOutOfMemoryException) {
                editSession = null;
                this.postMessage("Could not open file due to memory limitations.\nThe file may be too large.\nPlease try closing open files and try again.");
            }
            if (editSession != null) {
                this.closeOnlyUnnamedSession();
                this.sessionList.append(editSession);
                editSession.addKeyListener(this);
                this.nextSession();
                this.setSessionMenu();
                this.recallMenu.insert(this.session.getName(), this);
                return true;
            }
        }
        this.setCurrentSessionFocus();
        return false;
    }

    private boolean closeSession(boolean bl) {
        Container container;
        if (this.session == null) {
            return false;
        }
        if (this.session.isModified() && !bl) {
            container = new DecisionDialog((Frame)this, "CodeQuill - Warning", "File is modified. Close file anyway?", false);
            ((DecisionDialog)container).setVisible(true);
            if (!((DecisionDialog)container).getDecision()) {
                this.setCurrentSessionFocus();
                ((Window)container).dispose();
                return false;
            }
            ((Window)container).dispose();
        }
        container = null;
        if (!this.sessionList.isPrevious()) {
            container = (EditSession)this.sessionList.remove();
            ((EditSession)container).closeSession();
            this.sessionPanel.remove(container);
            this.sessionList.last();
        } else {
            container = (EditSession)this.sessionList.remove();
            ((EditSession)container).closeSession();
            this.sessionPanel.remove(container);
        }
        if (!this.currentSession()) {
            this.openUnnamedSession();
            this.setCurrentSessionFocus();
        }
        Runtime.getRuntime().gc();
        return true;
    }

    private EditSession getUnnamedUnmodifiedSession() {
        this.sessionList.push();
        this.sessionList.first();
        EditSession editSession = (EditSession)this.sessionList.get();
        while (editSession != null) {
            if (editSession.getName() == null && !editSession.isModified()) {
                this.sessionList.pop();
                return editSession;
            }
            editSession = (EditSession)this.sessionList.getNext();
        }
        this.sessionList.pop();
        return null;
    }

    private void closeOnlyUnnamedSession() {
        if (this.sessionList.getSize() == 1 && this.session.getName() == null && !this.session.isModified()) {
            EditSession editSession = (EditSession)this.sessionList.remove();
            editSession.closeSession();
            this.sessionPanel.remove(editSession);
        }
    }

    private void openUnnamedSession() {
        EditSession editSession = new EditSession(this, this, this.syntaxMetaMgr, this.bufferMgr, this.options, this.informationBar, this.searchMgr);
        if (editSession != null) {
            this.sessionList.append(editSession);
            editSession.addKeyListener(this);
            this.nextSession();
            this.setSessionMenu();
        } else {
            this.postMessage("Could not create a new session");
        }
    }

    private void setCurrentSessionFocus() {
        if (this.session == null) {
            this.commandLine.requestFocus();
        } else {
            this.session.requestFocus();
        }
    }

    private boolean currentSession() {
        this.session = (EditSession)this.sessionList.get();
        if (this.session == null) {
            this.updateTitleLine();
            return false;
        }
        this.sessionPanel.add((Component)this.session, "Center");
        this.validate();
        this.updateTitleLine();
        this.session.requestFocus();
        this.setSessionMenu();
        return true;
    }

    private void setSession(EditSession editSession) {
        EditSession editSession2 = this.session;
        this.sessionList.first();
        this.session = (EditSession)this.sessionList.get();
        while (this.session != editSession) {
            this.session = (EditSession)this.sessionList.getNext();
        }
        if (editSession2 != editSession) {
            this.sessionPanel.remove(editSession2);
            this.sessionPanel.add((Component)this.session, "Center");
            this.validate();
            this.updateTitleLine();
        }
        this.setSessionMenu();
        this.session.requestFocus();
    }

    private void nextSession() {
        EditSession editSession;
        if (this.session == null) {
            editSession = null;
            this.session = (EditSession)this.sessionList.get();
        } else {
            editSession = this.session;
            if (this.sessionList.next()) {
                this.session = (EditSession)this.sessionList.get();
            } else {
                this.sessionList.first();
                this.session = (EditSession)this.sessionList.get();
            }
        }
        if (this.session != null) {
            if (editSession != null) {
                this.sessionPanel.remove(editSession);
            }
            this.sessionPanel.add((Component)this.session, "Center");
            this.validate();
            this.updateTitleLine();
            this.session.requestFocus();
        } else {
            this.postMessage("session == null");
            this.updateTitleLine();
        }
    }

    private void previousSession() {
        EditSession editSession;
        if (this.session == null) {
            editSession = null;
            this.session = (EditSession)this.sessionList.get();
        } else {
            editSession = this.session;
            if (this.sessionList.previous()) {
                this.session = (EditSession)this.sessionList.get();
            } else {
                this.sessionList.last();
                this.session = (EditSession)this.sessionList.get();
            }
        }
        if (this.session != null) {
            if (editSession != null) {
                this.sessionPanel.remove(editSession);
            }
            this.sessionPanel.add((Component)this.session, "Center");
            this.validate();
            this.updateTitleLine();
            this.session.requestFocus();
        } else {
            this.postMessage("session == null");
            this.updateTitleLine();
        }
        this.setSessionMenu();
    }

    private void menuItemActionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = actionEvent.getSource();
        this.informationBar.clearMessage();
        if (object2 == this.registrationHelpMenuItem) {
            object = new HelpDialog((Frame)this, "CodeQuill registration", "BetaRegistration.txt");
            ((CqMessageDialog)object).setVisible(true);
            ((Window)object).dispose();
        }
        if (object2 == this.aboutHelpMenuItem) {
            this.postAboutMessage();
        }
        if (object2 == this.helpHelpMenuItem) {
            this.postHelpMessage();
        }
        if (object2 == this.quitFileMenuItem) {
            this.codeQuillExit(false);
        } else if (object2 == this.closeFileMenuItem) {
            this.closeSession(false);
        } else if (object2 == this.openFileMenuItem) {
            this.openSession();
        } else if (object2 == this.saveFileMenuItem) {
            this.saveSession();
        } else if (object2 == this.saveAsFileMenuItem) {
            this.saveAsSession();
        } else if (object2 == this.newFileMenuItem) {
            if (this.checkOpenFileLimit()) {
                return;
            }
            object = this.getUnnamedUnmodifiedSession();
            if (object == null) {
                object = new EditSession(this, this, this.syntaxMetaMgr, this.bufferMgr, this.options, this.informationBar, this.searchMgr);
                if (object != null) {
                    this.sessionList.append(object);
                    ((Component)object).addKeyListener(this);
                    this.nextSession();
                    this.setSessionMenu();
                } else {
                    this.postMessage("Could not create a new session");
                }
            } else {
                this.setSession((EditSession)object);
                this.setSessionMenu();
            }
        } else if (object2 == this.undoEditMenuItem) {
            this.session.undo();
        } else if (object2 == this.copyEditMenuItem) {
            object = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(this.session.getMarkedArea(false, false));
            ((Clipboard)object).setContents(stringSelection, stringSelection);
        } else if (object2 == this.markedPrintFileMenuItem) {
            object = this.session.getSimpleName();
            if (object == null) {
                object = "";
            }
            CqPrint cqPrint = new CqPrint(this.options);
            cqPrint.print(this, this.session.getMarkedArea(false, true), this.session.getMarkedAreaStartLine(), (String)object);
        } else if (object2 == this.allPrintFileMenuItem) {
            object = this.session.getSimpleName();
            if (object == null) {
                object = "";
            }
            CqPrint cqPrint = new CqPrint(this.options);
            cqPrint.print(this, this.session.getFileArea(), 0, (String)object);
        } else if (object2 == this.copyBufferEditMenuItem) {
            if (this.bufferMgr.isValid('\u0000')) {
                object = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(this.session.getCopyBuffer());
                ((Clipboard)object).setContents(stringSelection, stringSelection);
            } else {
                this.postMessage("Copy buffer is empty");
            }
        } else if (object2 == this.saveOptionMenuItem) {
            if (!this.options.save()) {
                this.postMessage("Could not save options");
            }
        } else if (object2 == this.cutEditMenuItem) {
            object = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(this.session.getMarkedArea(true, false));
            ((Clipboard)object).setContents(stringSelection, stringSelection);
        } else if (object2 == this.pasteEditMenuItem) {
            this.paste();
        } else if (object2 != this.searchEditMenuItem) {
            if (object2 == this.extensionOptionMenuItem) {
                this.setExtensionOptions();
            } else if (object2 == this.printOptionMenuItem) {
                this.setPrintOptions();
            }
        }
    }

    private void setPrintOptions() {
        PrintOptionDialog printOptionDialog = new PrintOptionDialog((Frame)this, this.options);
        ((Component)printOptionDialog).setVisible(true);
        if (printOptionDialog.isModified()) {
            this.setCurrentSessionFocus();
        }
        printOptionDialog.dispose();
    }

    private void setExtensionOptions() {
        this.options.storeOptions();
        ExtensionDialog extensionDialog = new ExtensionDialog((Frame)this, this.options, this.syntaxMetaMgr.getBuiltInExtensionList());
        ((Component)extensionDialog).setVisible(true);
        if (!extensionDialog.isModified()) {
            extensionDialog.dispose();
            this.setCurrentSessionFocus();
            this.options.restoreOptions();
        } else {
            extensionDialog.dispose();
            this.setCurrentSessionFocus();
            this.syntaxMetaMgr = new SyntaxMetaMgr(this.options);
            this.updateSessionOptions();
        }
    }

    private void paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable == null) {
            this.postMessage("Clipboard is empty");
        } else {
            this.session.paste(transferable);
        }
    }

    private void saveSession() {
        if (this.session.getName() == null) {
            this.saveAsSession();
        } else if (this.session.write() != '\u0000') {
            this.postMessage("Could not save file");
        } else {
            this.informationBar.setMessage("File save complete");
        }
    }

    private void saveAsSession() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save As", 1);
        fileDialog.setDirectory(this.fileDialogPath);
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        this.fileDialogPath = fileDialog.getDirectory();
        fileDialog.dispose();
        if (string != null && string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(this.fileDialogPath);
            stringBuffer.append(string);
            char c = this.session.write(stringBuffer.toString(), false);
            if (c == '\u0000') {
                this.updateTitleLine();
                this.informationBar.setMessage("File save as complete");
            } else if (c == '\u0001') {
                DecisionDialog decisionDialog = new DecisionDialog((Frame)this, "CodeQuill - Warning", "File exists. Overwrite the file?", false);
                decisionDialog.setVisible(true);
                if (decisionDialog.getDecision()) {
                    c = this.session.write(stringBuffer.toString(), true);
                    if (c != '\u0000') {
                        this.postMessage("Could not save file");
                    } else {
                        this.informationBar.setMessage("File save as complete");
                    }
                    c = this.session.write(stringBuffer.toString(), false);
                }
                decisionDialog.dispose();
            } else {
                this.postMessage("Could not save file");
            }
            this.setCurrentSessionFocus();
            this.setSessionMenu();
        }
    }

    private void setSessionMenu() {
        boolean bl;
        if (this.session == null) {
            this.commandLine.setFocusTraversable(true);
            bl = false;
            if (this.options.isForceTabCompression() || this.options.isForceSpaceExpansion()) {
                this.compressFileMenuItem.setState(this.options.isForceTabCompression());
                this.compressFileMenuItem.setEnabled(false);
            } else {
                this.compressFileMenuItem.setState(false);
                this.compressFileMenuItem.setEnabled(false);
            }
            this.saveFileMenuItem.setEnabled(false);
        } else {
            this.commandLine.setFocusTraversable(false);
            bl = true;
            if (this.options.isForceTabCompression() || this.options.isForceSpaceExpansion()) {
                this.compressFileMenuItem.setState(this.options.isForceTabCompression());
                this.compressFileMenuItem.setEnabled(false);
            } else {
                this.compressFileMenuItem.setState(this.session.isTabCompression());
                this.compressFileMenuItem.setEnabled(true);
            }
        }
        this.saveFileMenuItem.setEnabled(bl);
        this.saveAsFileMenuItem.setEnabled(bl);
        this.closeFileMenuItem.setEnabled(bl);
        this.undoEditMenuItem.setEnabled(bl);
        this.copyEditMenuItem.setEnabled(false);
        this.markedPrintFileMenuItem.setEnabled(false);
        this.copyBufferEditMenuItem.setEnabled(bl);
        this.cutEditMenuItem.setEnabled(false);
        this.pasteEditMenuItem.setEnabled(bl);
        this.searchEditMenuItem.setEnabled(false);
        this.allPrintFileMenuItem.setEnabled(bl);
    }

    private void updateTitleLine() {
        this.titleLine.setLength(9);
        if (this.session != null) {
            this.titleLine.append(" - ");
            if (this.session.getName() == null) {
                this.titleLine.append("unnamed");
            } else {
                this.titleLine.append(this.session.getName());
            }
        }
        this.setTitle(this.titleLine.toString());
    }

    private void initializeMenus() {
        MenuBar menuBar = new MenuBar();
        this.fileMenu.add(this.newFileMenuItem);
        this.fileMenu.add(this.openFileMenuItem);
        if (this.recallMenu == null) {
            this.recallMenu = new RecallMenu("Recall");
        }
        this.fileMenu.add(this.recallMenu);
        this.fileMenu.add(this.saveFileMenuItem);
        this.fileMenu.add(this.saveAsFileMenuItem);
        this.fileMenu.add(this.closeFileMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.compressFileMenuItem);
        this.fileMenu.addSeparator();
        this.printFileMenu.add(this.allPrintFileMenuItem);
        this.printFileMenu.add(this.markedPrintFileMenuItem);
        this.fileMenu.add(this.printFileMenu);
        this.fileMenu.addSeparator();
        if (this.options.isForceTabCompression() || this.options.isForceSpaceExpansion()) {
            this.compressFileMenuItem.setState(this.options.isForceTabCompression());
            this.compressFileMenuItem.setEnabled(false);
        }
        this.fileMenu.add(this.quitFileMenuItem);
        this.newFileMenuItem.addActionListener(this);
        this.openFileMenuItem.addActionListener(this);
        this.saveFileMenuItem.addActionListener(this);
        this.saveAsFileMenuItem.addActionListener(this);
        this.closeFileMenuItem.addActionListener(this);
        this.compressFileMenuItem.addItemListener(this);
        this.allPrintFileMenuItem.addActionListener(this);
        this.markedPrintFileMenuItem.addActionListener(this);
        this.quitFileMenuItem.addActionListener(this);
        this.newFileMenuItem.setShortcut(this.newShortcut);
        this.openFileMenuItem.setShortcut(this.openShortcut);
        this.saveFileMenuItem.setShortcut(this.saveShortcut);
        this.quitFileMenuItem.setShortcut(this.quitShortcut);
        this.closeFileMenuItem.setShortcut(this.closeShortcut);
        Menu menu = new Menu("Edit");
        menu.add(this.undoEditMenuItem);
        menu.add(this.copyEditMenuItem);
        menu.add(this.copyBufferEditMenuItem);
        menu.add(this.cutEditMenuItem);
        menu.add(this.pasteEditMenuItem);
        this.undoEditMenuItem.addActionListener(this);
        this.copyEditMenuItem.addActionListener(this);
        this.copyBufferEditMenuItem.addActionListener(this);
        this.cutEditMenuItem.addActionListener(this);
        this.pasteEditMenuItem.addActionListener(this);
        this.copyEditMenuItem.setShortcut(this.copyShortcut);
        this.cutEditMenuItem.setShortcut(this.cutShortcut);
        this.pasteEditMenuItem.setShortcut(this.pasteShortcut);
        this.undoEditMenuItem.setShortcut(this.undoShortcut);
        Menu menu2 = new Menu("Options");
        menu2.add(this.fontNameOptionMenu);
        String[] stringArray = null;
        try {
            Class.forName("java.awt.GraphicsEnvironment");
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        }
        catch (ClassNotFoundException classNotFoundException) {
            stringArray = this.getToolkit().getFontList();
        }
        int n = 0;
        while (n < stringArray.length) {
            this.fontNameOptionMenu.add(stringArray[n], false).addItemListener(this);
            ++n;
        }
        this.fontNameOptionMenu.selectItem(this.options.getFontName());
        menu2.add(this.fontPointOptionMenu);
        this.fontPointOptionMenu.add(8).addItemListener(this);
        this.fontPointOptionMenu.add(9).addItemListener(this);
        this.fontPointOptionMenu.add(10).addItemListener(this);
        this.fontPointOptionMenu.add(11).addItemListener(this);
        this.fontPointOptionMenu.add(12).addItemListener(this);
        this.fontPointOptionMenu.add(13).addItemListener(this);
        this.fontPointOptionMenu.add(14).addItemListener(this);
        this.fontPointOptionMenu.add(15).addItemListener(this);
        this.fontPointOptionMenu.add(16).addItemListener(this);
        this.fontPointOptionMenu.add(17).addItemListener(this);
        this.fontPointOptionMenu.add(18).addItemListener(this);
        this.fontPointOptionMenu.add(20).addItemListener(this);
        this.fontPointOptionMenu.add(24).addItemListener(this);
        this.fontPointOptionMenu.selectItem(this.options.getFontPoint());
        this.fontPointOptionMenu.addActionListener(this);
        menu2.add(this.fontBoldOptionMenuItem);
        this.fontBoldOptionMenuItem.setState(this.options.isFontBold());
        this.fontBoldOptionMenuItem.addItemListener(this);
        menu2.add(this.autoIndentOptionMenuItem);
        this.autoIndentOptionMenuItem.setState(this.options.isAutoIndent());
        this.autoIndentOptionMenuItem.addItemListener(this);
        menu2.add(this.backspaceTabOptionMenuItem);
        this.backspaceTabOptionMenuItem.setState(this.options.isBackspaceTab());
        this.backspaceTabOptionMenuItem.addItemListener(this);
        menu2.add(this.tabColumnOptionMenu);
        this.tabColumnOptionMenu.add(2).addItemListener(this);
        this.tabColumnOptionMenu.add(3).addItemListener(this);
        this.tabColumnOptionMenu.add(4).addItemListener(this);
        this.tabColumnOptionMenu.add(5).addItemListener(this);
        this.tabColumnOptionMenu.add(6).addItemListener(this);
        this.tabColumnOptionMenu.add(7).addItemListener(this);
        this.tabColumnOptionMenu.add(8).addItemListener(this);
        this.tabColumnOptionMenu.selectItem(this.options.getTabInterval());
        menu2.add(this.newFileDefaultFormatOptionMenu);
        this.newFileDefaultFormatOptionMenu.add(this.defaultSpaceExpansionOptionMenuItem);
        this.defaultSpaceExpansionOptionMenuItem.addItemListener(this);
        this.defaultSpaceExpansionOptionMenuItem.setState(!this.options.isDefaultTabCompression());
        this.newFileDefaultFormatOptionMenu.add(this.defaultTabCompressionOptionMenuItem);
        this.defaultTabCompressionOptionMenuItem.setState(this.options.isDefaultTabCompression());
        this.defaultTabCompressionOptionMenuItem.addItemListener(this);
        menu2.add(this.fileSaveFormatOptionMenu);
        this.fileSaveFormatOptionMenu.add(this.saveDefaultCompressionOptionMenuItem);
        this.fileSaveFormatOptionMenu.add(this.saveSpaceExpansionOptionMenuItem);
        this.fileSaveFormatOptionMenu.add(this.saveTabCompressionOptionMenuItem);
        this.saveDefaultCompressionOptionMenuItem.addItemListener(this);
        this.saveTabCompressionOptionMenuItem.addItemListener(this);
        this.saveSpaceExpansionOptionMenuItem.addItemListener(this);
        if (this.options.isForceTabCompression()) {
            this.setFileSaveFormat(this.saveTabCompressionOptionMenuItem);
        } else if (this.options.isForceSpaceExpansion()) {
            this.setFileSaveFormat(this.saveSpaceExpansionOptionMenuItem);
        } else {
            this.setFileSaveFormat(this.saveDefaultCompressionOptionMenuItem);
        }
        menu2.add(this.stripEolSpacesOptionMenuItem);
        this.stripEolSpacesOptionMenuItem.addItemListener(this);
        this.stripEolSpacesOptionMenuItem.setState(this.options.isStripEolSpaces());
        menu2.add(this.searchOptionMenu);
        this.searchOptionMenu.add(this.matchCaseSearchOptionMenuItem);
        this.matchCaseSearchOptionMenuItem.addItemListener(this);
        this.matchCaseSearchOptionMenuItem.setState(!this.options.isSearchCaseIndependent());
        menu2.add(this.cursorOptionMenu);
        this.cursorOptionMenu.add(this.eolIndependentCursorOptionMenuItem);
        this.eolIndependentCursorOptionMenuItem.addItemListener(this);
        this.eolIndependentCursorOptionMenuItem.setState(this.options.isEolIndependentCursor());
        menu2.add(this.colorOptionMenu);
        this.colorOptionMenu.add(this.textColorOptionRadioMenu);
        this.addColorMenuItems(this.textColorOptionRadioMenu, this.options.getTextColor());
        this.colorOptionMenu.add(this.backgroundColorOptionRadioMenu);
        this.addColorMenuItems(this.backgroundColorOptionRadioMenu, this.options.getBackgroundColor());
        menu2.add(this.commandLineOptionMenu);
        this.commandLineOptionMenu.add(this.fontBoldCommandLineOptionMenuItem);
        this.fontBoldCommandLineOptionMenuItem.setState(this.options.isCommandLineFontBold());
        this.fontBoldCommandLineOptionMenuItem.addItemListener(this);
        this.commandLineOptionMenu.add(this.fontPointCommandLineOptionMenu);
        this.fontPointCommandLineOptionMenu.add(8).addItemListener(this);
        this.fontPointCommandLineOptionMenu.add(9).addItemListener(this);
        this.fontPointCommandLineOptionMenu.add(10).addItemListener(this);
        this.fontPointCommandLineOptionMenu.add(11).addItemListener(this);
        this.fontPointCommandLineOptionMenu.add(12).addItemListener(this);
        this.fontPointCommandLineOptionMenu.add(13).addItemListener(this);
        this.fontPointCommandLineOptionMenu.add(14).addItemListener(this);
        this.fontPointCommandLineOptionMenu.add(15).addItemListener(this);
        this.fontPointCommandLineOptionMenu.add(16).addItemListener(this);
        this.fontPointCommandLineOptionMenu.add(17).addItemListener(this);
        this.fontPointCommandLineOptionMenu.add(18).addItemListener(this);
        this.fontPointCommandLineOptionMenu.add(20).addItemListener(this);
        this.fontPointCommandLineOptionMenu.add(24).addItemListener(this);
        this.fontPointCommandLineOptionMenu.selectItem(this.options.getCommandLineFontPoint());
        this.fontPointCommandLineOptionMenu.addActionListener(this);
        menu2.add(this.extensionOptionMenuItem);
        this.extensionOptionMenuItem.addActionListener(this);
        menu2.add(this.printOptionMenuItem);
        this.printOptionMenuItem.addActionListener(this);
        menu2.addSeparator();
        menu2.add(this.saveOptionMenuItem);
        this.saveOptionMenuItem.addActionListener(this);
        Menu menu3 = new Menu("Help");
        menu3.add(this.helpHelpMenuItem);
        menu3.add(this.aboutHelpMenuItem);
        menu3.add(this.registrationHelpMenuItem);
        this.helpHelpMenuItem.addActionListener(this);
        this.aboutHelpMenuItem.addActionListener(this);
        this.registrationHelpMenuItem.addActionListener(this);
        menuBar.add(this.fileMenu);
        menuBar.add(menu);
        menuBar.add(menu2);
        menuBar.add(menu3);
        this.setMenuBar(menuBar);
    }

    private void setFileSaveFormat(Object object) {
        boolean bl = false;
        boolean bl2 = false;
        if (object == this.saveDefaultCompressionOptionMenuItem) {
            this.saveDefaultCompressionOptionMenuItem.setState(true);
            this.compressFileMenuItem.setEnabled(true);
            if (this.session != null) {
                bl = this.session.isTabCompression();
                bl2 = true;
            }
        } else if (object == this.saveTabCompressionOptionMenuItem) {
            bl = true;
        }
        this.compressFileMenuItem.setEnabled(bl2);
        this.compressFileMenuItem.setState(bl);
        this.options.setForceSpaceExpansion(this.saveSpaceExpansionOptionMenuItem.getState());
        this.options.setForceTabCompression(this.saveTabCompressionOptionMenuItem.getState());
    }

    private void setFontPoint() {
        this.options.setFontPoint(this.fontPointOptionMenu.getValue());
        this.updateSessionOptions();
    }

    private void setCommandLineFontPoint() {
        this.options.setCommandLineFontPoint(this.fontPointCommandLineOptionMenu.getValue());
        this.setCommandLineFont();
    }

    private void setFontName() {
        this.options.setFontName(this.fontNameOptionMenu.getSelectedLabel());
        this.updateSessionOptions();
    }

    private void setBackgroundColor() {
        this.options.setBackgroundColor(this.backgroundColorOptionRadioMenu.getSelectedLabel());
        this.updateSessionOptions();
    }

    private void setTextColor() {
        this.options.setTextColor(this.textColorOptionRadioMenu.getSelectedLabel());
        this.updateSessionOptions();
    }

    private void setTabColumn() {
        this.options.setTabInterval(this.tabColumnOptionMenu.getValue());
        this.updateSessionOptions();
    }

    public void editSessionQuit() {
        this.closeSession(true);
    }

    public void editSessionQuit(boolean bl) {
        this.closeSession(bl);
    }

    public void editSessionMarkAreaSetEnabled(boolean bl) {
        this.copyEditMenuItem.setEnabled(bl);
        this.cutEditMenuItem.setEnabled(bl);
        this.markedPrintFileMenuItem.setEnabled(bl);
    }

    public void codeQuillExit(boolean bl) {
        if (!bl) {
            this.sessionList.push();
            this.sessionList.first();
            EditSession editSession = (EditSession)this.sessionList.get();
            while (editSession != null) {
                if (editSession.isModified()) {
                    this.sessionList.pop();
                    ExitClient exitClient = new ExitClient(this, this, this.sessionList);
                    EditSession editSession2 = exitClient.getEditSession();
                    if (editSession2 != null) {
                        this.setSession(editSession2);
                    } else {
                        this.setCurrentSessionFocus();
                    }
                    return;
                }
                editSession = (EditSession)this.sessionList.getNext();
            }
            this.sessionList.pop();
        }
        if (this.session != null) {
            this.session.disableCursor();
        }
        this.saveCodeQuill();
        ((Component)this).setVisible(false);
        System.exit(0);
    }

    public void editSessionEdit(String string) {
        this.openSession(string);
    }

    public void editSessionSetFileName(String string) {
        this.updateTitleLine();
        this.setSessionMenu();
    }

    public boolean overwriteFile(String string) {
        if (this.session.write(string, true) != '\u0000') {
            this.postMessage("Could not write to file");
            return false;
        }
        return true;
    }

    public void editSessionInformationMessage(String string) {
        this.postMessage(string);
    }

    private void setCommandLineFont() {
        Font font = this.options.isCommandLineFontBold() ? new Font(this.options.getCommandLineFontName(), 1, this.options.getCommandLineFontPoint()) : new Font(this.options.getCommandLineFontName(), 0, this.options.getCommandLineFontPoint());
        this.commandLine.setFont(font);
        this.commandLine.invalidate();
    }

    private boolean processCommandLine(String string) {
        String string2;
        String string3;
        if (string.length() > 0 && string.charAt(0) == ':') {
            string = string.substring(1);
            string = string.trim();
        }
        boolean bl = true;
        int n = string.indexOf(" ");
        if (n != -1) {
            string3 = string.substring(0, n);
            string2 = string.substring(n);
            string2 = string2.trim();
        } else {
            string3 = string;
            string2 = "";
        }
        switch (this.commandMgr.getCommand(string3)) {
            case '\u0001': {
                if (this.checkOpenFileLimit()) break;
                EditSession editSession = this.getUnnamedUnmodifiedSession();
                if (editSession == null) {
                    editSession = new EditSession(this, this, this.syntaxMetaMgr, this.bufferMgr, this.options, this.informationBar, this.searchMgr);
                    if (editSession != null) {
                        this.sessionList.append(editSession);
                        editSession.addKeyListener(this);
                        this.nextSession();
                        this.setSessionMenu();
                        break;
                    }
                    this.informationBar.setMessage("Could not create a new session");
                    break;
                }
                this.setSession(editSession);
                this.setSessionMenu();
                break;
            }
            case '\u0002': {
                if (string2.length() != 0) {
                    this.openSession(string2);
                    break;
                }
                this.informationBar.setMessage("Edit requests a file name.");
                break;
            }
            case '\u0003': {
                this.informationBar.setMessage("Version not implemented");
                break;
            }
            default: {
                this.informationBar.setMessage("Command not supported");
            }
        }
        return bl;
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.setCurrentSessionFocus();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.codeQuillExit(false);
    }

    private void setupCommands() {
        this.commandMgr.addCommand("new", '\u0001');
        this.commandMgr.addCommand("edit", '\u0002');
        this.commandMgr.addCommand("version", '\u0003');
    }

    private boolean checkOpenFileLimit() {
        if (this.sessionList.getSize() >= 6) {
            String[] stringArray = new String[]{"CodeQuill is limited to six open files"};
            CqMessageDialog cqMessageDialog = new CqMessageDialog((Frame)this, "CodeQuill Open File Limit", stringArray);
            cqMessageDialog.setVisible(true);
            cqMessageDialog.dispose();
            this.setCurrentSessionFocus();
            return true;
        }
        return false;
    }

    private void restoreCodeQuill() {
        Object object;
        String[] stringArray = null;
        String string = null;
        Dimension dimension = null;
        Point point = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("user.home"));
        stringBuffer.append(System.getProperty("file.separator"));
        stringBuffer.append(".cqobject");
        if (!new File(stringBuffer.toString()).exists()) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(System.getProperty("user.home"));
            stringBuffer.append(System.getProperty("file.separator"));
            stringBuffer.append("cqobject.ini");
        }
        this.cqobjectFileName = stringBuffer.toString();
        try {
            object = new FileInputStream(this.cqobjectFileName);
            ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
            this.cqObjectFormatId = (Integer)objectInputStream.readObject();
            string = (String)objectInputStream.readObject();
            this.registered = (Boolean)objectInputStream.readObject();
            this.licenseNumber = (String)objectInputStream.readObject();
            dimension = (Dimension)objectInputStream.readObject();
            point = (Point)objectInputStream.readObject();
            stringArray = (String[])objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.getToolkit().getScreenSize();
        if (dimension != null) {
            if (object != null) {
                if (dimension.width > ((Dimension)object).width) {
                    dimension.width = ((Dimension)object).width;
                }
                if (dimension.height > ((Dimension)object).height) {
                    dimension.height = ((Dimension)object).height;
                }
            }
            this.windowStartSize = dimension;
        }
        if (point != null) {
            if (object != null) {
                if (point.x + dimension.width > ((Dimension)object).width) {
                    point.x = ((Dimension)object).width - dimension.width;
                }
                if (point.y + dimension.height > ((Dimension)object).height) {
                    point.y = ((Dimension)object).height - dimension.height;
                }
                if (point.x < 0) {
                    point.x = 0;
                }
                if (point.y < 0) {
                    point.y = 0;
                }
            }
            ((Component)this).setLocation(point);
        }
        if (stringArray != null) {
            this.recallMenu = new RecallMenu("Recall", stringArray, this);
        }
    }

    private void saveCodeQuill() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.cqobjectFileName);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.cqObjectFormatId);
            objectOutputStream.writeObject(this.version);
            objectOutputStream.writeObject(new Boolean(this.registered));
            objectOutputStream.writeObject(this.licenseNumber);
            objectOutputStream.writeObject(this.getSize());
            objectOutputStream.writeObject(this.getLocationOnScreen());
            objectOutputStream.writeObject(this.recallMenu.getList());
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkRegistration() {
        if (!this.registered) {
            String[] stringArray = new String[]{"CodeQuill", "Unregistered version " + this.version, "Copyright (c) 1999 Sonoran Software Guild, Inc.", "All rights reserved.", "View registration information?"};
            DecisionDialog decisionDialog = new DecisionDialog((Frame)this, "Unregistered CodeQuill", stringArray, true);
            decisionDialog.setVisible(true);
            if (decisionDialog.getDecision()) {
                decisionDialog.dispose();
                Registration registration = new Registration((Frame)this, "CodeQuill registration", this.registered);
                registration.setVisible(true);
                registration.dispose();
            } else {
                decisionDialog.dispose();
            }
        }
    }

    private void addColorMenuItems(RadioMenu radioMenu, String string) {
        boolean bl = false;
        radioMenu.add("Default", false).addItemListener(this);
        radioMenu.add("Black", false).addItemListener(this);
        radioMenu.add("White", false).addItemListener(this);
        radioMenu.add("Gray", false).addItemListener(this);
        radioMenu.add("Light gray", false).addItemListener(this);
        radioMenu.add("Dark gray", false).addItemListener(this);
        radioMenu.add("Blue", false).addItemListener(this);
        radioMenu.add("Cyan", false).addItemListener(this);
        radioMenu.add("Green", false).addItemListener(this);
        radioMenu.add("Yellow", false).addItemListener(this);
        radioMenu.add("Orange", false).addItemListener(this);
        radioMenu.add("Pink", false).addItemListener(this);
        radioMenu.add("Red", false).addItemListener(this);
        radioMenu.add("Magenta", false).addItemListener(this);
        radioMenu.selectItem(string);
    }

    private Dimension getStartSize() {
        return this.windowStartSize;
    }

    private Point getStartLocation() {
        return this.windowStartLocation;
    }
}

