/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.NewProjectDialog;
import com.xrefactory.jedit.Opt;
import com.xrefactory.jedit.Options;
import com.xrefactory.jedit.PathSelectionDialog;
import com.xrefactory.jedit.XrefTaskForTagFile;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.gjt.sp.jedit.jEdit;

public class OptionsForProjectsDialog
extends JDialog {
    void init(JFrame parent, boolean newProject) {
        try {
            Options.OptionParser parser = new Options.OptionParser(new File(s.configurationFile));
            Options[] xrefrc = parser.parseFile();
            String defaultProject = "None (Automatic Project Detection)";
            if (!newProject) {
                defaultProject = s.activeProject;
            }
            OptionsForProjectsSelfStandingPanel op = new OptionsForProjectsSelfStandingPanel(xrefrc, defaultProject, parent);
            this.setContentPane(op);
            this.pack();
            this.setSize(600, 400);
            this.setLocationRelativeTo(parent);
            if (newProject) {
                boolean created = op.panel.addNewProject(parent);
                if (created) {
                    this.setVisible(true);
                }
            } else {
                this.setVisible(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public OptionsForProjectsDialog(JFrame parent) {
        super(parent);
        this.init(parent, false);
    }

    public OptionsForProjectsDialog(JFrame parent, boolean newProject) {
        super(parent);
        this.init(parent, newProject);
    }

    public static class OptionsForProjectsSelfStandingPanel
    extends JPanel {
        ProjectOptionsPanel panel;

        OptionsForProjectsSelfStandingPanel(Options[] xrefrc, String defaultp, Component parent) {
            int y = -1;
            JComponent[] buttons = new JButton[]{new ButtonCancel(), new ButtonSave(), new ButtonClose()};
            this.setLayout(new GridBagLayout());
            this.panel = new ProjectOptionsPanel(xrefrc, defaultp);
            s.addGbcComponent(this, 0, ++y, 1, 1, 10, 10, 2, new JPanel());
            s.addGbcComponent(this, 0, ++y, 1, 1, 1000, 1000, 1, this.panel);
            s.addGbcComponent(this, 0, ++y, 1, 1, 10, 10, 2, new JPanel());
            s.addExtraButtonLine(this, 0, ++y, 1, 1, 1, 1, buttons, true);
        }

        class ButtonClose
        extends JButton
        implements ActionListener {
            ButtonClose() {
                super("Continue");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                OptionsForProjectsSelfStandingPanel.this.panel.saveProjectSettings();
                s.getProbableParent(this).setVisible(false);
            }
        }

        class ButtonSave
        extends JButton
        implements ActionListener {
            ButtonSave() {
                super("Save");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                OptionsForProjectsSelfStandingPanel.this.panel.saveProjectSettings();
            }
        }

        class ButtonCancel
        extends JButton
        implements ActionListener {
            ButtonCancel() {
                super("Cancel");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                s.getProbableParent(this).setVisible(false);
            }
        }
    }

    public static class ProjectOptionsPanel
    extends JPanel {
        JTextField configurationFile;
        OptionsForProjectsPanel optionsPanel;
        JComboBox activeProject;
        JTabbedPane projectsPanel;
        Options[] projects;
        Options[] originalProjects;
        int opy;

        void saveProjectSettings() {
            this.checkConfigurationFile();
            if (this.checkOptionsConsistency()) {
                Options.saveOptions(this.projects, s.configurationFile);
                this.checkProjectsModifications();
                this.originalProjects = ProjectOptionsPanel.crOptionsArrayCopy(this.projects);
                Opt.setActiveProject((String)this.activeProject.getSelectedItem());
            }
        }

        public void checkConfigurationFile() {
            if (!s.configurationFile.equals(this.configurationFile.getText())) {
                jEdit.setProperty((String)"xrefactory.configuration-file.prop", (String)this.configurationFile.getText());
                JOptionPane.showMessageDialog((Component)s.view, "You have to restart jEdit in order to use new Xrefactory configuration file.", "Xrefactory Message", 1);
            }
        }

        public boolean addNewProject(Component parent) {
            NewProjectDialog nn;
            if (parent instanceof Dialog) {
                nn = new NewProjectDialog((Dialog)parent, this.projects);
            } else if (parent instanceof Frame) {
                nn = new NewProjectDialog((Frame)parent, this.projects);
            } else {
                nn = null;
                s.assertt(false);
            }
            NewProjectDialog.NewProjectPanel pp = (NewProjectDialog.NewProjectPanel)nn.getContentPane();
            if (!pp.projectName.getText().equals("")) {
                Options[] no = new Options[this.projects.length + 1];
                System.arraycopy(this.projects, 0, no, 0, this.projects.length);
                no[this.projects.length] = new Options(pp.projectName.getText(), pp.sourceDirectory.getText());
                no[this.projects.length].addNewProjectOptions(pp.projectName.getText(), pp.sourceDirectory.getText(), pp.classPath.getText(), pp.sourcePath.getText());
                this.projects = no;
                int i = this.projects.length - 1;
                this.projectsPanel.add(this.projects[i].projectName, new OptionsForProjectsPanel(this.projects[i], 2, Opt.optionsEditingDisplaysFile));
                this.projectsPanel.setSelectedIndex(i);
                this.activeProject.addItem(this.projects[i].projectName);
                JOptionPane.showMessageDialog(parent, "New project was created. Please verify that remaining options are correctly set.\nIn particular that Jdk runtime library is the file storing your jdk classes (usualy rt.jar)");
                if (pp.makeActive.isSelected()) {
                    Opt.setActiveProject(pp.projectName.getText());
                }
                return true;
            }
            return false;
        }

        public boolean checkOptionsConsistency() {
            int i = 0;
            while (i < this.projects.length) {
                int j = i + 1;
                while (j < this.projects.length) {
                    Options.PathIterator ii = new Options.PathIterator(this.projects[i].getProjectAutoDetectionOpt(), s.classPathSeparator);
                    while (ii.hasNext()) {
                        String cpi = ii.next();
                        Options.PathIterator ji = new Options.PathIterator(this.projects[j].getProjectAutoDetectionOpt(), s.classPathSeparator);
                        while (ji.hasNext()) {
                            String cpj = ji.next();
                            if (!Options.projectMarkersOverlapps(cpi, cpj)) continue;
                            int rr = JOptionPane.showOptionDialog(s.getProbableParent(this), "Conflict between projects " + this.projects[i].projectName + " and " + this.projects[j].projectName + ".\nProjects overlap in auto detection paths: " + cpi + " and " + cpj, "Configuration File Problem", 0, 0, null, new String[]{"Quit without saving", "Ignore this problem and save", "Ignore all problems and save"}, null);
                            if (rr == 0) {
                                return false;
                            }
                            if (rr != 2) continue;
                            return true;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            return true;
        }

        public void recreateTagFile(Options o) {
            DispatchData ndata = new DispatchData(s.xbTask, (Component)this);
            s.activeProject = o.projectName;
            XrefTaskForTagFile.runXrefOnTagFile("-create", "Creating Tags.", true, ndata);
        }

        public void checkProjectsModifications() {
            int i = 0;
            while (i < this.projects.length) {
                int j = 0;
                while (j < this.originalProjects.length) {
                    if (this.projects[i].projectName.equals(this.originalProjects[j].projectName)) break;
                    ++j;
                }
                if (j == this.originalProjects.length) {
                    int confirm = JOptionPane.showConfirmDialog(s.getProbableParent(this), "Project " + this.projects[i].projectName + " added. Can I create Tags for it?", "Xrefactory Confirmation", 0, 3);
                    if (confirm == 0) {
                        this.recreateTagFile(this.projects[i]);
                    }
                } else {
                    int confirm;
                    Options newopt = this.projects[i];
                    Options oldopt = this.originalProjects[j];
                    int k = 0;
                    while (k < newopt.optioni) {
                        if (newopt.option[k].option.recreateTagsIfModified && !oldopt.contains(newopt.option[k])) break;
                        ++k;
                    }
                    if (k != newopt.optioni && (confirm = JOptionPane.showConfirmDialog(s.getProbableParent(this), "Options in project " + newopt.projectName + " changed. Recreate Tags?", "Xrefactory Confirmation", 0, 3)) == 0) {
                        this.recreateTagFile(newopt);
                    }
                }
                ++i;
            }
        }

        public static Options[] crOptionsArrayCopy(Options[] oo) {
            Options[] res = new Options[oo.length];
            int i = 0;
            while (i < oo.length) {
                res[i] = new Options(oo[i]);
                ++i;
            }
            return res;
        }

        void activeProjectListRefresh(ComboBoxModel model) {
            int n = model.getSize();
            String[] projects = new String[n];
            projects[0] = "None (Automatic Project Detection)";
            int i = 1;
            while (i < n) {
                projects[i] = (String)model.getElementAt(i);
                ++i;
            }
            this.activeProject.setModel(new DefaultComboBoxModel<String>(projects));
        }

        public ProjectOptionsPanel(Options[] projects, String defaultp) {
            int y = -1;
            this.projects = projects;
            this.originalProjects = ProjectOptionsPanel.crOptionsArrayCopy(projects);
            this.configurationFile = new JTextField(s.configurationFile);
            this.activeProject = new JComboBox<String>(Options.getProjectNames(projects, "None (Automatic Project Detection)"));
            this.activeProject.setSelectedItem(Opt.activeProject());
            this.projectsPanel = new JTabbedPane();
            this.projectsPanel.add("Common options", new OptionsForProjectsPanel(projects[0], 1, Opt.optionsEditingDisplaysFile));
            int i = 1;
            while (i < projects.length) {
                this.projectsPanel.add(projects[i].projectName, new OptionsForProjectsPanel(projects[i], 2, Opt.optionsEditingDisplaysFile));
                if (projects[i].projectName.equals(defaultp)) {
                    this.projectsPanel.setSelectedIndex(i);
                }
                ++i;
            }
            this.setLayout(new GridBagLayout());
            s.addGbcComponent(this, 0, ++y, 1, 1, 10, 1, 2, new JPanel());
            s.addGbcComponent(this, 1, y, 1, 1, 10, 1, 2, new JLabel("Store options in the file: ", 4));
            s.addGbcComponent(this, 2, y, 1, 1, 1, 1, 2, this.configurationFile);
            s.addGbcComponent(this, 2, y, 1, 1, 100, 1, 2, new JPanel());
            s.addGbcComponent(this, 4, y, 1, 1, 1, 1, 2, new ButtonNewProject());
            s.addGbcComponent(this, 5, y, 1, 1, 10, 1, 2, new JPanel());
            s.addGbcComponent(this, 0, ++y, 1, 1, 10, 1, 2, new JPanel());
            s.addGbcComponent(this, 1, y, 1, 1, 10, 1, 2, new JLabel("Active Project: ", 4));
            s.addGbcComponent(this, 2, y, 1, 1, 1, 1, 2, this.activeProject);
            s.addGbcComponent(this, 3, y, 1, 1, 100, 1, 2, new JPanel());
            s.addGbcComponent(this, 4, y, 1, 1, 1, 1, 2, new ButtonDelProject());
            s.addGbcComponent(this, 5, y, 1, 1, 10, 1, 2, new JPanel());
            s.addGbcComponent(this, 0, ++y, 1, 1, 10, 1, 2, new JPanel());
            s.addGbcComponent(this, 1, y, 4, 1, 1000, 1000, 1, this.projectsPanel);
            s.addGbcComponent(this, 5, y, 1, 1, 10, 1, 2, new JPanel());
        }

        class ConfigurationFileListener
        implements FocusListener {
            ConfigurationFileListener() {
            }

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
            }
        }

        class ButtonDelProject
        extends JButton
        implements ActionListener {
            ButtonDelProject() {
                super("Del");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                int i = ProjectOptionsPanel.this.projectsPanel.getSelectedIndex();
                if (i == 0) {
                    JOptionPane.showMessageDialog(s.getProbableParent(this), "This project can not be deleted");
                } else {
                    int confirm = 0;
                    confirm = JOptionPane.showConfirmDialog(s.getProbableParent(this), "Really delete project " + ProjectOptionsPanel.this.projectsPanel.getTitleAt(ProjectOptionsPanel.this.projectsPanel.getSelectedIndex()), "Confirmation", 0, 3);
                    if (confirm == 0 && i > 0) {
                        Object[] no = new Options[ProjectOptionsPanel.this.projects.length - 1];
                        s.arrayCopyDelElement(ProjectOptionsPanel.this.projects, no, i);
                        ProjectOptionsPanel.this.projects = no;
                        if (ProjectOptionsPanel.this.activeProject.getSelectedIndex() == i) {
                            ProjectOptionsPanel.this.activeProject.setSelectedIndex(0);
                        }
                        ProjectOptionsPanel.this.activeProject.removeItemAt(i);
                        ProjectOptionsPanel.this.projectsPanel.removeTabAt(i);
                        if (i < no.length) {
                            ProjectOptionsPanel.this.projectsPanel.setSelectedIndex(i);
                        } else {
                            ProjectOptionsPanel.this.projectsPanel.setSelectedIndex(no.length - 1);
                        }
                    }
                }
            }
        }

        class ButtonNewProject
        extends JButton
        implements ActionListener {
            ButtonNewProject() {
                super("Add");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                ProjectOptionsPanel.this.addNewProject(s.getProbableParent(this));
            }
        }
    }

    public static class OptionsForProjectsPanel
    extends JPanel {
        boolean displayString;
        Options options;
        int kind;
        JTextArea stringOption;
        OptionsForProjectsNoFilePanel optionsPanel;

        public void addOptionsPanel() {
            s.addGbcComponent(this, 0, 0, 1, 1, 10000, 10000, 1, this.optionsPanel);
        }

        void updateStringOption() {
            int cp = this.stringOption.getCaretPosition();
            this.stringOption.setText(this.options.toString());
            this.stringOption.setCaretPosition(cp);
        }

        public void updateOptionsFromOptionsString() {
            block2: {
                try {
                    Options.OptionParser pp = new Options.OptionParser(this.stringOption.getText());
                    pp.reParseSingleProject(this.options);
                    this.remove(this.optionsPanel);
                    this.optionsPanel = new OptionsForProjectsNoFilePanel(this.options, this.kind);
                    this.addOptionsPanel();
                    this.revalidate();
                }
                catch (Exception ee) {
                    JOptionPane.showMessageDialog(s.getParentDialog(this.stringOption), ee, "Xrefactory Error", 0);
                    if (!s.debug) break block2;
                    ee.printStackTrace(System.err);
                }
            }
        }

        public OptionsForProjectsPanel(Options options, int kind, boolean displayString) {
            JComponent disp;
            int y = -1;
            this.displayString = displayString;
            this.options = options;
            this.kind = kind;
            this.optionsPanel = new OptionsForProjectsNoFilePanel(options, kind);
            this.stringOption = new JTextArea(options.toString());
            this.stringOption.addFocusListener(new StringOptionFocusListener());
            this.stringOption.addKeyListener(new StringOptionKeyListener());
            this.setLayout(new GridBagLayout());
            this.addOptionsPanel();
            if (displayString) {
                JScrollPane sp = new JScrollPane(this.stringOption);
                sp.setMinimumSize(new Dimension(100, 80));
                sp.setPreferredSize(new Dimension(300, 200));
                disp = sp;
            } else {
                disp = new JPanel();
            }
            s.addGbcComponent(this, 0, 1, 1, 1, 100, 5000, 1, disp);
        }

        class StringOptionKeyListener
        implements KeyListener {
            StringOptionKeyListener() {
            }

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    OptionsForProjectsPanel.this.stringOption.insert("\n", OptionsForProjectsPanel.this.stringOption.getCaretPosition());
                    OptionsForProjectsPanel.this.updateOptionsFromOptionsString();
                    e.consume();
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        }

        class StringOptionFocusListener
        implements FocusListener {
            StringOptionFocusListener() {
            }

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                OptionsForProjectsPanel.this.updateOptionsFromOptionsString();
                OptionsForProjectsPanel.this.updateStringOption();
            }
        }

        class OptionsForProjectsNoFilePanel
        extends JPanel {
            OptionsForProjectsNoFilePanel(Options options, int kind) {
                int y = -1;
                this.setLayout(new GridBagLayout());
                ++y;
                int i = 0;
                while (i < Options.allOptions.length) {
                    Options.OptionDescription od = Options.allOptions[i];
                    if (od.interactive && (kind == od.kind || od.kind == 3)) {
                        Options.Option oo = null;
                        int j = 0;
                        while (j < options.optioni) {
                            Options.Option o = options.option[j];
                            if (o.option == od) {
                                oo = o;
                            }
                            ++j;
                        }
                        GraphicOption go = new GraphicOption(od, oo);
                        s.addGbcComponent(this, 0, y++, 1, 1, 10000, 10000, 2, go);
                    }
                    ++i;
                }
            }

            class GraphicOption
            extends Container {
                Options.Option option;
                JCheckBox jb;
                JTextField tf;
                ButtonBrowse bb;

                void checkBoxChanged() {
                    if (this.jb.isSelected()) {
                        ((OptionsForProjectsNoFilePanel)OptionsForProjectsNoFilePanel.this).OptionsForProjectsPanel.this.options.add(this.option);
                    } else {
                        ((OptionsForProjectsNoFilePanel)OptionsForProjectsNoFilePanel.this).OptionsForProjectsPanel.this.options.delete(this.option);
                    }
                    OptionsForProjectsPanel.this.updateStringOption();
                }

                void updateAndSelectCheckBox() {
                    String val = this.tf.getText();
                    if (this.jb.isSelected()) {
                        int index = ((OptionsForProjectsNoFilePanel)OptionsForProjectsNoFilePanel.this).OptionsForProjectsPanel.this.options.delete(this.option);
                        this.option.fulltext[1] = this.tf.getText();
                        if (val.equals("")) {
                            this.jb.setSelected(false);
                        } else {
                            ((OptionsForProjectsNoFilePanel)OptionsForProjectsNoFilePanel.this).OptionsForProjectsPanel.this.options.add(this.option, index);
                        }
                        OptionsForProjectsPanel.this.updateStringOption();
                    } else {
                        this.option.fulltext[1] = val;
                        if (!val.equals("")) {
                            this.jb.setSelected(true);
                            this.checkBoxChanged();
                        }
                    }
                    this.update(val);
                    if (!this.jb.isSelected() && !val.equals("")) {
                        this.jb.setSelected(true);
                        this.checkBoxChanged();
                    }
                }

                public void update(String newText) {
                    if (this.jb.isSelected()) {
                        int index = ((OptionsForProjectsNoFilePanel)OptionsForProjectsNoFilePanel.this).OptionsForProjectsPanel.this.options.delete(this.option);
                        this.option.fulltext[1] = this.tf.getText();
                        ((OptionsForProjectsNoFilePanel)OptionsForProjectsNoFilePanel.this).OptionsForProjectsPanel.this.options.add(this.option, index);
                        OptionsForProjectsPanel.this.updateStringOption();
                    } else {
                        this.option.fulltext[1] = this.tf.getText();
                    }
                }

                GraphicOption(Options.OptionDescription opt, Options.Option option) {
                    this.option = option == null ? new Options.Option(opt, "") : option;
                    this.setLayout(new BoxLayout(this, 0));
                    if (opt.arity == 1) {
                        this.jb = new JCheckBox(opt.shortDescription);
                        this.jb.addActionListener(new checkBoxActionListener());
                        this.add(this.jb);
                    } else {
                        this.jb = new JCheckBox();
                        this.add(new JLabel(opt.shortDescription));
                    }
                    if (option != null) {
                        this.jb.setSelected(true);
                    }
                    if (opt.arity > 1) {
                        s.assertt(opt.arity == 2);
                        this.tf = new JTextField(this.option.fulltext[1]);
                        this.tf.setPreferredSize(new Dimension(300, 20));
                        this.add(this.tf);
                        this.tf.addFocusListener(new TextFieldFocusListener());
                        this.tf.addKeyListener(new TextFieldKeyListener());
                    }
                    if (opt.fileSystemBrowseOptions != null) {
                        this.bb = new ButtonBrowse();
                        this.bb.browseMode = opt.fileSystemBrowseOptions;
                        this.add(this.bb);
                    }
                }

                class TextFieldFocusListener
                implements FocusListener {
                    TextFieldFocusListener() {
                    }

                    public void focusGained(FocusEvent e) {
                    }

                    public void focusLost(FocusEvent e) {
                        GraphicOption.this.updateAndSelectCheckBox();
                    }
                }

                class TextFieldKeyListener
                implements KeyListener {
                    TextFieldKeyListener() {
                    }

                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            GraphicOption.this.updateAndSelectCheckBox();
                            e.consume();
                        }
                    }

                    public void keyReleased(KeyEvent e) {
                    }

                    public void keyTyped(KeyEvent e) {
                    }
                }

                class checkBoxActionListener
                implements ActionListener {
                    checkBoxActionListener() {
                    }

                    public void actionPerformed(ActionEvent e) {
                        GraphicOption.this.checkBoxChanged();
                    }
                }

                class ButtonBrowse
                extends JButton
                implements ActionListener {
                    String browseMode;

                    ButtonBrowse() {
                        super("Browse");
                        this.setToolTipText("Browse");
                        this.setFont(s.optionsBrowseButtonFont);
                        this.addActionListener(this);
                    }

                    public void actionPerformed(ActionEvent e) {
                        String mm = this.browseMode.toLowerCase();
                        if (mm.equals("d") || mm.equals("f") || mm.equals("fd")) {
                            JFileChooser fc = new JFileChooser();
                            int mode = mm.equals("d") ? 1 : (mm.equals("f") ? 0 : 2);
                            fc.setFileSelectionMode(mode);
                            fc.setApproveButtonText("Select");
                            int i = fc.showOpenDialog(s.getParentDialog(this));
                            GraphicOption.this.tf.setText(fc.getSelectedFile().getPath());
                        } else if (mm.equals("p")) {
                            PathSelectionDialog np = new PathSelectionDialog(s.getParentDialog(this), GraphicOption.this.tf.getText());
                            GraphicOption.this.tf.setText(np.resultString);
                        }
                        GraphicOption.this.updateAndSelectCheckBox();
                    }
                }
            }
        }
    }
}

