/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.wfxml;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.components.wfxml.DefInfo;
import org.enhydra.jawe.components.wfxml.DefInfos;
import org.enhydra.jxpdl.elements.Package;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WfXMLConnector {
    private static final String REQUEST_METHOD = "POST";
    private static final String HRP_ACCEPT_NAME = "Accept";
    private static final String HTTP_ACCEPT_VALUE = "application/soap+xml, text/*";
    private static final String HRP_USER_AGENT_NAME = "User-Agent";
    private static final String HRP_CACHE_CONTROL_NAME = "Cache-Control";
    private static final String HRP_PRAGMA_NAME = "Pragma";
    private static final String HRP_CONTENT_TYPE_NAME = "Content-Type";
    private static final String HRP_SOAP_ACTION = "SOAPAction";
    private static final String HRP_USER_AGENT_VALUE = "JaWE/1.4.2";
    private static final String HRP_CACHE_CONTROL_VALUE = "no-cache";
    private static final String HRP_PRAGMA_VALUE = "no-cache";
    private static final String HRP_CONTENT_TYPE_VALUE = "text/xml; charset=utf-8";
    private static final String REQUEST_HEADER = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Header><as:Request xmlns:as=\"http://www.oasis-open.org/asap/0.9/asap.xsd\"><as:SenderKey>http://jawe.objectweb.org/</as:SenderKey><as:ReceiverKey>${1}</as:ReceiverKey></as:Request></soapenv:Header>";

    public static void main(String[] stringArray) {
        try {
            URL uRL = new URL("http://grunf:8080/axis/services/wfxmlRegistryBinding");
            WfXMLConnector.wfxmlSetDefinition(uRL, "/tmp/asap_test.xpdl");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static boolean wfxmlSetDefinition(URL uRL, String string) throws Exception {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        PrintWriter printWriter = WfXMLConnector.openConnection(httpURLConnection, "http://www.wfmc.org/wfxml/2.0/wfxml/factory/SetDefinition");
        FileReader fileReader = new FileReader(string);
        printWriter.println("<soapenv:Body><SetDefinitionRq xmlns=\"http://www.wfmc.org/wfxml/2.0/\"><ProcessLanguage>XPDL</ProcessLanguage><Definition>");
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        bufferedReader.readLine();
        while (bufferedReader.ready()) {
            printWriter.println(bufferedReader.readLine());
        }
        printWriter.println("</Definition></SetDefinitionRq></soapenv:Body></soapenv:Envelope>");
        printWriter.flush();
        bufferedReader.close();
        fileReader.close();
        httpURLConnection.connect();
        int n = httpURLConnection.getResponseCode();
        printWriter.close();
        httpURLConnection.disconnect();
        return WfXMLConnector.isResponse2XX(n);
    }

    public static void wfxmlSetDefinition2(URL uRL, String string) throws Exception {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        PrintWriter printWriter = WfXMLConnector.openConnection(httpURLConnection, "http://www.wfmc.org/wfxml/2.0/wfxml/factory/SetDefinition");
        printWriter.println("<soapenv:Body><SetDefinitionRq xmlns=\"http://www.wfmc.org/wfxml/2.0/\"><ProcessLanguage>XPDL</ProcessLanguage><Definition>");
        printWriter.println(string);
        printWriter.println("</Definition></SetDefinitionRq></soapenv:Body></soapenv:Envelope>");
        printWriter.flush();
        httpURLConnection.connect();
        int n = httpURLConnection.getResponseCode();
        printWriter.close();
        httpURLConnection.disconnect();
        if (!WfXMLConnector.isResponse2XX(n)) {
            throw new Exception("Invalid response " + n);
        }
    }

    public static boolean wfxmlNewDefinition(URL uRL, String string) throws Exception {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        PrintWriter printWriter = WfXMLConnector.openConnection(httpURLConnection, "http://www.wfmc.org/wfxml/2.0/wfxml/registry/NewDefinition");
        FileReader fileReader = new FileReader(string);
        printWriter.println("<soapenv:Body><NewDefinitionRq xmlns=\"http://www.wfmc.org/wfxml/2.0/\"><ProcessLanguage>XPDL</ProcessLanguage><Definition>");
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        bufferedReader.readLine();
        while (bufferedReader.ready()) {
            printWriter.println(bufferedReader.readLine());
        }
        printWriter.println("</Definition></NewDefinitionRq></soapenv:Body></soapenv:Envelope>");
        printWriter.flush();
        bufferedReader.close();
        fileReader.close();
        httpURLConnection.connect();
        int n = httpURLConnection.getResponseCode();
        printWriter.close();
        httpURLConnection.disconnect();
        return WfXMLConnector.isResponse2XX(n);
    }

    public static void wfxmlNewDefinition2(URL uRL, String string) throws Exception {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        PrintWriter printWriter = WfXMLConnector.openConnection(httpURLConnection, "http://www.wfmc.org/wfxml/2.0/wfxml/registry/NewDefinition");
        printWriter.println("<soapenv:Body><NewDefinitionRq xmlns=\"http://www.wfmc.org/wfxml/2.0/\"><ProcessLanguage>XPDL</ProcessLanguage><Definition>");
        printWriter.println(string);
        printWriter.println("</Definition></NewDefinitionRq></soapenv:Body></soapenv:Envelope>");
        printWriter.flush();
        httpURLConnection.connect();
        int n = httpURLConnection.getResponseCode();
        printWriter.close();
        httpURLConnection.disconnect();
        if (!WfXMLConnector.isResponse2XX(n)) {
            throw new Exception("Invalid response " + n);
        }
    }

    public static Node wfxmlGetDefinition(URL uRL) throws Exception {
        Node node = null;
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        PrintWriter printWriter = WfXMLConnector.openConnection(httpURLConnection, "http://www.wfmc.org/wfxml/2.0/wfxml/factory/GetDefinition");
        printWriter.println("<soapenv:Body><GetDefinitionRq xmlns=\"http://www.wfmc.org/wfxml/2.0/\"><ProcessLanguage>XPDL</ProcessLanguage></GetDefinitionRq></soapenv:Body></soapenv:Envelope>");
        printWriter.flush();
        httpURLConnection.connect();
        int n = httpURLConnection.getResponseCode();
        httpURLConnection.getContentLength();
        if (WfXMLConnector.isResponse2XX(n)) {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(httpURLConnection.getInputStream());
            System.err.println(document.getNodeName());
            System.err.println(document.getFirstChild().getNodeName());
            System.err.println(document.getFirstChild().getLastChild().getFirstChild().getFirstChild());
            node = document.getFirstChild().getLastChild().getFirstChild().getFirstChild();
            printWriter.close();
            httpURLConnection.disconnect();
            return node;
        }
        printWriter.close();
        httpURLConnection.disconnect();
        throw new Exception("Invalid response " + n);
    }

    public static String wfxmlGetDefinition2(URL uRL) throws Exception {
        Node node = WfXMLConnector.wfxmlGetDefinition(uRL);
        return WfXMLConnector.node2String(node);
    }

    public static List wfxmlListDefinitions(URL uRL) throws Exception {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        PrintWriter printWriter = WfXMLConnector.openConnection(httpURLConnection, "http://www.wfmc.org/wfxml/2.0/wfxml/factory/ListDefinitions");
        printWriter.println("<soapenv:Body><ListDefinitionsRq xmlns=\"http://www.wfmc.org/wfxml/2.0/\"/></soapenv:Body> </soapenv:Envelope>");
        printWriter.flush();
        httpURLConnection.connect();
        int n = httpURLConnection.getResponseCode();
        if (WfXMLConnector.isResponse2XX(n)) {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(httpURLConnection.getInputStream());
            NodeList nodeList = document.getFirstChild().getLastChild().getFirstChild().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                arrayList.add(new URL(nodeList.item(i).getFirstChild().getFirstChild().getNodeValue()));
            }
            return arrayList;
        }
        throw new Exception("Invalid response " + n);
    }

    public static List wfxmlListDefinitions(URL uRL, DefInfos defInfos) throws Exception {
        ArrayList<DefInfo> arrayList = new ArrayList<DefInfo>();
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        PrintWriter printWriter = WfXMLConnector.openConnection(httpURLConnection, "http://www.wfmc.org/wfxml/2.0/wfxml/factory/ListDefinitions");
        printWriter.println("<soapenv:Body><ListDefinitionsRq xmlns=\"http://www.wfmc.org/wfxml/2.0/\"/></soapenv:Body> </soapenv:Envelope>");
        printWriter.flush();
        httpURLConnection.connect();
        int n = httpURLConnection.getResponseCode();
        if (WfXMLConnector.isResponse2XX(n)) {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(httpURLConnection.getInputStream());
            NodeList nodeList = document.getFirstChild().getLastChild().getFirstChild().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NodeList nodeList2 = nodeList.item(i).getChildNodes();
                String string = nodeList2.item(0).getFirstChild().getNodeValue();
                String string2 = "";
                if (nodeList2.item(1).getFirstChild() != null) {
                    string2 = nodeList2.item(1).getFirstChild().getNodeValue();
                }
                String string3 = "";
                if (nodeList2.item(2).getFirstChild() != null) {
                    string3 = nodeList2.item(2).getFirstChild().getNodeValue();
                }
                String string4 = "";
                if (nodeList2.item(3).getFirstChild() != null) {
                    string4 = nodeList2.item(3).getFirstChild().getNodeValue();
                }
                String string5 = "";
                if (nodeList2.item(4).getFirstChild() != null) {
                    string5 = nodeList2.item(4).getFirstChild().getNodeValue();
                }
                DefInfo defInfo = (DefInfo)defInfos.generateNewElement();
                defInfo.setDefinitionKey(string);
                defInfo.setName(string2);
                defInfo.setDescription(string3);
                defInfo.setVersion(string4);
                defInfo.setStatus(string5);
                arrayList.add(defInfo);
            }
            return arrayList;
        }
        throw new Exception("Invalid response " + n);
    }

    public static String xpdlToString(Package package_) throws Exception {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        document = documentBuilder.newDocument();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JaWEManager.getInstance().getXPDLHandler().getXPDLRepositoryHandler().toXML(document, package_);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("encoding", JaWEManager.getInstance().getJaWEController().getControllerSettings().getEncoding());
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        transformer.transform(dOMSource, streamResult);
        String string = byteArrayOutputStream.toString();
        byteArrayOutputStream.close();
        return string;
    }

    public static String node2String(Node node) throws Exception {
        byte[] byArray = WfXMLConnector.node2Bytes(node);
        String string = new String(byArray, JaWEManager.getInstance().getJaWEController().getControllerSettings().getEncoding());
        return string;
    }

    public static byte[] node2Bytes(Node node) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("encoding", JaWEManager.getInstance().getJaWEController().getControllerSettings().getEncoding());
        DOMSource dOMSource = new DOMSource(node);
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        transformer.transform(dOMSource, streamResult);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray;
    }

    private static PrintWriter openConnection(HttpURLConnection httpURLConnection, String string) throws Exception {
        httpURLConnection.setRequestMethod(REQUEST_METHOD);
        httpURLConnection.addRequestProperty(HRP_ACCEPT_NAME, HTTP_ACCEPT_VALUE);
        httpURLConnection.addRequestProperty(HRP_USER_AGENT_NAME, HRP_USER_AGENT_VALUE);
        httpURLConnection.addRequestProperty(HRP_CACHE_CONTROL_NAME, "no-cache");
        httpURLConnection.addRequestProperty(HRP_PRAGMA_NAME, "no-cache");
        httpURLConnection.addRequestProperty(HRP_CONTENT_TYPE_NAME, HRP_CONTENT_TYPE_VALUE);
        httpURLConnection.addRequestProperty(HRP_SOAP_ACTION, string);
        httpURLConnection.setDoOutput(true);
        String string2 = REQUEST_HEADER.replaceFirst("\\$\\{1\\}", httpURLConnection.getURL().toString());
        PrintWriter printWriter = new PrintWriter(httpURLConnection.getOutputStream());
        printWriter.println(string2);
        return printWriter;
    }

    private static boolean isResponse2XX(int n) {
        return 202 == n || 200 == n || 201 == n;
    }

    public static void listNodes(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            System.out.println(string + "i=" + i + ", n=" + node2.getClass().getName() + ", v=" + node2.getNodeValue());
            WfXMLConnector.listNodes(node2, string + " ");
        }
    }

    static {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        });
    }
}

