/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph.jped;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Section;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.enhydra.jawe.components.graph.Graph;
import org.enhydra.jawe.components.graph.jped.PDFDocumentChain;
import org.enhydra.jawe.components.graph.jped.PDFElementChain;
import org.enhydra.jawe.components.graph.jped.PDFPlugin;
import org.enhydra.jawe.components.graph.jped.PDFSectionChain;
import org.enhydra.jxpdl.XMLElement;

public class PDFPluginNotifier {
    private Logger log = Logger.getLogger(PDFPluginNotifier.class.getName());
    private PDFPlugin[] pluginInterfaces = new PDFPlugin[]{new PDFPlugin()};
    private Section enclosingSection;

    public PDFPluginNotifier() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("there are " + this.pluginInterfaces.length + " pdf plugins");
            for (int i = 0; i < this.pluginInterfaces.length; ++i) {
                this.log.fine("plugins[" + i + "]=" + this.pluginInterfaces[i]);
            }
        }
    }

    public Document processDocument(XMLElement xMLElement, Graph graph, OutputStream outputStream) throws DocumentException {
        PDFDocumentChain pDFDocumentChain = null;
        for (int i = this.pluginInterfaces.length - 1; i >= 0; --i) {
            pDFDocumentChain = new PDFDocumentChain(xMLElement, graph, outputStream, this.pluginInterfaces[i], this, pDFDocumentChain);
        }
        Document document = pDFDocumentChain.processPlugin();
        return document;
    }

    public Section processSection(XMLElement xMLElement) throws DocumentException {
        PDFSectionChain pDFSectionChain = null;
        for (int i = this.pluginInterfaces.length - 1; i >= 0; --i) {
            pDFSectionChain = new PDFSectionChain(xMLElement, this.pluginInterfaces[i], this, pDFSectionChain);
        }
        Section section = pDFSectionChain.processPlugin();
        return section;
    }

    public Element processElement(XMLElement xMLElement) throws DocumentException {
        PDFElementChain pDFElementChain = null;
        for (int i = this.pluginInterfaces.length - 1; i >= 0; --i) {
            pDFElementChain = new PDFElementChain(xMLElement, this.pluginInterfaces[i], this, pDFElementChain);
        }
        Element element = pDFElementChain.processPlugin();
        return element;
    }

    public Section getEnclosingSection() {
        return this.enclosingSection;
    }

    public void setEnclosingSection(Section section) {
        this.enclosingSection = section;
    }
}

