/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.infobar;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.enhydra.jawe.ChoiceButton;
import org.enhydra.jawe.ChoiceButtonListener;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.base.controller.JaWESelectionManager;
import org.enhydra.jawe.base.xpdlhandler.XPDLHandler;
import org.enhydra.jawe.components.infobar.InfoBar;
import org.enhydra.jawe.components.infobar.InfoBarSettings;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.WorkflowProcess;

public class InfoBarController
implements JaWEComponent,
Observer,
ChoiceButtonListener {
    protected String type = "UPPER_STATUS";
    protected boolean updateInProgress = false;
    protected InfoBarSettings settings;
    protected InfoBar panel;

    public InfoBarController(JaWEComponentSettings jaWEComponentSettings) throws Exception {
        this.settings = (InfoBarSettings)jaWEComponentSettings;
        this.settings.init(this);
        this.init();
        JaWEManager.getInstance().getJaWEController().addObserver((Observer)this);
    }

    public JaWEComponentSettings getSettings() {
        return this.settings;
    }

    public InfoBarSettings getInfoBarSettings() {
        return this.settings;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!(object instanceof XPDLElementChangeInfo)) {
            return;
        }
        XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)object;
        int n = xPDLElementChangeInfo.getAction();
        if (n != 1 && n != 3 && n != 5 && n != 8 && n != 15 && n != 16 && n != 17) {
            return;
        }
        long l = System.currentTimeMillis();
        JaWEManager.getInstance().getLoggingManager().info("InfoBarController -> update for event " + xPDLElementChangeInfo + " started ...");
        JaWESelectionManager jaWESelectionManager = JaWEManager.getInstance().getJaWEController().getSelectionManager();
        if (jaWESelectionManager.getWorkingPKG() != null) {
            this.panel.setPackageName(jaWESelectionManager.getWorkingPKG());
            this.panel.setProcessName(jaWESelectionManager.getWorkingProcess());
        } else {
            this.panel.setPackageName(null);
            this.panel.setProcessName(null);
        }
        this.panel.setFileName(JaWEManager.getInstance().getXPDLHandler().getAbsoluteFilePath(jaWESelectionManager.getWorkingPKG()));
        JaWEManager.getInstance().getLoggingManager().info("InfoBarController -> update ended");
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        JaWEManager.getInstance().getLoggingManager().debug("THE UPDATE OF InfoBar COMPONENT LASTED FOR " + d + " SECONDS!");
    }

    protected void init() {
        this.panel = new InfoBar(this);
        this.panel.configure();
        this.panel.init();
    }

    public JaWEComponentView getView() {
        return this.panel;
    }

    public String getComponentType() {
        return this.type;
    }

    public void setComponentType(String string) {
        this.type = string;
    }

    public String getName() {
        return "InfoBar";
    }

    public boolean adjustXPDL(Package package_) {
        return false;
    }

    public List checkValidity(XMLElement xMLElement, boolean bl) {
        return null;
    }

    public boolean canCreateElement(XMLCollection xMLCollection) {
        return true;
    }

    public boolean canInsertElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canModifyElement(XMLElement xMLElement) {
        return true;
    }

    public boolean canRemoveElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canDuplicateElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canRepositionElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public void selectionChanged(ChoiceButton choiceButton, Object object) {
        JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection((XMLElement)object, true);
    }

    public Object getSelectedObject(ChoiceButton choiceButton) {
        if (choiceButton.getChoiceType() == Package.class) {
            return JaWEManager.getInstance().getJaWEController().getSelectionManager().getWorkingPKG();
        }
        if (choiceButton.getChoiceType() == WorkflowProcess.class) {
            return JaWEManager.getInstance().getJaWEController().getSelectionManager().getWorkingProcess();
        }
        return null;
    }

    public List getChoices(ChoiceButton choiceButton) {
        ArrayList arrayList = new ArrayList();
        XPDLHandler xPDLHandler = JaWEManager.getInstance().getXPDLHandler();
        if (choiceButton.getChoiceType() == Package.class) {
            arrayList.addAll(xPDLHandler.getAllPackages());
        } else if (choiceButton.getChoiceType().equals(WorkflowProcess.class) && JaWEManager.getInstance().getJaWEController().getSelectionManager().getWorkingPKG() != null) {
            arrayList.addAll(JaWEManager.getInstance().getJaWEController().getSelectionManager().getWorkingPKG().getWorkflowProcesses().toElements());
        }
        return arrayList;
    }

    public void setUpdateInProgress(boolean bl) {
        this.updateInProgress = bl;
    }

    public boolean isUpdateInProgress() {
        return this.updateInProgress;
    }
}

