/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jxpdl;

import java.io.File;

public class Path {
    public static final char SEPARATOR = '/';
    public static final char DEVICE_SEPARATOR = ':';
    private String[] segments;
    private String device = null;
    private int separators;
    private static final int HAS_LEADING = 1;
    private static final int IS_UNC = 2;
    private static final int HAS_TRAILING = 4;
    private static final int ALL_SEPARATORS = 7;
    private static final String[] NO_SEGMENTS = new String[0];
    private static final String ROOT_STRING = "/";
    public static final Path ROOT = new Path("/");
    private static final String EMPTY_STRING = "";
    public static final Path EMPTY = new Path("");

    private Path(String string, String[] stringArray, int n) {
        this.segments = stringArray;
        this.device = string;
        this.separators = this.computeHashCode() << 3 | n & 7;
    }

    public Path(String string) {
        this.initialize(null, string);
    }

    public Path(String string, String string2) {
        this.initialize(string, string2);
    }

    private boolean canonicalize() {
        for (String string : this.segments) {
            if (string.charAt(0) != '.' || !string.equals("..") && !string.equals(".")) continue;
            this.collapseParentReferences();
            if (this.segments.length == 0) {
                this.separators &= 3;
            }
            this.separators = this.separators & 7 | this.computeHashCode() << 3;
            return true;
        }
        return false;
    }

    private void collapseParentReferences() {
        int n = this.segments.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = this.segments[i];
            if (string.equals("..")) {
                if (n2 == 0) {
                    if (this.isAbsolute()) continue;
                    stringArray[n2++] = string;
                    continue;
                }
                if ("..".equals(stringArray[n2 - 1])) {
                    stringArray[n2++] = "..";
                    continue;
                }
                --n2;
                continue;
            }
            if (string.equals(".") && (i != 0 || this.isAbsolute())) continue;
            stringArray[n2++] = string;
        }
        if (n2 == n) {
            return;
        }
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        this.segments = stringArray2;
    }

    private String collapseSlashes(String string) {
        int n = string.length();
        if (n < 3) {
            return string;
        }
        if (string.indexOf("//", 1) == -1) {
            return string;
        }
        char[] cArray = new char[string.length()];
        int n2 = 0;
        boolean bl = false;
        char[] cArray2 = string.toCharArray();
        for (int i = 0; i < cArray2.length; ++i) {
            char c = cArray2[i];
            if (c == '/') {
                if (bl) {
                    if (this.device != null || i != 1) continue;
                    cArray[n2] = c;
                    ++n2;
                    continue;
                }
                bl = true;
                cArray[n2] = c;
                ++n2;
                continue;
            }
            bl = false;
            cArray[n2] = c;
            ++n2;
        }
        return new String(cArray, 0, n2);
    }

    private int computeHashCode() {
        int n = this.device == null ? 17 : this.device.hashCode();
        int n2 = this.segments.length;
        for (int i = 0; i < n2; ++i) {
            n = n * 37 + this.segments[i].hashCode();
        }
        return n;
    }

    private int computeLength() {
        int n;
        int n2 = 0;
        if (this.device != null) {
            n2 += this.device.length();
        }
        if ((this.separators & 1) != 0) {
            ++n2;
        }
        if ((this.separators & 2) != 0) {
            ++n2;
        }
        if ((n = this.segments.length) > 0) {
            for (int i = 0; i < n; ++i) {
                n2 += this.segments[i].length();
            }
            n2 += n - 1;
        }
        if ((this.separators & 4) != 0) {
            ++n2;
        }
        return n2;
    }

    private int computeSegmentCount(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0 || n2 == 1 && string.charAt(0) == '/') {
            return 0;
        }
        int n3 = 1;
        int n4 = -1;
        while ((n = string.indexOf(47, n4 + 1)) != -1) {
            if (n != n4 + 1 && n != n2) {
                ++n3;
            }
            n4 = n;
        }
        if (string.charAt(n2 - 1) == '/') {
            --n3;
        }
        return n3;
    }

    private String[] computeSegments(String string) {
        int n;
        int n2 = this.computeSegmentCount(string);
        if (n2 == 0) {
            return NO_SEGMENTS;
        }
        String[] stringArray = new String[n2];
        int n3 = string.length();
        int n4 = n = string.charAt(0) == '/' ? 1 : 0;
        if (n == 1 && n3 > 1 && string.charAt(1) == '/') {
            n = 2;
        }
        int n5 = string.charAt(n3 - 1) != '/' ? n3 - 1 : n3 - 2;
        int n6 = n;
        for (int i = 0; i < n2; ++i) {
            int n7 = n6;
            int n8 = string.indexOf(47, n6);
            stringArray[i] = n8 == -1 ? string.substring(n7, n5 + 1) : string.substring(n7, n8);
            n6 = n8 + 1;
        }
        return stringArray;
    }

    private void initialize(String string, String string2) {
        int n;
        if (string2 == null) {
            throw new RuntimeException();
        }
        this.device = string;
        String string3 = string2.indexOf(92) == -1 ? string2 : string2.replace('\\', '/');
        int n2 = string3.indexOf(58);
        if (n2 != -1) {
            if (string == null) {
                this.device = string3.substring(0, n2 + 1);
            }
            string3 = string3.substring(n2 + 1, string3.length());
        }
        if ((n = (string3 = this.collapseSlashes(string3)).length()) < 2) {
            this.separators = n == 1 && string3.charAt(0) == '/' ? 1 : 0;
        } else {
            boolean bl = string3.charAt(0) == '/';
            boolean bl2 = bl && string3.charAt(1) == '/';
            boolean bl3 = (!bl2 || n != 2) && string3.charAt(n - 1) == '/';
            int n3 = this.separators = bl ? 1 : 0;
            if (bl2) {
                this.separators |= 2;
            }
            if (bl3) {
                this.separators |= 4;
            }
        }
        this.segments = this.computeSegments(string3);
        if (!this.canonicalize()) {
            this.separators = this.separators & 7 | this.computeHashCode() << 3;
        }
    }

    public boolean isAbsolute() {
        return (this.separators & 1) != 0;
    }

    public int matchingFirstSegments(Path path) {
        if (path == null) {
            throw new RuntimeException();
        }
        int n = path.segmentCount();
        int n2 = Math.min(this.segments.length, n);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!this.segments[i].equals(path.segment(i))) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    public String segment(int n) {
        if (n >= this.segments.length) {
            return null;
        }
        return this.segments[n];
    }

    public int segmentCount() {
        return this.segments.length;
    }

    public String[] segments() {
        String[] stringArray = new String[this.segments.length];
        System.arraycopy(this.segments, 0, stringArray, 0, this.segments.length);
        return stringArray;
    }

    public Path setDevice(String string) {
        if (string != null && string.indexOf(58) != string.length() - 1) {
            throw new RuntimeException("Last character should be the device separator");
        }
        if (string == this.device || string != null && string.equals(this.device)) {
            return this;
        }
        return new Path(string, this.segments, this.separators);
    }

    public String toOSString() {
        int n;
        int n2 = this.computeLength();
        if (n2 <= 0) {
            return EMPTY_STRING;
        }
        char c = File.separatorChar;
        char[] cArray = new char[n2];
        int n3 = 0;
        if (this.device != null) {
            n = this.device.length();
            this.device.getChars(0, n, cArray, n3);
            n3 += n;
        }
        if ((this.separators & 1) != 0) {
            cArray[n3++] = c;
        }
        if ((this.separators & 2) != 0) {
            cArray[n3++] = c;
        }
        if ((n = this.segments.length - 1) >= 0) {
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                int n5 = this.segments[n4].length();
                this.segments[n4].getChars(0, n5, cArray, n3);
                n3 += n5;
                cArray[n3++] = c;
            }
            n4 = this.segments[n].length();
            this.segments[n].getChars(0, n4, cArray, n3);
            n3 += n4;
        }
        if ((this.separators & 4) != 0) {
            cArray[n3++] = c;
        }
        return new String(cArray);
    }

    public static String getRelativePath(Path path, Path path2) {
        if (path2 == null || !Path.hasSameDevice(path, path2)) {
            return path.toOSString();
        }
        int n = path2.matchingFirstSegments(path);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = path2.segmentCount() - n; i > 0; --i) {
            stringBuffer.append("..");
            stringBuffer.append(File.separatorChar);
        }
        int n2 = path.segmentCount();
        for (int i = n; i < n2; ++i) {
            if (i > n) {
                stringBuffer.append(File.separatorChar);
            }
            stringBuffer.append(path.segment(i));
        }
        return stringBuffer.toString();
    }

    private static boolean hasSameDevice(Path path, Path path2) {
        String string = path.device;
        if (string == null) {
            return path2.device == null;
        }
        return string.equals(path2.device);
    }
}

