/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jxpdl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;

public class XMLAttribute
extends XMLElement {
    protected ArrayList choices;
    protected int defaultChoiceIndex;

    public XMLAttribute(XMLElement xMLElement, String string, boolean bl) {
        super(xMLElement, string, bl);
    }

    public XMLAttribute(XMLElement xMLElement, String string, boolean bl, String[] stringArray, int n) {
        super(xMLElement, string, bl);
        this.choices = new ArrayList<String>(Arrays.asList(stringArray));
        this.value = stringArray[n];
        this.defaultChoiceIndex = n;
    }

    @Override
    public void setValue(String string) {
        if (this.choices != null && !this.choices.contains(string)) {
            throw new RuntimeException("Incorrect value " + string + " for attribute " + this.toName() + "! Possible values are: " + this.choices);
        }
        if (this.choices == null) {
            string = XMLUtil.replaceLFwithCRLF(string);
        }
        super.setValue(string);
    }

    public ArrayList getChoices() {
        return this.choices;
    }

    public String getDefaultChoice() {
        return (String)this.choices.get(this.defaultChoiceIndex);
    }

    public int getDefaultChoiceIndex() {
        return this.defaultChoiceIndex;
    }

    @Override
    public Object clone() {
        XMLAttribute xMLAttribute = (XMLAttribute)super.clone();
        if (this.choices != null) {
            xMLAttribute.choices = new ArrayList();
            Iterator iterator = this.choices.iterator();
            while (iterator.hasNext()) {
                xMLAttribute.choices.add(new String(iterator.next().toString()));
            }
        }
        return xMLAttribute;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = super.equals(object);
        if (bl) {
            XMLAttribute xMLAttribute = (XMLAttribute)object;
            bl = this.choices == null ? xMLAttribute.choices == null : this.choices.equals(xMLAttribute.choices);
        }
        return bl;
    }
}

