/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jxpdl;

import java.util.ArrayList;
import org.enhydra.jxpdl.XMLComplexChoice;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLInterface;
import org.enhydra.jxpdl.utilities.SequencedHashMap;

public abstract class XMLBaseForCollectionAndComplex
extends XMLElement {
    protected SequencedHashMap elementMap;
    protected ArrayList elements = new ArrayList();
    protected transient boolean cachesInitialized = false;

    public XMLBaseForCollectionAndComplex(XMLElement xMLElement, boolean bl) {
        super(xMLElement, bl);
        this.elementMap = new SequencedHashMap();
    }

    public XMLBaseForCollectionAndComplex(XMLElement xMLElement, boolean bl, boolean bl2) {
        super(xMLElement, bl, bl2);
        this.elementMap = new SequencedHashMap();
    }

    public XMLBaseForCollectionAndComplex(XMLElement xMLElement, String string, boolean bl) {
        super(xMLElement, string, bl);
        this.elementMap = new SequencedHashMap();
    }

    @Override
    public void setValue(String string) {
        throw new RuntimeException("Can't set value for this type of element!");
    }

    @Override
    public void removeXPDL1Support() {
        super.removeXPDL1Support();
        for (XMLElement xMLElement : this.elements) {
            xMLElement.removeXPDL1Support();
        }
    }

    @Override
    public void setReadOnly(boolean bl) {
        super.setReadOnly(bl);
        for (XMLElement xMLElement : this.elements) {
            xMLElement.setReadOnly(bl);
        }
        if (!bl) {
            this.clearCaches();
        }
    }

    @Override
    public void setNotifyMainListeners(boolean bl) {
        super.setNotifyMainListeners(bl);
        for (XMLElement xMLElement : this.elements) {
            xMLElement.setNotifyMainListeners(bl);
        }
    }

    @Override
    public void setNotifyListeners(boolean bl) {
        super.setNotifyListeners(bl);
        for (XMLElement xMLElement : this.elements) {
            xMLElement.setNotifyListeners(bl);
        }
    }

    public void initCaches(XMLInterface xMLInterface) {
        if (!this.isReadOnly) {
            throw new RuntimeException(this.toName() + ": Caches can be initialized only in read-only mode!");
        }
        this.clearCaches();
        for (XMLElement xMLElement : this.elements) {
            if (xMLElement instanceof XMLBaseForCollectionAndComplex) {
                ((XMLBaseForCollectionAndComplex)xMLElement).initCaches(xMLInterface);
                continue;
            }
            if (!(xMLElement instanceof XMLComplexChoice)) continue;
            ((XMLComplexChoice)xMLElement).initCaches(xMLInterface);
        }
        this.cachesInitialized = true;
    }

    public void clearCaches() {
        for (XMLElement xMLElement : this.elements) {
            if (xMLElement instanceof XMLBaseForCollectionAndComplex) {
                ((XMLBaseForCollectionAndComplex)xMLElement).clearCaches();
                continue;
            }
            if (!(xMLElement instanceof XMLComplexChoice)) continue;
            ((XMLComplexChoice)xMLElement).clearCaches();
        }
        this.cachesInitialized = false;
    }

    protected abstract void add(XMLElement var1);

    protected abstract boolean add(int var1, XMLElement var2);

    public boolean contains(XMLElement xMLElement) {
        return this.elements.contains(xMLElement);
    }

    public XMLElement get(int n) {
        if (n < 0 || n >= this.size()) {
            throw new RuntimeException("There is no element at position " + n + "!");
        }
        return (XMLElement)this.elements.get(n);
    }

    public int size() {
        return this.elements.size();
    }

    public ArrayList toElements() {
        return new ArrayList(this.elements);
    }

    public SequencedHashMap toElementMap() {
        return new SequencedHashMap(this.elementMap);
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = super.equals(object);
        if (bl) {
            XMLBaseForCollectionAndComplex xMLBaseForCollectionAndComplex = (XMLBaseForCollectionAndComplex)object;
            bl = this.elements.equals(xMLBaseForCollectionAndComplex.elements);
        }
        return bl;
    }
}

