/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jxpdl;

import java.util.ArrayList;
import java.util.Iterator;
import org.enhydra.jxpdl.XMLAttribute;
import org.enhydra.jxpdl.XMLBaseForCollectionAndComplex;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.utilities.SequencedHashMap;

public abstract class XMLComplexElement
extends XMLBaseForCollectionAndComplex {
    public XMLComplexElement(XMLElement xMLElement, boolean bl) {
        super(xMLElement, bl);
        this.fillStructure();
    }

    public XMLComplexElement(XMLElement xMLElement, boolean bl, boolean bl2) {
        super(xMLElement, bl, bl2);
        this.fillStructure();
    }

    public XMLComplexElement(XMLElement xMLElement, String string, boolean bl) {
        super(xMLElement, string, bl);
        this.fillStructure();
    }

    @Override
    public void makeAs(XMLElement xMLElement) {
        if (xMLElement == null || !xMLElement.getClass().equals(this.getClass()) || !xMLElement.toName().equals(this.toName())) {
            throw new RuntimeException("Can't perform makeAs! Element[" + xMLElement + "," + xMLElement.getClass() + "|" + this.getClass() + "," + xMLElement.toName() + "|" + this.toName() + "]");
        }
        this.xpdl1support = ((XMLComplexElement)xMLElement).xpdl1support;
        XMLComplexElement xMLComplexElement = (XMLComplexElement)xMLElement;
        Iterator iterator = this.elements.iterator();
        Iterator iterator2 = xMLComplexElement.elements.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            XMLElement xMLElement3 = (XMLElement)iterator2.next();
            xMLElement2.makeAs(xMLElement3);
        }
    }

    @Override
    protected void add(XMLElement xMLElement) {
        this.elements.add(xMLElement);
        this.elementMap.put(xMLElement.toName(), xMLElement);
    }

    @Override
    protected boolean add(int n, XMLElement xMLElement) {
        if (n < 0 || n > this.size()) {
            return false;
        }
        this.elements.add(n, xMLElement);
        this.elementMap.put(xMLElement.toName(), xMLElement);
        return true;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = true;
        for (XMLElement xMLElement : this.elements) {
            bl = bl && xMLElement.isEmpty();
        }
        bl = bl && this.value.trim().length() == 0;
        return bl;
    }

    public ArrayList getXMLElements() {
        ArrayList arrayList = new ArrayList();
        for (Object e : this.elements) {
            if (e instanceof XMLAttribute) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public ArrayList getXMLAttributes() {
        ArrayList arrayList = new ArrayList();
        for (Object e : this.elements) {
            if (!(e instanceof XMLAttribute)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public void set(String string, String string2) {
        if (this.isReadOnly) {
            throw new RuntimeException("Can't change element from read only structure!");
        }
        XMLElement xMLElement = this.get(string);
        if (xMLElement == null) {
            throw new RuntimeException("No such element!");
        }
        xMLElement.setValue(string2);
    }

    public boolean set(int n, String string) {
        if (n < 0 || n >= this.size()) {
            return false;
        }
        if (this.isReadOnly) {
            throw new RuntimeException("Can't change element from read only structure!");
        }
        XMLElement xMLElement = this.get(n);
        xMLElement.setValue(string);
        return true;
    }

    public XMLElement get(String string) {
        return (XMLElement)this.elementMap.get(string);
    }

    public boolean containsName(String string) {
        return this.elementMap.containsKey(string);
    }

    protected abstract void fillStructure();

    @Override
    public Object clone() {
        XMLComplexElement xMLComplexElement = (XMLComplexElement)super.clone();
        xMLComplexElement.elements = new ArrayList();
        xMLComplexElement.elementMap = new SequencedHashMap();
        xMLComplexElement.cachesInitialized = false;
        for (XMLElement xMLElement : this.elements) {
            XMLElement xMLElement2 = (XMLElement)xMLElement.clone();
            xMLElement2.setParent(xMLComplexElement);
            xMLComplexElement.elements.add(xMLElement2);
            xMLComplexElement.elementMap.put(xMLElement2.toName(), xMLElement2);
        }
        return xMLComplexElement;
    }
}

