/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jxpdl;

import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.xerces.parsers.DOMParser;
import org.enhydra.jxpdl.ParsingErrors;
import org.enhydra.jxpdl.XMLInterface;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.XPDLEntityResolver;
import org.enhydra.jxpdl.XPDLRepositoryHandler;
import org.enhydra.jxpdl.elements.ExternalPackage;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.utilities.SequencedHashMap;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class XMLInterfaceImpl
implements XMLInterface {
    protected Map idToPackages = new SequencedHashMap();
    protected Map xmlFileToPackage = new SequencedHashMap();
    protected Map packageToParentDirectory = new SequencedHashMap();
    protected String mainPackageReference;
    protected Map parsingErrorMessages = new SequencedHashMap();
    protected boolean isValidationON = true;
    protected XPDLRepositoryHandler xpdlRep = null;
    protected Locale locale = Locale.getDefault();

    @Override
    public void setValidation(boolean bl) {
        this.isValidationON = bl;
    }

    @Override
    public void clearParserErrorMessages() {
        this.parsingErrorMessages.clear();
    }

    @Override
    public synchronized boolean isPackageOpened(String string) {
        return this.idToPackages.containsKey(string);
    }

    @Override
    public synchronized Package getPackageById(String string) {
        ArrayList arrayList = (ArrayList)this.idToPackages.get(string);
        Package package_ = null;
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            int n = -1;
            while (iterator.hasNext()) {
                Package package_2 = (Package)iterator.next();
                String string2 = package_2.getInternalVersion();
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n2 < n) continue;
                n = n2;
                package_ = package_2;
            }
            if (package_ == null && arrayList.size() > 0) {
                package_ = (Package)arrayList.get(arrayList.size() - 1);
            }
        }
        return package_;
    }

    @Override
    public synchronized Package getPackageByIdAndVersion(String string, String string2) {
        ArrayList arrayList = (ArrayList)this.idToPackages.get(string);
        Package package_ = null;
        if (arrayList != null) {
            for (Package package_2 : arrayList) {
                String string3 = package_2.getInternalVersion();
                if (!string3.equals(string2)) continue;
                package_ = package_2;
                break;
            }
        }
        return package_;
    }

    @Override
    public synchronized Package getPackageByFilename(String string) {
        string = XMLUtil.getCanonicalPath(string, "", false);
        return (Package)this.xmlFileToPackage.get(string);
    }

    @Override
    public synchronized Package getExternalPackageByRelativeFilePath(String string, Package package_) {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.getParentDirectory(package_) + File.separator + string);
        }
        if (file.exists()) {
            return this.getPackageByFilename(file.getAbsolutePath());
        }
        return null;
    }

    @Override
    public synchronized String getAbsoluteFilePath(Package package_) {
        Iterator iterator = this.xmlFileToPackage.entrySet().iterator();
        String string = null;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            Package package_2 = (Package)entry.getValue();
            if (!package_2.equals(package_)) continue;
            string = string2;
            break;
        }
        return string;
    }

    @Override
    public synchronized Collection getAllPackages() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.idToPackages.values().iterator();
        while (iterator.hasNext()) {
            arrayList.addAll((ArrayList)iterator.next());
        }
        return arrayList;
    }

    @Override
    public synchronized Collection getAllPackageIds() {
        return this.idToPackages.keySet();
    }

    @Override
    public Collection getAllPackageVersions(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = (ArrayList)this.idToPackages.get(string);
        if (arrayList2 != null) {
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                arrayList.add(((Package)iterator.next()).getInternalVersion());
            }
        }
        return arrayList;
    }

    @Override
    public synchronized Collection getAllPackageFilenames() {
        return this.xmlFileToPackage.keySet();
    }

    @Override
    public synchronized boolean doesPackageFileExists(String string) {
        return new File(string).exists();
    }

    @Override
    public synchronized String getParentDirectory(Package package_) {
        return (String)this.packageToParentDirectory.get(package_);
    }

    @Override
    public Package openPackage(String string, boolean bl) {
        this.parsingErrorMessages.clear();
        this.mainPackageReference = string;
        Package package_ = this.openPackageRecursively(string, bl);
        return package_;
    }

    public void printDebug() {
        System.out.println("idToPackage=" + this.idToPackages);
        System.out.println("xmlFileToPackage=" + this.xmlFileToPackage);
        System.out.println("packageToWorkingDirectory=" + this.packageToParentDirectory);
    }

    protected Package openPackageRecursively(String string, boolean bl) {
        Package package_ = null;
        File file = null;
        String string2 = string;
        String string3 = null;
        if ((string = XMLUtil.getCanonicalPath(string, "", false)) == null) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("File does not exist");
            this.parsingErrorMessages.put(string2, hashSet);
            return null;
        }
        file = new File(string);
        try {
            string3 = file.getParentFile().getCanonicalPath();
        }
        catch (Exception exception) {
            string3 = file.getParentFile().getAbsolutePath();
        }
        if (this.xmlFileToPackage.containsKey(string)) {
            return this.getPackageByFilename(string);
        }
        package_ = this.parseDocument(string, true);
        if (package_ != null) {
            String string4 = package_.getId();
            if (this.idToPackages.containsKey(string4)) {
                if (this.xmlFileToPackage.containsKey(string)) {
                    return this.getPackageById(string4);
                }
                throw new RuntimeException("Can't open two packages with the same Id");
            }
            ArrayList<Package> arrayList = (ArrayList<Package>)this.idToPackages.get(string4);
            if (arrayList == null) {
                arrayList = new ArrayList<Package>();
            }
            arrayList.add(package_);
            this.idToPackages.put(string4, arrayList);
            this.xmlFileToPackage.put(string, package_);
            try {
                this.packageToParentDirectory.put(package_, file.getParentFile().getCanonicalPath());
            }
            catch (Exception exception) {
                this.packageToParentDirectory.put(package_, file.getParentFile().getAbsolutePath());
            }
            for (ExternalPackage externalPackage : package_.getExternalPackages().toElements()) {
                String string5 = externalPackage.getHref();
                String string6 = externalPackage.getId();
                if (bl) {
                    String string7 = XMLUtil.getCanonicalPath(string5, string3, false);
                    Package package_2 = this.openPackageRecursively(string7, bl);
                    string6 = package_2.getId();
                } else if (string6 == null) {
                    string6 = XMLUtil.getExternalPackageId(string5);
                }
                package_.addExternalPackageMapping(string5, string6);
            }
        } else {
            System.err.println("Problems with opening file " + string);
        }
        return package_;
    }

    @Override
    public Package openPackagesFromStreams(List list, boolean bl) throws Exception {
        Package package_ = null;
        for (int i = 0; i < list.size(); ++i) {
            byte[] byArray = (byte[])list.get(i);
            Package package_2 = this.openPackageFromStream(byArray, bl);
            if (i != 0) continue;
            package_ = package_2;
        }
        return package_;
    }

    @Override
    public Package openPackageFromStream(byte[] byArray, boolean bl) throws Exception {
        String string;
        Package package_ = null;
        if (bl) {
            string = new String(byArray, "UTF8");
            package_ = this.parseDocument(string, false);
        } else {
            package_ = (Package)XMLUtil.deserialize(byArray);
        }
        if (package_ != null) {
            string = package_.getId();
            ArrayList<Package> arrayList = (ArrayList<Package>)this.idToPackages.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<Package>();
            }
            if (!arrayList.contains(package_)) {
                arrayList.add(package_);
            }
            this.idToPackages.put(string, arrayList);
            for (ExternalPackage externalPackage : package_.getExternalPackages().toElements()) {
                String string2 = externalPackage.getHref();
                String string3 = externalPackage.getId();
                if (string3 == null) {
                    string3 = XMLUtil.getExternalPackageId(string2);
                }
                package_.addExternalPackageMapping(string2, string3);
            }
        }
        return package_;
    }

    @Override
    public Package parseDocument(String string, boolean bl) {
        Package package_ = null;
        DOMParser dOMParser = new DOMParser();
        try {
            Object object;
            dOMParser.setLocale(this.locale);
            dOMParser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            ParsingErrors parsingErrors = new ParsingErrors();
            dOMParser.setErrorHandler((ErrorHandler)parsingErrors);
            if (this.isValidationON) {
                dOMParser.setEntityResolver((EntityResolver)new XPDLEntityResolver());
                dOMParser.setFeature("http://xml.org/sax/features/validation", true);
                dOMParser.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            if (bl) {
                object = new File(string);
                if (!((File)object).exists()) {
                    object = new File(((File)object).getCanonicalPath());
                }
                dOMParser.parse(new InputSource(new FileInputStream((File)object)));
            } else {
                dOMParser.parse(new InputSource(new StringReader(string)));
            }
            object = dOMParser.getDocument();
            List list = parsingErrors.getErrorMessages();
            if (list.size() > 0) {
                if (bl) {
                    this.parsingErrorMessages.put(string, list);
                } else {
                    this.parsingErrorMessages.put("", list);
                }
            }
            if (object != null) {
                package_ = new Package();
                this.getXPDLRepositoryHandler().fromXML(object.getDocumentElement(), package_);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Fatal error while parsing document");
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("Fatal error while parsing document:" + exception.getMessage());
            if (bl) {
                this.parsingErrorMessages.put(string, hashSet);
            } else {
                this.parsingErrorMessages.put("", hashSet);
            }
            return null;
        }
        return package_;
    }

    @Override
    public Map getParsingErrorMessages() {
        return this.parsingErrorMessages;
    }

    @Override
    public synchronized List closePackages(String string) {
        ArrayList arrayList = (ArrayList)this.idToPackages.remove(string);
        if (arrayList != null) {
            for (Package package_ : arrayList) {
                Iterator iterator = this.xmlFileToPackage.entrySet().iterator();
                Object var6_6 = null;
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Object k = entry.getKey();
                    Object v = entry.getValue();
                    if (!v.equals(package_)) continue;
                    var6_6 = k;
                    break;
                }
                if (var6_6 != null) {
                    this.xmlFileToPackage.remove(var6_6);
                }
                this.packageToParentDirectory.remove(package_);
            }
        }
        return arrayList;
    }

    @Override
    public synchronized Package closePackageVersion(String string, String string2) {
        ArrayList arrayList = (ArrayList)this.idToPackages.get(string);
        if (arrayList != null && arrayList.size() == 1) {
            return (Package)this.closePackages(string).get(0);
        }
        Object object = null;
        if (arrayList != null) {
            for (Object object2 : arrayList) {
                if (!((Package)object2).getInternalVersion().equals(string2)) continue;
                object = object2;
                break;
            }
            if (object != null) {
                Object object2;
                object2 = this.xmlFileToPackage.entrySet().iterator();
                Object var7_7 = null;
                while (object2.hasNext()) {
                    Map.Entry entry = (Map.Entry)object2.next();
                    Object k = entry.getKey();
                    Object v = entry.getValue();
                    if (!v.equals(object)) continue;
                    var7_7 = k;
                    break;
                }
                if (var7_7 != null) {
                    this.xmlFileToPackage.remove(var7_7);
                }
                this.packageToParentDirectory.remove(object);
                arrayList.remove(object);
            }
        }
        return object;
    }

    @Override
    public synchronized void closeAllPackages() {
        this.idToPackages.clear();
        this.xmlFileToPackage.clear();
        this.packageToParentDirectory.clear();
    }

    @Override
    public synchronized void synchronizePackages(XMLInterface xMLInterface) {
        this.closeAllPackages();
        for (Package package_ : xMLInterface.getAllPackages()) {
            String string;
            String string2 = package_.getId();
            ArrayList<Package> arrayList = (ArrayList<Package>)this.idToPackages.get(string2);
            if (arrayList == null) {
                arrayList = new ArrayList<Package>();
            }
            arrayList.add(package_);
            this.idToPackages.put(string2, arrayList);
            String string3 = xMLInterface.getAbsoluteFilePath(package_);
            if (string3 != null) {
                this.xmlFileToPackage.put(string3, package_);
            }
            if ((string = xMLInterface.getParentDirectory(package_)) == null) continue;
            this.packageToParentDirectory.put(package_, string);
        }
    }

    public XPDLRepositoryHandler getXPDLRepositoryHandler() {
        if (this.xpdlRep == null) {
            this.xpdlRep = new XPDLRepositoryHandler();
        }
        return this.xpdlRep;
    }

    public void setXPDLRepositoryHandler(XPDLRepositoryHandler xPDLRepositoryHandler) {
        this.xpdlRep = xPDLRepositoryHandler;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

