/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jxpdl.elements;

import java.util.ArrayList;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLInterface;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Application;
import org.enhydra.jxpdl.elements.ExtendedAttribute;
import org.enhydra.jxpdl.utilities.SequencedHashMap;

public class ExtendedAttributes
extends XMLCollection {
    public transient SequencedHashMap eaMap;
    protected String extAttribsString;

    public ExtendedAttributes(XMLComplexElement xMLComplexElement) {
        super(xMLComplexElement, false);
    }

    @Override
    public void makeAs(XMLElement xMLElement) {
        super.makeAs(xMLElement);
        this.extAttribsString = ((ExtendedAttributes)xMLElement).extAttribsString;
    }

    @Override
    public XMLElement generateNewElement() {
        return new ExtendedAttribute(this);
    }

    public ExtendedAttribute getFirstExtendedAttributeForName(String string) {
        ExtendedAttribute extendedAttribute = null;
        ArrayList arrayList = this.getElementsForName(string);
        if (arrayList != null && arrayList.size() > 0) {
            extendedAttribute = (ExtendedAttribute)arrayList.get(0);
        }
        return extendedAttribute;
    }

    @Override
    public void initCaches(XMLInterface xMLInterface) {
        super.initCaches(xMLInterface);
        for (ExtendedAttribute extendedAttribute : this.elements) {
            String string = extendedAttribute.getName();
            ArrayList<ExtendedAttribute> arrayList = (ArrayList<ExtendedAttribute>)this.eaMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<ExtendedAttribute>();
            }
            arrayList.add(extendedAttribute);
            this.eaMap.put(string, arrayList);
        }
        if (this.parent instanceof Application) {
            this.getExtendedAttributesString();
        }
    }

    public void initExtAttribString() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        if (this.size() > 0) {
            try {
                this.extAttribsString = XMLUtil.stringifyExtendedAttributes(this);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Can't stringify extended attributes!");
            }
        } else {
            this.extAttribsString = "";
        }
    }

    public void clearExtAttribString() {
        this.extAttribsString = null;
    }

    public String getExtendedAttributesString() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        if (this.extAttribsString == null) {
            this.initExtAttribString();
        }
        return this.extAttribsString;
    }

    @Override
    public void clearCaches() {
        this.eaMap = new SequencedHashMap();
        super.clearCaches();
    }

    @Override
    public void clear() {
        if (this.eaMap != null) {
            this.eaMap.clear();
        }
        super.clear();
    }

    @Override
    public boolean containsElement(String string) {
        if (this.isReadOnly && this.cachesInitialized) {
            return this.eaMap.containsKey(string);
        }
        for (ExtendedAttribute extendedAttribute : this.elements) {
            if (!extendedAttribute.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(String string) {
        for (ExtendedAttribute extendedAttribute : this.elements) {
            if (!extendedAttribute.getVValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    public ArrayList getElementsForName(String string) {
        if (this.isReadOnly && this.cachesInitialized) {
            return (ArrayList)this.eaMap.get(string);
        }
        ArrayList<ExtendedAttribute> arrayList = new ArrayList<ExtendedAttribute>();
        for (ExtendedAttribute extendedAttribute : this.elements) {
            if (!extendedAttribute.getName().equals(string)) continue;
            arrayList.add(extendedAttribute);
        }
        return arrayList;
    }

    @Override
    public Object clone() {
        ExtendedAttributes extendedAttributes = (ExtendedAttributes)super.clone();
        extendedAttributes.extAttribsString = this.extAttribsString;
        return extendedAttributes;
    }
}

