/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.reconfiguration;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.components.reconfiguration.ReconfiguratorManager;

public class ReconfiguratorMenu
extends JMenu
implements JaWEComponentView,
ActionListener {
    protected ReconfiguratorManager controller;

    public void configure() {
    }

    public ReconfiguratorMenu(ReconfiguratorManager reconfiguratorManager) {
        this.controller = reconfiguratorManager;
    }

    public void init() {
        this.setText(this.controller.getSettings().getLanguageDependentString(this.controller.getName() + "Label"));
        Map map = JaWEManager.getInstance().getJaWEController().getConfigInfo();
        ButtonGroup buttonGroup = new ButtonGroup();
        String string = JaWEManager.getInstance().getJaWEController().getCurrentConfig();
        for (Map.Entry entry : map.entrySet()) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem((String)entry.getValue());
            if (entry.getKey().equals(string)) {
                jRadioButtonMenuItem.setSelected(true);
            }
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            this.add(jRadioButtonMenuItem);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        boolean bl = Utils.reconfigure((String)JaWEManager.getInstance().getJaWEController().getConfigId(jMenuItem.getText()));
        if (!bl) {
            JaWEManager.getInstance().getJaWEController().message(this.controller.getSettings().getLanguageDependentString("ErrorErrorWhileReconfiguring"), 0);
        }
    }

    public JaWEComponent getJaWEComponent() {
        return this.controller;
    }

    public JComponent getDisplay() {
        return this;
    }
}

