/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import org.enhydra.jawe.JaWEConstants;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;

public class AdditionalResourceManager {
    public static final String ADDITIONAL_LANGUAGE_PROPERTY_FILE = "AdditionalLanguagePropertyFile.";
    protected List propertyFiles = new ArrayList();

    public AdditionalResourceManager(Properties properties) {
        List list = ResourceManager.getResourceStrings(properties, ADDITIONAL_LANGUAGE_PROPERTY_FILE);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(string, ResourceManager.getChoosenLocale());
                    this.propertyFiles.add(resourceBundle);
                    continue;
                }
                catch (Exception exception) {
                    Properties properties2 = new Properties();
                    try {
                        Utils.manageProperties(properties2, this.getCurrentConfigFolder(), string);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    String string2 = string.substring(0, string.indexOf(".properties"));
                    Locale locale = ResourceManager.getChoosenLocale();
                    if (locale.getLanguage().length() > 0) {
                        try {
                            Utils.manageProperties(properties2, this.getCurrentConfigFolder(), string2 + "_" + locale.getLanguage() + ".properties");
                        }
                        catch (Exception exception3) {
                            // empty catch block
                        }
                        if (locale.getCountry().length() > 0) {
                            try {
                                Utils.manageProperties(properties2, this.getCurrentConfigFolder(), string2 + "_" + locale.getLanguage() + "_" + locale.getCountry() + ".properties");
                            }
                            catch (Exception exception4) {
                                // empty catch block
                            }
                            if (locale.getVariant().length() > 0) {
                                try {
                                    Utils.manageProperties(properties2, this.getCurrentConfigFolder(), string2 + "_" + locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant() + ".properties");
                                }
                                catch (Exception exception5) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    this.propertyFiles.add(properties2);
                }
            }
        }
    }

    public String getLanguageDependentString(String string) {
        String string2 = null;
        for (Object e : this.propertyFiles) {
            Object object;
            if (e instanceof ResourceBundle) {
                try {
                    object = (ResourceBundle)e;
                    string2 = ((ResourceBundle)object).getString(string);
                    if (string2 == null) continue;
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            object = (Properties)e;
            string2 = ((Properties)object).getProperty(string);
        }
        return string2;
    }

    protected String getCurrentConfigFolder() {
        String string = JaWEConstants.JAWE_USER_HOME;
        String string2 = System.getProperty("JaWE_CURRENT_CONFIG_HOME");
        if (string2 != null) {
            string = string2;
        }
        return string;
    }
}

