/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.enhydra.jawe.ActionBase;
import org.enhydra.jawe.AdditionalResourceManager;
import org.enhydra.jawe.JaWEAction;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.PropertyMgr;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Settings;
import org.enhydra.jawe.Utils;

public abstract class JaWEComponentSettings
implements Settings {
    protected Map componentAction = new HashMap();
    protected Map componentSettings = new HashMap();
    protected PropertyMgr propertyMgr;
    protected AdditionalResourceManager arm;
    public String PROPERTYFILE_PATH = "org/enhydra/jawe/properties/";
    public String PROPERTYFILE_NAME = "jaweconfiguration.properties";

    public void init(JaWEComponent jaWEComponent) {
        if (this.propertyMgr == null) {
            if (Utils.checkFileExistence(this.PROPERTYFILE_NAME) || Utils.checkResourceExistence(this.PROPERTYFILE_PATH, this.PROPERTYFILE_NAME)) {
                this.manageProperties(jaWEComponent, this.PROPERTYFILE_PATH, this.PROPERTYFILE_NAME);
            } else {
                this.manageProperties(jaWEComponent, "org/enhydra/jawe/properties/", "jaweconfiguration.properties");
            }
        } else if (Utils.checkFileExistence(this.PROPERTYFILE_NAME) || Utils.checkResourceExistence(this.PROPERTYFILE_PATH, this.PROPERTYFILE_NAME)) {
            this.propertyMgr.manageProperties(jaWEComponent, this, this.PROPERTYFILE_PATH, this.PROPERTYFILE_NAME);
        } else {
            this.propertyMgr.manageProperties(jaWEComponent, this, "org/enhydra/jawe/properties/", "jaweconfiguration.properties");
        }
    }

    public abstract void loadDefault(JaWEComponent var1, Properties var2);

    public void setPropertyMgr(PropertyMgr propertyMgr) {
        this.propertyMgr = propertyMgr;
    }

    public PropertyMgr getPropertyMgr() {
        return this.propertyMgr;
    }

    public void clear() {
        this.componentAction.clear();
        this.componentSettings.clear();
    }

    public void addSetting(String string, Object object) {
        this.componentSettings.put(string, object);
    }

    @Override
    public Object getSetting(String string) {
        return this.componentSettings.get(string);
    }

    @Override
    public String getSettingString(String string) {
        Object v = this.componentSettings.get(string);
        if (v instanceof String) {
            return (String)v;
        }
        if (v != null) {
            return v.toString();
        }
        return null;
    }

    @Override
    public int getSettingInt(String string) {
        Object v = this.componentSettings.get(string);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v != null) {
            try {
                int n = Integer.parseInt(this.getSettingString(string));
                return n;
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public boolean getSettingBoolean(String string) {
        Object v = this.componentSettings.get(string);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v != null) {
            return new Boolean(this.getSettingString(string));
        }
        return false;
    }

    @Override
    public double getSettingDouble(String string) {
        Object v = this.componentSettings.get(string);
        if (v instanceof Double) {
            return (Double)v;
        }
        if (v != null) {
            try {
                double d = Double.parseDouble(this.getSettingString(string));
                return d;
            }
            catch (Exception exception) {
                return -1.0;
            }
        }
        return -1.0;
    }

    public Map getActions() {
        return this.componentAction;
    }

    public JaWEAction getAction(String string) {
        return (JaWEAction)this.componentAction.get(string);
    }

    public void addAction(String string, JaWEAction jaWEAction) {
        this.componentAction.put(string, jaWEAction);
    }

    public void adjustActions() {
        Iterator iterator = this.componentAction.values().iterator();
        while (iterator.hasNext()) {
            ActionBase actionBase = ((JaWEAction)iterator.next()).getAction();
            if (actionBase == null) continue;
            actionBase.enableDisableAction();
        }
    }

    public void changeActionState(String string, boolean bl) {
        ActionBase actionBase = ((JaWEAction)this.componentAction.get(string)).getAction();
        actionBase.setEnabled(bl);
    }

    @Override
    public String getLanguageDependentString(String string) {
        return ResourceManager.getLanguageDependentString(this.arm, string);
    }

    public String getMainMenuActionOrder() {
        return "";
    }

    public String getMenuActionOrder(String string) {
        return "";
    }

    public String getToolbarActionOrder(String string) {
        return "";
    }

    public void manageProperties(JaWEComponent jaWEComponent, String string, String string2) {
        Properties properties = new Properties();
        try {
            Utils.manageProperties(properties, string, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.loadDefault(jaWEComponent, properties);
        }
        catch (Exception exception) {
            try {
                this.clear();
                properties = new Properties();
                Utils.copyPropertyFile("org/enhydra/jawe/properties/", "jaweconfiguration.properties", true);
                System.err.println("Invalid configuration setting(s) found in " + string2 + ", the file has been overwritten by the default one!");
                this.loadDefault(jaWEComponent, properties);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }
}

