/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.controller;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jxpdl.XMLAttribute;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLComplexChoice;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLSimpleElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activities;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.Application;
import org.enhydra.jxpdl.elements.Artifact;
import org.enhydra.jxpdl.elements.Artifacts;
import org.enhydra.jxpdl.elements.Association;
import org.enhydra.jxpdl.elements.Associations;
import org.enhydra.jxpdl.elements.DataField;
import org.enhydra.jxpdl.elements.FormalParameter;
import org.enhydra.jxpdl.elements.Lane;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.Participant;
import org.enhydra.jxpdl.elements.Pool;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.TypeDeclaration;
import org.enhydra.jxpdl.elements.WorkflowProcess;
import org.enhydra.jxpdl.elements.WorkflowProcesses;

public class JaWESelectionManager {
    protected JaWEController jc;
    protected List selectedElements = new ArrayList();
    protected Package workingPKG;
    protected WorkflowProcess workingWP;
    protected ActivitySet workingAS;

    public JaWESelectionManager(JaWEController jaWEController) {
        this.jc = jaWEController;
    }

    public void clear() {
        this.selectedElements = new ArrayList();
        this.workingPKG = null;
        this.workingWP = null;
        this.workingAS = null;
    }

    public List getSelectedElements() {
        return new ArrayList(this.selectedElements);
    }

    public XMLElement getSelectedElement() {
        if (this.selectedElements.size() > 0) {
            return (XMLElement)this.selectedElements.get(0);
        }
        return null;
    }

    public void setSelection(XMLElement xMLElement, boolean bl) {
        this.selectedElements = new ArrayList();
        if (xMLElement != null) {
            this.selectedElements.add(xMLElement);
        }
        if (bl) {
            this.setPkgWpAndAs();
        }
        XPDLElementChangeInfo xPDLElementChangeInfo = this.jc.createInfo(xMLElement, 8);
        this.jc.sendEvent(xPDLElementChangeInfo);
    }

    public void setSelection(List list, boolean bl) {
        XMLElement xMLElement;
        if (this.checkSelection(list)) {
            this.selectedElements = list == null ? new ArrayList() : list;
        } else {
            this.selectedElements = new ArrayList();
            this.selectedElements.add(list.get(list.size() - 1));
        }
        if (bl) {
            this.setPkgWpAndAs();
        }
        if (this.selectedElements.size() == 0) {
            return;
        }
        ArrayList arrayList = new ArrayList(this.selectedElements);
        XMLElement xMLElement2 = xMLElement = (XMLElement)arrayList.get(0);
        if (arrayList.size() > 1) {
            xMLElement2 = xMLElement.getParent();
            if (xMLElement2 == null) {
                xMLElement2 = xMLElement;
            }
        } else {
            arrayList.clear();
        }
        XPDLElementChangeInfo xPDLElementChangeInfo = this.jc.createInfo(xMLElement2, arrayList, 8);
        this.jc.sendEvent(xPDLElementChangeInfo);
    }

    public void addToSelection(XMLElement xMLElement) {
        ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
        arrayList.add(xMLElement);
        this.addToSelection(arrayList);
    }

    public void addToSelection(List list) {
        XMLElement xMLElement;
        if (this.canBeAddedToSelection(list)) {
            this.selectedElements.addAll(list);
        } else {
            this.selectedElements = new ArrayList();
            this.selectedElements.add(list.get(list.size() - 1));
        }
        this.setPkgWpAndAs();
        if (this.selectedElements.size() == 0) {
            return;
        }
        ArrayList arrayList = new ArrayList(this.selectedElements);
        XMLElement xMLElement2 = xMLElement = (XMLElement)arrayList.get(0);
        if (arrayList.size() > 1) {
            xMLElement2 = xMLElement.getParent();
            if (xMLElement2 == null) {
                xMLElement2 = xMLElement;
            }
        } else {
            arrayList.clear();
        }
        XPDLElementChangeInfo xPDLElementChangeInfo = this.jc.createInfo(xMLElement2, arrayList, 8);
        this.jc.sendEvent(xPDLElementChangeInfo);
    }

    public void removeFromSelection(XMLElement xMLElement) {
        ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
        arrayList.add(xMLElement);
        this.removeFromSelection(arrayList);
    }

    public void removeFromSelection(List list) {
        HashSet<XMLElement> hashSet = new HashSet<XMLElement>();
        for (int i = 0; i < list.size(); ++i) {
            XMLElement xMLElement = (XMLElement)list.get(i);
            hashSet.add(xMLElement);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.selectedElements.remove(iterator.next());
        }
        this.setPkgWpAndAs();
        this.jc.adjustActions();
    }

    protected void setPkgWpAndAs() {
        if (this.selectedElements.size() != 0) {
            XMLElement xMLElement = (XMLElement)this.selectedElements.get(0);
            this.workingPKG = XMLUtil.getPackage((XMLElement)xMLElement);
            if (this.workingPKG != null) {
                Object object;
                WorkflowProcess workflowProcess = this.workingWP;
                if (workflowProcess != null && !(object = (WorkflowProcesses)workflowProcess.getParent()).contains((XMLElement)workflowProcess)) {
                    workflowProcess = null;
                }
                this.workingWP = XMLUtil.getWorkflowProcess((XMLElement)xMLElement);
                if (this.workingWP == null) {
                    if (workflowProcess != null && XMLUtil.getPackage((XMLElement)workflowProcess) == this.workingPKG) {
                        this.workingWP = workflowProcess;
                    } else {
                        object = this.workingPKG.getWorkflowProcesses().toElements();
                        if (object.size() != 0) {
                            this.workingWP = (WorkflowProcess)object.get(0);
                        }
                    }
                }
                this.workingAS = XMLUtil.getActivitySet((XMLElement)xMLElement);
            } else {
                this.workingWP = null;
                this.workingAS = null;
            }
        } else {
            this.workingPKG = null;
            this.workingWP = null;
            this.workingAS = null;
        }
    }

    public Package getWorkingPKG() {
        return this.workingPKG;
    }

    public String getWorkingPackageId() {
        if (this.workingPKG != null) {
            return this.workingPKG.getId();
        }
        return null;
    }

    public WorkflowProcess getWorkingProcess() {
        return this.workingWP;
    }

    public String getWorkingWorkflowProcessId() {
        if (this.workingWP != null) {
            return this.workingWP.getId();
        }
        return null;
    }

    public ActivitySet getWorkingActivitySet() {
        return this.workingAS;
    }

    public String getWorkingActivitySetId() {
        if (this.workingAS != null) {
            return this.workingAS.getId();
        }
        return null;
    }

    public boolean canBeAddedToSelection(List list) {
        ArrayList arrayList = new ArrayList(this.selectedElements);
        arrayList.addAll(list);
        return this.checkSelection(arrayList);
    }

    public boolean checkSelection(List list) {
        XMLElement xMLElement;
        XMLElement xMLElement2;
        if (list == null) {
            return true;
        }
        if (list.size() <= 1) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        HashSet<XMLElement> hashSet = new HashSet<XMLElement>();
        HashSet<XMLElement> hashSet2 = new HashSet<XMLElement>();
        for (int i = 0; i < list.size(); ++i) {
            XMLElement xMLElement3 = (XMLElement)list.get(i);
            xMLElement2 = xMLElement3.getParent();
            xMLElement = xMLElement3.getClass();
            if (xMLElement3 instanceof Activity) {
                bl = true;
            } else if (xMLElement3 instanceof Transition) {
                bl2 = true;
            } else if (xMLElement3 instanceof Artifact) {
                bl3 = true;
            } else if (xMLElement3 instanceof Association) {
                bl4 = true;
            } else if (!(xMLElement2 instanceof XMLCollection)) {
                bl5 = true;
            } else {
                bl6 = true;
            }
            if (xMLElement2 != null) {
                hashSet.add(xMLElement2);
            }
            hashSet2.add(xMLElement);
        }
        if (bl5) {
            return false;
        }
        if (bl && bl2 && bl4 && !bl6) {
            HashSet<XMLElement> hashSet3 = new HashSet<XMLElement>();
            for (int i = 0; i < list.size(); ++i) {
                xMLElement2 = (XMLElement)list.get(i);
                if (!(xMLElement2 instanceof Activity) && !(xMLElement2 instanceof Transition)) continue;
                xMLElement = xMLElement2.getParent().getParent();
                hashSet3.add(xMLElement);
            }
            if (hashSet3.size() != 1) {
                return false;
            }
            XMLCollectionElement xMLCollectionElement = (XMLCollectionElement)hashSet3.toArray()[0];
            xMLElement2 = (Activities)xMLCollectionElement.get("Activities");
            for (int i = 0; i < list.size(); ++i) {
                XMLElement xMLElement4 = (XMLElement)list.get(i);
                if (!(xMLElement4 instanceof Association)) continue;
                Association association = (Association)list.get(i);
                Activity activity = xMLElement2.getActivity(association.getSource());
                Activity activity2 = xMLElement2.getActivity(association.getTarget());
                if (activity != null && activity.getParent().getParent() == xMLCollectionElement || activity2 != null && activity2.getParent().getParent() == xMLCollectionElement) continue;
                return false;
            }
            return true;
        }
        if (bl && bl2 && !bl6) {
            HashSet<XMLElement> hashSet4 = new HashSet<XMLElement>();
            for (int i = 0; i < list.size(); ++i) {
                xMLElement2 = ((XMLElement)list.get(i)).getParent().getParent();
                hashSet4.add(xMLElement2);
            }
            return hashSet4.size() == 1;
        }
        if ((bl3 || bl4) && !bl6) {
            return true;
        }
        return hashSet.size() <= 1 && hashSet2.size() <= 1;
    }

    public boolean canEditProperties() {
        XMLElement xMLElement;
        return this.getSelectedElements().size() == 1 && XMLUtil.getPackage((XMLElement)(xMLElement = (XMLElement)this.selectedElements.get(0))) != null;
    }

    public boolean canCut() {
        return this.checkCutOrCopySelection(true);
    }

    public boolean canCopy() {
        return this.checkCutOrCopySelection(false);
    }

    public boolean canDuplicate() {
        if (this.selectedElements.size() != 1) {
            return false;
        }
        XMLElement xMLElement = (XMLElement)this.selectedElements.get(0);
        XMLElement xMLElement2 = xMLElement.getParent();
        if (!(xMLElement2 instanceof XMLCollection)) {
            return false;
        }
        return this.jc.canDuplicateElement((XMLCollection)xMLElement2, xMLElement);
    }

    public boolean canInsertNew() {
        if (this.selectedElements.size() == 0) {
            return false;
        }
        XMLElement xMLElement = (XMLElement)this.selectedElements.get(0);
        XMLElement xMLElement2 = xMLElement.getParent();
        if (!(xMLElement instanceof XMLCollection || xMLElement2 instanceof XMLCollection || xMLElement instanceof Package)) {
            return false;
        }
        if (xMLElement instanceof XMLCollection) {
            return this.jc.canCreateElement((XMLCollection)xMLElement);
        }
        if (xMLElement2 instanceof XMLCollection) {
            return this.jc.canCreateElement((XMLCollection)xMLElement2);
        }
        return xMLElement instanceof Package && !((Package)xMLElement).isReadOnly();
    }

    public boolean canPaste() {
        boolean bl;
        int n;
        Object object;
        if (this.jc.getEdit().getClipboard().size() == 0) {
            return false;
        }
        if (this.selectedElements.size() == 0) {
            return false;
        }
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        Class<?> clazz3 = null;
        Class<?> clazz4 = null;
        for (int i = 0; i < this.jc.getEdit().getClipboard().size(); ++i) {
            object = (XMLElement)this.jc.getEdit().getClipboard().get(i);
            if (object instanceof Pool) continue;
            XMLElement xMLElement = object.getParent();
            if (object instanceof Transition) {
                clazz2 = xMLElement.getClass();
                clazz4 = object.getClass();
                continue;
            }
            clazz = xMLElement.getClass();
            clazz3 = object.getClass();
        }
        Object object2 = null;
        object = null;
        for (n = 0; n < this.selectedElements.size(); ++n) {
            XMLElement xMLElement = (XMLElement)this.selectedElements.get(n);
            if (xMLElement.isReadOnly()) {
                return false;
            }
            if (xMLElement instanceof Transition) {
                object = xMLElement.getClass();
                continue;
            }
            object2 = xMLElement.getClass();
        }
        int n2 = clazz3 == null ? 0 : (object2 == null ? 0 : (n = clazz3 == object2 ? 1 : 0));
        boolean bl2 = clazz4 == null ? false : (object == null ? false : clazz4 == object);
        boolean bl3 = bl = n != 0 || bl2;
        if (bl) {
            return true;
        }
        if (this.selectedElements.size() > 1) {
            return false;
        }
        XMLElement xMLElement = (XMLElement)this.selectedElements.get(0);
        if ((xMLElement instanceof WorkflowProcess || xMLElement instanceof ActivitySet) && (clazz3 == Artifact.class || clazz3 == Association.class)) {
            return true;
        }
        if (xMLElement instanceof XMLAttribute || xMLElement instanceof XMLSimpleElement || xMLElement instanceof XMLComplexChoice) {
            return false;
        }
        if (xMLElement instanceof XMLCollection) {
            Object object3 = object2;
            if (object3 == null) {
                object3 = object;
            }
            return object3 == clazz || object3 == clazz2;
        }
        if (xMLElement instanceof XMLComplexElement) {
            Class<?> clazz5 = clazz;
            if (clazz5 == null) {
                clazz5 = clazz2;
            }
            ArrayList arrayList = ((XMLComplexElement)xMLElement).toElements();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get(i).getClass() != clazz5) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean canDelete() {
        if (this.selectedElements.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            XMLElement xMLElement = (XMLElement)this.selectedElements.get(i);
            XMLElement xMLElement2 = xMLElement.getParent();
            if (!(xMLElement2 instanceof XMLCollection)) {
                return false;
            }
            if (this.jc.canRemoveElement((XMLCollection)xMLElement2, xMLElement)) continue;
            return false;
        }
        return true;
    }

    public boolean canGetReferences() {
        if (this.selectedElements.size() != 1) {
            return false;
        }
        XMLElement xMLElement = (XMLElement)this.selectedElements.get(0);
        return xMLElement instanceof TypeDeclaration || xMLElement instanceof Participant || xMLElement instanceof Application || xMLElement instanceof WorkflowProcess || xMLElement instanceof ActivitySet || xMLElement instanceof DataField || xMLElement instanceof FormalParameter && xMLElement.getParent().getParent() instanceof WorkflowProcess || xMLElement instanceof Activity || xMLElement instanceof Transition || xMLElement instanceof Package || xMLElement instanceof Lane;
    }

    protected boolean checkCutOrCopySelection(boolean bl) {
        if (this.selectedElements.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            Artifact artifact;
            Artifact artifact2;
            Package package_;
            XMLElement xMLElement = (XMLElement)this.selectedElements.get(i);
            XMLElement xMLElement2 = xMLElement.getParent();
            if (xMLElement instanceof Transition) {
                package_ = (Activities)((XMLComplexElement)xMLElement.getParent().getParent()).get("Activities");
                artifact2 = package_.getActivity(((Transition)xMLElement).getFrom());
                artifact = package_.getActivity(((Transition)xMLElement).getTo());
                if (artifact2 == null || artifact == null || !this.selectedElements.contains(artifact2) || !this.selectedElements.contains(artifact)) {
                    return false;
                }
            } else if (xMLElement instanceof Association) {
                package_ = XMLUtil.getPackage((XMLElement)xMLElement);
                artifact2 = package_.getArtifact(((Association)xMLElement).getSource());
                artifact = package_.getArtifact(((Association)xMLElement).getTarget());
                if (artifact2 == null) {
                    artifact2 = package_.getActivity(((Association)xMLElement).getSource());
                }
                if (artifact == null) {
                    artifact = package_.getActivity(((Association)xMLElement).getTarget());
                }
                if (artifact2 == null || artifact == null || !this.selectedElements.contains(artifact2) || !this.selectedElements.contains(artifact)) {
                    return false;
                }
            } else if (!(xMLElement2 instanceof XMLCollection)) {
                return false;
            }
            package_ = (XMLCollection)xMLElement2;
            if (!((xMLElement instanceof Transition || xMLElement instanceof Association || this.jc.canDuplicateElement((XMLCollection)package_, xMLElement, false)) && (this.jc.canInsertElement((XMLCollection)package_, xMLElement, false) && this.jc.canCreateElement((XMLCollection)package_, false) || package_ instanceof Associations || package_ instanceof Artifacts))) {
                return false;
            }
            if (!bl || this.jc.canRemoveElement((XMLCollection)package_, xMLElement)) continue;
            return false;
        }
        return true;
    }

    protected void removeNonExistingElementsFromSelection(List list, List list2) {
        HashSet<XMLElement> hashSet = new HashSet<XMLElement>();
        for (int i = 0; i < list2.size(); ++i) {
            XMLElement xMLElement = (XMLElement)list2.get(i);
            for (int j = 0; j < list.size(); ++j) {
                XMLElement xMLElement2 = (XMLElement)list.get(j);
                if (!XMLUtil.isParentsChild((XMLElement)xMLElement, (XMLElement)xMLElement2)) continue;
                hashSet.add(xMLElement2);
            }
        }
        list.removeAll(hashSet);
    }
}

