/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.controller;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.enhydra.jawe.ChoiceButton;
import org.enhydra.jawe.ChoiceButtonListener;
import org.enhydra.jawe.base.controller.JaWEType;
import org.enhydra.jxpdl.utilities.SequencedHashMap;

public class JaWETypeChoiceButton
extends ChoiceButton
implements ActionListener {
    protected ChoiceButtonListener parent;
    protected SequencedHashMap choiceMap = new SequencedHashMap();
    protected JPopupMenu popup = new JPopupMenu();
    protected Class choiceType;
    protected Class xpdlChoiceType;
    protected Class xpdlChoiceTypeParentForEA;

    public JaWETypeChoiceButton(Class clazz, Class clazz2, Class clazz3, ChoiceButtonListener choiceButtonListener, ImageIcon imageIcon) {
        this.parent = choiceButtonListener;
        this.choiceType = clazz;
        this.xpdlChoiceType = clazz2;
        this.xpdlChoiceTypeParentForEA = clazz3;
        this.setIcon(imageIcon);
        this.addActionListener(this);
        this.setMargin(new Insets(1, 2, 1, 2));
        this.setSize(new Dimension(10, 8));
        this.setAlignmentY(0.5f);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this) {
            this.refresh();
            if (this.choiceMap.size() > 1) {
                this.popup.show(this.getParent(), this.getX(), this.getY() + this.getHeight());
            }
        } else {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            int n = this.popup.getComponentIndex(jMenuItem);
            Object object = this.choiceMap.getValue(n);
            this.parent.selectionChanged(this, object);
            this.choiceMap.clear();
        }
    }

    protected void refresh() {
        this.choiceMap.clear();
        this.popup.removeAll();
        List list = this.parent.getChoices(this);
        if (list != null) {
            for (JaWEType jaWEType : list) {
                this.choiceMap.put((Object)jaWEType.getDisplayName(), (Object)jaWEType);
            }
        }
        if (this.choiceMap.size() > 1) {
            String[] stringArray = new String[this.choiceMap.size()];
            this.choiceMap.keySet().toArray(stringArray);
            for (int i = 0; i < this.choiceMap.size(); ++i) {
                JMenuItem jMenuItem = this.popup.add(stringArray[i]);
                ImageIcon imageIcon = ((JaWEType)this.choiceMap.getValue(i)).getIcon();
                if (imageIcon != null) {
                    jMenuItem.setIcon(imageIcon);
                }
                jMenuItem.addActionListener(this);
            }
        }
        if (this.choiceMap.size() == 1) {
            this.parent.selectionChanged(this, this.choiceMap.getValue(0));
        }
        if (this.choiceMap == null || this.choiceMap.size() == 0) {
            this.parent.selectionChanged(this, null);
        }
    }

    @Override
    public Class getChoiceType() {
        return this.choiceType;
    }

    public Class getXPDLChoiceType() {
        return this.xpdlChoiceType;
    }

    public Class getXPDLChoiceTypeParentForEA() {
        return this.xpdlChoiceTypeParentForEA;
    }
}

