/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.controller.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.enhydra.jawe.ActionBase;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.base.controller.SearchEntity;
import org.enhydra.jawe.base.controller.SearchUtility;
import org.enhydra.jawe.base.editor.StandardXPDLElementEditor;
import org.enhydra.jxpdl.XMLAttribute;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLComplexChoice;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLSimpleElement;

public class Search
extends ActionBase {
    private SearchEntity searchEntity;

    public Search(JaWEComponent jaWEComponent) {
        super(jaWEComponent);
    }

    @Override
    public void enableDisableAction() {
        this.setEnabled(this.getPackage() != null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.searchEntity == null) {
            this.searchEntity = new SearchEntity();
        }
        while (true) {
            StandardXPDLElementEditor standardXPDLElementEditor = new StandardXPDLElementEditor();
            standardXPDLElementEditor.editXPDLElement((XMLElement)this.searchEntity);
            if (standardXPDLElementEditor.getStatus() != 0) break;
            try {
                XMLElement xMLElement;
                List list = new ArrayList();
                if (this.searchEntity.getSearchScope().equals("SCOPE_MAIN_PACKAGE")) {
                    list = SearchUtility.searchElement(this.getPackage(), this.searchEntity);
                } else if (this.searchEntity.getSearchScope().equals("SCOPE_ALL_PACKAGES")) {
                    xMLElement = JaWEManager.getInstance().getXPDLHandler().getAllPackages().iterator();
                    while (xMLElement.hasNext()) {
                        SearchUtility.searchElement((XMLComplexElement)xMLElement.next(), this.searchEntity, list);
                    }
                } else {
                    xMLElement = JaWEManager.getInstance().getJaWEController().getSelectionManager().getSelectedElement();
                    if (xMLElement instanceof XMLComplexElement) {
                        SearchUtility.searchElement((XMLComplexElement)xMLElement, this.searchEntity, list);
                    } else if (xMLElement instanceof XMLCollection) {
                        SearchUtility.searchElement((XMLCollection)xMLElement, this.searchEntity, list);
                    } else if (xMLElement instanceof XMLComplexChoice) {
                        SearchUtility.searchElement((XMLComplexChoice)xMLElement, this.searchEntity, list);
                    } else if (xMLElement instanceof XMLSimpleElement) {
                        SearchUtility.searchElement((XMLSimpleElement)xMLElement, this.searchEntity, list);
                    } else if (xMLElement instanceof XMLAttribute) {
                        SearchUtility.searchElement((XMLAttribute)xMLElement, this.searchEntity, list);
                    }
                }
                xMLElement = new XMLAttribute(null, this.searchEntity.getContainingText(), false);
                XPDLElementChangeInfo xPDLElementChangeInfo = JaWEManager.getInstance().getJaWEController().createInfo(xMLElement, Utils.makeSearchResultList(list), 20);
                if (xPDLElementChangeInfo == null) break;
                JaWEManager.getInstance().getJaWEController().sendEvent(xPDLElementChangeInfo);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JaWEManager.getInstance().getJaWEController().message(ResourceManager.getLanguageDependentString("ErrorSearchFailed") + "\n" + exception.getClass() + ":" + exception.getMessage(), 0);
                continue;
            }
            break;
        }
    }
}

