/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.editor;

import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.base.editor.XPDLElementEditor;
import org.enhydra.jawe.base.panel.InlinePanel;
import org.enhydra.jawe.base.panel.PanelSettings;
import org.enhydra.jawe.base.panel.panels.XMLPanel;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Package;

public class NewStandardXPDLElementEditor
extends JDialog
implements JaWEComponent,
Observer,
XPDLElementEditor {
    protected String type = "OTHER";
    public static final int STATUS_OK = 0;
    public static final int STATUS_CANCEL = 1;
    protected int status = 0;
    protected InlinePanel inlinePanel;
    protected PanelSettings settings;
    protected WindowListener wl = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            NewStandardXPDLElementEditor.this.close();
        }
    };
    protected ActionListener al = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NewStandardXPDLElementEditor.this.close();
        }
    };

    @Override
    public JaWEComponentSettings getSettings() {
        return this.settings;
    }

    public NewStandardXPDLElementEditor(JaWEComponentSettings jaWEComponentSettings) {
        super(JaWEManager.getInstance().getJaWEController().getJaWEFrame());
        this.settings = (PanelSettings)jaWEComponentSettings;
        this.init();
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    @Override
    public JaWEComponentView getView() {
        return this.inlinePanel;
    }

    @Override
    public String getComponentType() {
        return this.type;
    }

    @Override
    public void setComponentType(String string) {
        this.type = string;
    }

    @Override
    public String getName() {
        return "STANDARD_XPDL_EDITOR";
    }

    @Override
    public boolean adjustXPDL(Package package_) {
        return false;
    }

    @Override
    public List checkValidity(XMLElement xMLElement, boolean bl) {
        return null;
    }

    @Override
    public boolean canCreateElement(XMLCollection xMLCollection) {
        return true;
    }

    @Override
    public boolean canInsertElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canModifyElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canModifyElement(XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canRemoveElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canDuplicateElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canRepositionElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public void configure() {
    }

    protected void init() {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            this.inlinePanel = (InlinePanel)classLoader.loadClass(JaWEManager.getInstance().getInlinePanelClassName()).newInstance();
        }
        catch (Exception exception) {
            String string = "NewStandardXPDLElementEditor --> Problems while instantiating InlinePanel class '" + JaWEManager.getInstance().getInlinePanelClassName() + "' - using default implementation!";
            JaWEManager.getInstance().getLoggingManager().error(string, exception);
            this.inlinePanel = new InlinePanel();
        }
        try {
            this.inlinePanel.setJaWEComponent(this);
            this.settings.init(this);
            this.inlinePanel.init();
            JaWEManager.getInstance().getJaWEController().addObserver(this);
            this.initDialog();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public XMLPanel getEditingPanel() {
        return this.inlinePanel.getViewPanel();
    }

    @Override
    public XMLElement getEditingElement() {
        return this.inlinePanel.getActiveElement();
    }

    @Override
    public void editXPDLElement(XMLElement xMLElement) {
        this.inlinePanel.setActiveElement(xMLElement);
        if (xMLElement != null) {
            this.setTitle(JaWEManager.getInstance().getLabelGenerator().getLabel(xMLElement));
        }
        this.setDialogVisible();
    }

    @Override
    public void editXPDLElement() {
        this.editXPDLElement(JaWEManager.getInstance().getJaWEController().getSelectionManager().getSelectedElement());
    }

    protected void setDialogVisible() {
        this.setSize(this.inlinePanel.getDisplay().getSize());
        this.pack();
        if (!this.isVisible()) {
            this.setLocationRelativeTo(this.getParentWindow());
            this.setVisible(true);
        }
        JaWEManager.getInstance().getJaWEController().adjustActions();
    }

    @Override
    public boolean canApplyChanges() {
        return true;
    }

    @Override
    public void requestFocus() {
        try {
            this.inlinePanel.getDisplay().requestFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public Window getWindow() {
        return this;
    }

    @Override
    public Window getParentWindow() {
        return JaWEManager.getInstance().getJaWEController().getJaWEFrame();
    }

    protected void initDialog() {
        try {
            Container container = this.getContentPane();
            container.setLayout(new BoxLayout(container, 1));
            container.add(this.inlinePanel.getDisplay());
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "Cancel");
            this.getRootPane().getInputMap(0).put(KeyStroke.getKeyStroke(27, 0, false), "Cancel");
            this.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewStandardXPDLElementEditor.this.al.actionPerformed(actionEvent);
                }
            });
            this.addWindowListener(this.wl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setDefaultCloseOperation(0);
        this.setResizable(true);
        this.setModal(true);
    }

    public InlinePanel getInlinePanel() {
        return this.inlinePanel;
    }

    @Override
    public void close() {
        int n;
        this.status = 1;
        if (this.inlinePanel.isModified() && ((n = this.inlinePanel.showModifiedWarning()) == 2 || n == 0 && this.inlinePanel.isModified())) {
            return;
        }
        this.setVisible(false);
        this.inlinePanel.setActiveElement(null);
        JaWEManager.getInstance().getJaWEController().adjustActions();
        this.getInlinePanel().cleanup();
        this.dispose();
    }

    @Override
    public XPDLElementEditor getParentEditor() {
        return null;
    }

    @Override
    public void setModified(boolean bl) {
    }

    @Override
    public void setUpdateInProgress(boolean bl) {
    }

    @Override
    public boolean isUpdateInProgress() {
        return false;
    }
}

