/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.logger;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.base.logger.LogPanel;
import org.enhydra.jawe.base.logger.LoggerSettings;
import org.enhydra.jawe.base.logger.LoggingManager;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Package;

public class LoggingManagerComponent
extends LoggingManager
implements JaWEComponent {
    protected String type = "OTHER";
    public static final String DATE_TIME_PATTERN = "yyyy.MM.dd HH:mm:ss:SSS";
    public static SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss:SSS");
    protected LogPanel panel;
    protected LoggerSettings settings = new LoggerSettings();

    public LoggingManagerComponent() {
        this.settings.init(this);
    }

    @Override
    public JaWEComponentSettings getSettings() {
        return this.settings;
    }

    public void init() {
        this.panel = new LogPanel(this);
        this.panel.configure();
        this.panel.init();
    }

    @Override
    public void error(String string, String string2) {
        if (this.panel != null) {
            this.panel.appendText(this.updateMessage(string2));
        }
        System.err.println(string2);
    }

    @Override
    public void error(String string, String string2, Throwable throwable) {
        if (this.panel != null) {
            this.panel.appendText(this.updateMessage(string2));
        }
        System.err.println(string2);
        throwable.printStackTrace();
    }

    @Override
    public void warn(String string, String string2) {
        if (this.panel != null) {
            this.panel.appendText(this.updateMessage(string2));
        }
        System.err.println(string2);
    }

    @Override
    public void warn(String string, String string2, Throwable throwable) {
        if (this.panel != null) {
            this.panel.appendText(this.updateMessage(string2));
        }
        System.err.println(string2);
        throwable.printStackTrace();
    }

    @Override
    public void info(String string, String string2) {
        if (this.panel != null) {
            this.panel.appendText(this.updateMessage(string2));
        }
        System.out.println(string2);
    }

    @Override
    public void info(String string, String string2, Throwable throwable) {
        if (this.panel != null) {
            this.panel.appendText(this.updateMessage(string2));
        }
        System.out.println(string2);
        throwable.printStackTrace();
    }

    @Override
    public void debug(String string, String string2) {
        if (this.panel != null) {
            this.panel.appendText(this.updateMessage(string2));
        }
        System.err.println(string2);
    }

    @Override
    public void debug(String string, String string2, Throwable throwable) {
        if (this.panel != null) {
            this.panel.appendText(this.updateMessage(string2));
        }
        System.err.println(string2);
        throwable.printStackTrace();
    }

    @Override
    public JaWEComponentView getView() {
        return this.panel;
    }

    @Override
    public String getComponentType() {
        return this.type;
    }

    @Override
    public void setComponentType(String string) {
        this.type = string;
    }

    @Override
    public String getName() {
        return "LoggingManagerComponent";
    }

    @Override
    public boolean adjustXPDL(Package package_) {
        return false;
    }

    @Override
    public List checkValidity(XMLElement xMLElement, boolean bl) {
        return null;
    }

    @Override
    public boolean canCreateElement(XMLCollection xMLCollection) {
        return true;
    }

    @Override
    public boolean canInsertElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canModifyElement(XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canRemoveElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canDuplicateElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canRepositionElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    protected String updateMessage(String string) {
        this.settings.adjustActions();
        return "\n" + sdf.format(new Date()) + ":" + string;
    }

    @Override
    public void setUpdateInProgress(boolean bl) {
    }

    @Override
    public boolean isUpdateInProgress() {
        return false;
    }
}

